package software.amazon.awscdk.services.cognito;

/**
 * Props for the UserPool construct.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.727Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * How will a user be able to recover their account?
     * <p>
     * Default: AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AccountRecovery getAccountRecovery() {
        return null;
    }

    /**
     * Attributes which Cognito will look to verify automatically upon user sign up.
     * <p>
     * EMAIL and PHONE are the only available options.
     * <p>
     * Default: - If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default.
     * If absent, no attributes will be auto-verified.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AutoVerifiedAttrs getAutoVerify() {
        return null;
    }

    /**
     * Define a set of custom attributes that can be configured for each user in the user pool.
     * <p>
     * Default: - No custom attributes.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> getCustomAttributes() {
        return null;
    }

    /**
     * Email settings for a user pool.
     * <p>
     * Default: - see defaults on each property of EmailSettings.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.EmailSettings getEmailSettings() {
        return null;
    }

    /**
     * Setting this would explicitly enable or disable SMS role creation.
     * <p>
     * When left unspecified, CDK will determine based on other properties if a role is needed or not.
     * <p>
     * Default: - CDK will determine based on other properties of the user pool if an SMS role should be created or not.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableSmsRole() {
        return null;
    }

    /**
     * Lambda functions to use for supported Cognito triggers.
     * <p>
     * Default: - No Lambda triggers.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolTriggers getLambdaTriggers() {
        return null;
    }

    /**
     * Configure whether users of this user pool can or are required use MFA to sign in.
     * <p>
     * Default: Mfa.OFF
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.Mfa getMfa() {
        return null;
    }

    /**
     * Configure the MFA types that users can use in this user pool.
     * <p>
     * Ignored if <code>mfa</code> is set to <code>OFF</code>.
     * <p>
     * Default: - { sms: true, oneTimePassword: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`.
     * { sms: false, oneTimePassword: false }, otherwise
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.MfaSecondFactor getMfaSecondFactor() {
        return null;
    }

    /**
     * Password policy for this user pool.
     * <p>
     * Default: - see defaults on each property of PasswordPolicy.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.PasswordPolicy getPasswordPolicy() {
        return null;
    }

    /**
     * Whether self sign up should be enabled.
     * <p>
     * This can be further configured via the <code>selfSignUp</code> property.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSelfSignUpEnabled() {
        return null;
    }

    /**
     * Methods in which a user registers or signs in to a user pool.
     * <p>
     * Allows either username with aliases OR sign in with email, phone, or both.
     * <p>
     * Read the sections on usernames and aliases to learn more -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     * <p>
     * To match with 'Option 1' in the above link, with a verified email, this property should be set to
     * <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
     * number, this property should be set to <code>{ email: true, phone: true }</code>.
     * <p>
     * Default: { username: true }
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.SignInAliases getSignInAliases() {
        return null;
    }

    /**
     * Whether sign-in aliases should be evaluated with case sensitivity.
     * <p>
     * For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSignInCaseSensitive() {
        return null;
    }

    /**
     * The IAM role that Cognito will assume while sending SMS messages.
     * <p>
     * Default: - a new IAM role is created
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getSmsRole() {
        return null;
    }

    /**
     * The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
     * <p>
     * Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
     * <p>
     * This property will be ignored if <code>smsRole</code> is not specified.
     * <p>
     * Default: - No external id will be configured
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsRoleExternalId() {
        return null;
    }

    /**
     * The set of attributes that are required for every user in the user pool.
     * <p>
     * Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     * <p>
     * Default: - All standard attributes are optional and mutable.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttributes getStandardAttributes() {
        return null;
    }

    /**
     * Configuration around admins signing up users into a user pool.
     * <p>
     * Default: - see defaults in UserInvitationConfig
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserInvitationConfig getUserInvitation() {
        return null;
    }

    /**
     * Name of the user pool.
     * <p>
     * Default: - automatically generated name by CloudFormation at deploy time
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolName() {
        return null;
    }

    /**
     * Configuration around users signing themselves up to the user pool.
     * <p>
     * Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
     * <p>
     * Default: - see defaults in UserVerificationConfig
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserVerificationConfig getUserVerification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolProps> {
        private software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery;
        private software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes;
        private software.amazon.awscdk.services.cognito.EmailSettings emailSettings;
        private java.lang.Boolean enableSmsRole;
        private software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers;
        private software.amazon.awscdk.services.cognito.Mfa mfa;
        private software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor;
        private software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy;
        private java.lang.Boolean selfSignUpEnabled;
        private software.amazon.awscdk.services.cognito.SignInAliases signInAliases;
        private java.lang.Boolean signInCaseSensitive;
        private software.amazon.awscdk.services.iam.IRole smsRole;
        private java.lang.String smsRoleExternalId;
        private software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes;
        private software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation;
        private java.lang.String userPoolName;
        private software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification;

        /**
         * Sets the value of {@link UserPoolProps#getAccountRecovery}
         * @param accountRecovery How will a user be able to recover their account?.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accountRecovery(software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery) {
            this.accountRecovery = accountRecovery;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getAutoVerify}
         * @param autoVerify Attributes which Cognito will look to verify automatically upon user sign up.
         *                   EMAIL and PHONE are the only available options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoVerify(software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify) {
            this.autoVerify = autoVerify;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getCustomAttributes}
         * @param customAttributes Define a set of custom attributes that can be configured for each user in the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customAttributes(java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getEmailSettings}
         * @param emailSettings Email settings for a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder emailSettings(software.amazon.awscdk.services.cognito.EmailSettings emailSettings) {
            this.emailSettings = emailSettings;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getEnableSmsRole}
         * @param enableSmsRole Setting this would explicitly enable or disable SMS role creation.
         *                      When left unspecified, CDK will determine based on other properties if a role is needed or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableSmsRole(java.lang.Boolean enableSmsRole) {
            this.enableSmsRole = enableSmsRole;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getLambdaTriggers}
         * @param lambdaTriggers Lambda functions to use for supported Cognito triggers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaTriggers(software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers) {
            this.lambdaTriggers = lambdaTriggers;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getMfa}
         * @param mfa Configure whether users of this user pool can or are required use MFA to sign in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfa(software.amazon.awscdk.services.cognito.Mfa mfa) {
            this.mfa = mfa;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getMfaSecondFactor}
         * @param mfaSecondFactor Configure the MFA types that users can use in this user pool.
         *                        Ignored if <code>mfa</code> is set to <code>OFF</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfaSecondFactor(software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor) {
            this.mfaSecondFactor = mfaSecondFactor;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getPasswordPolicy}
         * @param passwordPolicy Password policy for this user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder passwordPolicy(software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSelfSignUpEnabled}
         * @param selfSignUpEnabled Whether self sign up should be enabled.
         *                          This can be further configured via the <code>selfSignUp</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder selfSignUpEnabled(java.lang.Boolean selfSignUpEnabled) {
            this.selfSignUpEnabled = selfSignUpEnabled;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSignInAliases}
         * @param signInAliases Methods in which a user registers or signs in to a user pool.
         *                      Allows either username with aliases OR sign in with email, phone, or both.
         *                      <p>
         *                      Read the sections on usernames and aliases to learn more -
         *                      https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         *                      <p>
         *                      To match with 'Option 1' in the above link, with a verified email, this property should be set to
         *                      <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
         *                      number, this property should be set to <code>{ email: true, phone: true }</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInAliases(software.amazon.awscdk.services.cognito.SignInAliases signInAliases) {
            this.signInAliases = signInAliases;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSignInCaseSensitive}
         * @param signInCaseSensitive Whether sign-in aliases should be evaluated with case sensitivity.
         *                            For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInCaseSensitive(java.lang.Boolean signInCaseSensitive) {
            this.signInCaseSensitive = signInCaseSensitive;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSmsRole}
         * @param smsRole The IAM role that Cognito will assume while sending SMS messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRole(software.amazon.awscdk.services.iam.IRole smsRole) {
            this.smsRole = smsRole;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getSmsRoleExternalId}
         * @param smsRoleExternalId The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
         *                          Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
         *                          <p>
         *                          This property will be ignored if <code>smsRole</code> is not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRoleExternalId(java.lang.String smsRoleExternalId) {
            this.smsRoleExternalId = smsRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getStandardAttributes}
         * @param standardAttributes The set of attributes that are required for every user in the user pool.
         *                           Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder standardAttributes(software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes) {
            this.standardAttributes = standardAttributes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserInvitation}
         * @param userInvitation Configuration around admins signing up users into a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userInvitation(software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation) {
            this.userInvitation = userInvitation;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserPoolName}
         * @param userPoolName Name of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolName(java.lang.String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolProps#getUserVerification}
         * @param userVerification Configuration around users signing themselves up to the user pool.
         *                         Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userVerification(software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolProps build() {
            return new Jsii$Proxy(accountRecovery, autoVerify, customAttributes, emailSettings, enableSmsRole, lambdaTriggers, mfa, mfaSecondFactor, passwordPolicy, selfSignUpEnabled, signInAliases, signInCaseSensitive, smsRole, smsRoleExternalId, standardAttributes, userInvitation, userPoolName, userVerification);
        }
    }

    /**
     * An implementation for {@link UserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolProps {
        private final software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery;
        private final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes;
        private final software.amazon.awscdk.services.cognito.EmailSettings emailSettings;
        private final java.lang.Boolean enableSmsRole;
        private final software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers;
        private final software.amazon.awscdk.services.cognito.Mfa mfa;
        private final software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor;
        private final software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy;
        private final java.lang.Boolean selfSignUpEnabled;
        private final software.amazon.awscdk.services.cognito.SignInAliases signInAliases;
        private final java.lang.Boolean signInCaseSensitive;
        private final software.amazon.awscdk.services.iam.IRole smsRole;
        private final java.lang.String smsRoleExternalId;
        private final software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes;
        private final software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation;
        private final java.lang.String userPoolName;
        private final software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountRecovery = this.jsiiGet("accountRecovery", software.amazon.awscdk.services.cognito.AccountRecovery.class);
            this.autoVerify = this.jsiiGet("autoVerify", software.amazon.awscdk.services.cognito.AutoVerifiedAttrs.class);
            this.customAttributes = this.jsiiGet("customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ICustomAttribute.class)));
            this.emailSettings = this.jsiiGet("emailSettings", software.amazon.awscdk.services.cognito.EmailSettings.class);
            this.enableSmsRole = this.jsiiGet("enableSmsRole", java.lang.Boolean.class);
            this.lambdaTriggers = this.jsiiGet("lambdaTriggers", software.amazon.awscdk.services.cognito.UserPoolTriggers.class);
            this.mfa = this.jsiiGet("mfa", software.amazon.awscdk.services.cognito.Mfa.class);
            this.mfaSecondFactor = this.jsiiGet("mfaSecondFactor", software.amazon.awscdk.services.cognito.MfaSecondFactor.class);
            this.passwordPolicy = this.jsiiGet("passwordPolicy", software.amazon.awscdk.services.cognito.PasswordPolicy.class);
            this.selfSignUpEnabled = this.jsiiGet("selfSignUpEnabled", java.lang.Boolean.class);
            this.signInAliases = this.jsiiGet("signInAliases", software.amazon.awscdk.services.cognito.SignInAliases.class);
            this.signInCaseSensitive = this.jsiiGet("signInCaseSensitive", java.lang.Boolean.class);
            this.smsRole = this.jsiiGet("smsRole", software.amazon.awscdk.services.iam.IRole.class);
            this.smsRoleExternalId = this.jsiiGet("smsRoleExternalId", java.lang.String.class);
            this.standardAttributes = this.jsiiGet("standardAttributes", software.amazon.awscdk.services.cognito.StandardAttributes.class);
            this.userInvitation = this.jsiiGet("userInvitation", software.amazon.awscdk.services.cognito.UserInvitationConfig.class);
            this.userPoolName = this.jsiiGet("userPoolName", java.lang.String.class);
            this.userVerification = this.jsiiGet("userVerification", software.amazon.awscdk.services.cognito.UserVerificationConfig.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery, final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify, final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes, final software.amazon.awscdk.services.cognito.EmailSettings emailSettings, final java.lang.Boolean enableSmsRole, final software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers, final software.amazon.awscdk.services.cognito.Mfa mfa, final software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor, final software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy, final java.lang.Boolean selfSignUpEnabled, final software.amazon.awscdk.services.cognito.SignInAliases signInAliases, final java.lang.Boolean signInCaseSensitive, final software.amazon.awscdk.services.iam.IRole smsRole, final java.lang.String smsRoleExternalId, final software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes, final software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation, final java.lang.String userPoolName, final software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountRecovery = accountRecovery;
            this.autoVerify = autoVerify;
            this.customAttributes = customAttributes;
            this.emailSettings = emailSettings;
            this.enableSmsRole = enableSmsRole;
            this.lambdaTriggers = lambdaTriggers;
            this.mfa = mfa;
            this.mfaSecondFactor = mfaSecondFactor;
            this.passwordPolicy = passwordPolicy;
            this.selfSignUpEnabled = selfSignUpEnabled;
            this.signInAliases = signInAliases;
            this.signInCaseSensitive = signInCaseSensitive;
            this.smsRole = smsRole;
            this.smsRoleExternalId = smsRoleExternalId;
            this.standardAttributes = standardAttributes;
            this.userInvitation = userInvitation;
            this.userPoolName = userPoolName;
            this.userVerification = userVerification;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AccountRecovery getAccountRecovery() {
            return this.accountRecovery;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AutoVerifiedAttrs getAutoVerify() {
            return this.autoVerify;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public software.amazon.awscdk.services.cognito.EmailSettings getEmailSettings() {
            return this.emailSettings;
        }

        @Override
        public java.lang.Boolean getEnableSmsRole() {
            return this.enableSmsRole;
        }

        @Override
        public software.amazon.awscdk.services.cognito.UserPoolTriggers getLambdaTriggers() {
            return this.lambdaTriggers;
        }

        @Override
        public software.amazon.awscdk.services.cognito.Mfa getMfa() {
            return this.mfa;
        }

        @Override
        public software.amazon.awscdk.services.cognito.MfaSecondFactor getMfaSecondFactor() {
            return this.mfaSecondFactor;
        }

        @Override
        public software.amazon.awscdk.services.cognito.PasswordPolicy getPasswordPolicy() {
            return this.passwordPolicy;
        }

        @Override
        public java.lang.Boolean getSelfSignUpEnabled() {
            return this.selfSignUpEnabled;
        }

        @Override
        public software.amazon.awscdk.services.cognito.SignInAliases getSignInAliases() {
            return this.signInAliases;
        }

        @Override
        public java.lang.Boolean getSignInCaseSensitive() {
            return this.signInCaseSensitive;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getSmsRole() {
            return this.smsRole;
        }

        @Override
        public java.lang.String getSmsRoleExternalId() {
            return this.smsRoleExternalId;
        }

        @Override
        public software.amazon.awscdk.services.cognito.StandardAttributes getStandardAttributes() {
            return this.standardAttributes;
        }

        @Override
        public software.amazon.awscdk.services.cognito.UserInvitationConfig getUserInvitation() {
            return this.userInvitation;
        }

        @Override
        public java.lang.String getUserPoolName() {
            return this.userPoolName;
        }

        @Override
        public software.amazon.awscdk.services.cognito.UserVerificationConfig getUserVerification() {
            return this.userVerification;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountRecovery() != null) {
                data.set("accountRecovery", om.valueToTree(this.getAccountRecovery()));
            }
            if (this.getAutoVerify() != null) {
                data.set("autoVerify", om.valueToTree(this.getAutoVerify()));
            }
            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getEmailSettings() != null) {
                data.set("emailSettings", om.valueToTree(this.getEmailSettings()));
            }
            if (this.getEnableSmsRole() != null) {
                data.set("enableSmsRole", om.valueToTree(this.getEnableSmsRole()));
            }
            if (this.getLambdaTriggers() != null) {
                data.set("lambdaTriggers", om.valueToTree(this.getLambdaTriggers()));
            }
            if (this.getMfa() != null) {
                data.set("mfa", om.valueToTree(this.getMfa()));
            }
            if (this.getMfaSecondFactor() != null) {
                data.set("mfaSecondFactor", om.valueToTree(this.getMfaSecondFactor()));
            }
            if (this.getPasswordPolicy() != null) {
                data.set("passwordPolicy", om.valueToTree(this.getPasswordPolicy()));
            }
            if (this.getSelfSignUpEnabled() != null) {
                data.set("selfSignUpEnabled", om.valueToTree(this.getSelfSignUpEnabled()));
            }
            if (this.getSignInAliases() != null) {
                data.set("signInAliases", om.valueToTree(this.getSignInAliases()));
            }
            if (this.getSignInCaseSensitive() != null) {
                data.set("signInCaseSensitive", om.valueToTree(this.getSignInCaseSensitive()));
            }
            if (this.getSmsRole() != null) {
                data.set("smsRole", om.valueToTree(this.getSmsRole()));
            }
            if (this.getSmsRoleExternalId() != null) {
                data.set("smsRoleExternalId", om.valueToTree(this.getSmsRoleExternalId()));
            }
            if (this.getStandardAttributes() != null) {
                data.set("standardAttributes", om.valueToTree(this.getStandardAttributes()));
            }
            if (this.getUserInvitation() != null) {
                data.set("userInvitation", om.valueToTree(this.getUserInvitation()));
            }
            if (this.getUserPoolName() != null) {
                data.set("userPoolName", om.valueToTree(this.getUserPoolName()));
            }
            if (this.getUserVerification() != null) {
                data.set("userVerification", om.valueToTree(this.getUserVerification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolProps.Jsii$Proxy that = (UserPoolProps.Jsii$Proxy) o;

            if (this.accountRecovery != null ? !this.accountRecovery.equals(that.accountRecovery) : that.accountRecovery != null) return false;
            if (this.autoVerify != null ? !this.autoVerify.equals(that.autoVerify) : that.autoVerify != null) return false;
            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            if (this.emailSettings != null ? !this.emailSettings.equals(that.emailSettings) : that.emailSettings != null) return false;
            if (this.enableSmsRole != null ? !this.enableSmsRole.equals(that.enableSmsRole) : that.enableSmsRole != null) return false;
            if (this.lambdaTriggers != null ? !this.lambdaTriggers.equals(that.lambdaTriggers) : that.lambdaTriggers != null) return false;
            if (this.mfa != null ? !this.mfa.equals(that.mfa) : that.mfa != null) return false;
            if (this.mfaSecondFactor != null ? !this.mfaSecondFactor.equals(that.mfaSecondFactor) : that.mfaSecondFactor != null) return false;
            if (this.passwordPolicy != null ? !this.passwordPolicy.equals(that.passwordPolicy) : that.passwordPolicy != null) return false;
            if (this.selfSignUpEnabled != null ? !this.selfSignUpEnabled.equals(that.selfSignUpEnabled) : that.selfSignUpEnabled != null) return false;
            if (this.signInAliases != null ? !this.signInAliases.equals(that.signInAliases) : that.signInAliases != null) return false;
            if (this.signInCaseSensitive != null ? !this.signInCaseSensitive.equals(that.signInCaseSensitive) : that.signInCaseSensitive != null) return false;
            if (this.smsRole != null ? !this.smsRole.equals(that.smsRole) : that.smsRole != null) return false;
            if (this.smsRoleExternalId != null ? !this.smsRoleExternalId.equals(that.smsRoleExternalId) : that.smsRoleExternalId != null) return false;
            if (this.standardAttributes != null ? !this.standardAttributes.equals(that.standardAttributes) : that.standardAttributes != null) return false;
            if (this.userInvitation != null ? !this.userInvitation.equals(that.userInvitation) : that.userInvitation != null) return false;
            if (this.userPoolName != null ? !this.userPoolName.equals(that.userPoolName) : that.userPoolName != null) return false;
            return this.userVerification != null ? this.userVerification.equals(that.userVerification) : that.userVerification == null;
        }

        @Override
        public int hashCode() {
            int result = this.accountRecovery != null ? this.accountRecovery.hashCode() : 0;
            result = 31 * result + (this.autoVerify != null ? this.autoVerify.hashCode() : 0);
            result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
            result = 31 * result + (this.emailSettings != null ? this.emailSettings.hashCode() : 0);
            result = 31 * result + (this.enableSmsRole != null ? this.enableSmsRole.hashCode() : 0);
            result = 31 * result + (this.lambdaTriggers != null ? this.lambdaTriggers.hashCode() : 0);
            result = 31 * result + (this.mfa != null ? this.mfa.hashCode() : 0);
            result = 31 * result + (this.mfaSecondFactor != null ? this.mfaSecondFactor.hashCode() : 0);
            result = 31 * result + (this.passwordPolicy != null ? this.passwordPolicy.hashCode() : 0);
            result = 31 * result + (this.selfSignUpEnabled != null ? this.selfSignUpEnabled.hashCode() : 0);
            result = 31 * result + (this.signInAliases != null ? this.signInAliases.hashCode() : 0);
            result = 31 * result + (this.signInCaseSensitive != null ? this.signInCaseSensitive.hashCode() : 0);
            result = 31 * result + (this.smsRole != null ? this.smsRole.hashCode() : 0);
            result = 31 * result + (this.smsRoleExternalId != null ? this.smsRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.standardAttributes != null ? this.standardAttributes.hashCode() : 0);
            result = 31 * result + (this.userInvitation != null ? this.userInvitation.hashCode() : 0);
            result = 31 * result + (this.userPoolName != null ? this.userPoolName.hashCode() : 0);
            result = 31 * result + (this.userVerification != null ? this.userVerification.hashCode() : 0);
            return result;
        }
    }
}
