package software.amazon.awscdk.services.cognito;

/**
 * Properties to create a new instance of UserPoolIdentityProvider.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.726Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolIdentityProviderProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolIdentityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user pool to which this construct provides identities.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
     * <p>
     * Default: - no attribute mapping
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderProps> {
        private software.amazon.awscdk.services.cognito.IUserPool userPool;
        private software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolIdentityProviderProps build() {
            return new Jsii$Proxy(userPool, attributeMapping);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderProps {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = this.jsiiGet("userPool", software.amazon.awscdk.services.cognito.IUserPool.class);
            this.attributeMapping = this.jsiiGet("attributeMapping", software.amazon.awscdk.services.cognito.AttributeMapping.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cognito.IUserPool userPool, final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(userPool, "userPool is required");
            this.attributeMapping = attributeMapping;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolIdentityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderProps.Jsii$Proxy that = (UserPoolIdentityProviderProps.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
