package software.amazon.awscdk.services.cognito;

/**
 * Properties to initialize UserPoolFacebookIdentityProvider.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.726Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolIdentityProviderFacebookProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderFacebookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolIdentityProviderFacebookProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolIdentityProviderProps {

    /**
     * The client id recognized by Facebook APIs.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The client secret to be accompanied with clientUd for Facebook to authenticate the client.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://developers.facebook.com/docs/facebook-login/security#appsecret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

    /**
     * The Facebook API version to use.
     * <p>
     * Default: - to the oldest version supported by Facebook
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
        return null;
    }

    /**
     * The list of facebook permissions to obtain for getting access to the Facebook profile.
     * <p>
     * Default: [ public_profile ]
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://developers.facebook.com/docs/facebook-login/permissions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderFacebookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderFacebookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderFacebookProps> {
        private java.lang.String clientId;
        private java.lang.String clientSecret;
        private java.lang.String apiVersion;
        private java.util.List<java.lang.String> scopes;
        private software.amazon.awscdk.services.cognito.IUserPool userPool;
        private software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getClientId}
         * @param clientId The client id recognized by Facebook APIs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getClientSecret}
         * @param clientSecret The client secret to be accompanied with clientUd for Facebook to authenticate the client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientSecret(java.lang.String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getApiVersion}
         * @param apiVersion The Facebook API version to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder apiVersion(java.lang.String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getScopes}
         * @param scopes The list of facebook permissions to obtain for getting access to the Facebook profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scopes(java.util.List<java.lang.String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderFacebookProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderFacebookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolIdentityProviderFacebookProps build() {
            return new Jsii$Proxy(clientId, clientSecret, apiVersion, scopes, userPool, attributeMapping);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderFacebookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderFacebookProps {
        private final java.lang.String clientId;
        private final java.lang.String clientSecret;
        private final java.lang.String apiVersion;
        private final java.util.List<java.lang.String> scopes;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = this.jsiiGet("clientId", java.lang.String.class);
            this.clientSecret = this.jsiiGet("clientSecret", java.lang.String.class);
            this.apiVersion = this.jsiiGet("apiVersion", java.lang.String.class);
            this.scopes = this.jsiiGet("scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userPool = this.jsiiGet("userPool", software.amazon.awscdk.services.cognito.IUserPool.class);
            this.attributeMapping = this.jsiiGet("attributeMapping", software.amazon.awscdk.services.cognito.AttributeMapping.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String clientId, final java.lang.String clientSecret, final java.lang.String apiVersion, final java.util.List<java.lang.String> scopes, final software.amazon.awscdk.services.cognito.IUserPool userPool, final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(clientId, "clientId is required");
            this.clientSecret = java.util.Objects.requireNonNull(clientSecret, "clientSecret is required");
            this.apiVersion = apiVersion;
            this.scopes = scopes;
            this.userPool = java.util.Objects.requireNonNull(userPool, "userPool is required");
            this.attributeMapping = attributeMapping;
        }

        @Override
        public java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public java.lang.String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public java.lang.String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        public java.util.List<java.lang.String> getScopes() {
            return this.scopes;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            if (this.getApiVersion() != null) {
                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
            }
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolIdentityProviderFacebookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderFacebookProps.Jsii$Proxy that = (UserPoolIdentityProviderFacebookProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!clientSecret.equals(that.clientSecret)) return false;
            if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.clientSecret.hashCode());
            result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
