package software.amazon.awscdk.services.cognito;

/**
 * Options to create a UserPoolDomain.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.716Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolDomainOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolDomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolDomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     * <p>
     * Default: - not set if `customDomain` is specified, otherwise, throws an error.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CognitoDomainOptions getCognitoDomain() {
        return null;
    }

    /**
     * Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     * <p>
     * Default: - not set if `cognitoDomain` is specified, otherwise, throws an error.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CustomDomainOptions getCustomDomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolDomainOptions> {
        private software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        private software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Sets the value of {@link UserPoolDomainOptions#getCognitoDomain}
         * @param cognitoDomain Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cognitoDomain(software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain) {
            this.cognitoDomain = cognitoDomain;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolDomainOptions#getCustomDomain}
         * @param customDomain Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customDomain(software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolDomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolDomainOptions build() {
            return new Jsii$Proxy(cognitoDomain, customDomain);
        }
    }

    /**
     * An implementation for {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolDomainOptions {
        private final software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        private final software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cognitoDomain = this.jsiiGet("cognitoDomain", software.amazon.awscdk.services.cognito.CognitoDomainOptions.class);
            this.customDomain = this.jsiiGet("customDomain", software.amazon.awscdk.services.cognito.CustomDomainOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain, final software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cognitoDomain = cognitoDomain;
            this.customDomain = customDomain;
        }

        @Override
        public software.amazon.awscdk.services.cognito.CognitoDomainOptions getCognitoDomain() {
            return this.cognitoDomain;
        }

        @Override
        public software.amazon.awscdk.services.cognito.CustomDomainOptions getCustomDomain() {
            return this.customDomain;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCognitoDomain() != null) {
                data.set("cognitoDomain", om.valueToTree(this.getCognitoDomain()));
            }
            if (this.getCustomDomain() != null) {
                data.set("customDomain", om.valueToTree(this.getCustomDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolDomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolDomainOptions.Jsii$Proxy that = (UserPoolDomainOptions.Jsii$Proxy) o;

            if (this.cognitoDomain != null ? !this.cognitoDomain.equals(that.cognitoDomain) : that.cognitoDomain != null) return false;
            return this.customDomain != null ? this.customDomain.equals(that.customDomain) : that.customDomain == null;
        }

        @Override
        public int hashCode() {
            int result = this.cognitoDomain != null ? this.cognitoDomain.hashCode() : 0;
            result = 31 * result + (this.customDomain != null ? this.customDomain.hashCode() : 0);
            return result;
        }
    }
}
