package software.amazon.awscdk.services.cognito;

/**
 * Properties for the UserPoolClient construct.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolClientProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolClientProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolClientProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolClientOptions {

    /**
     * The UserPool resource this client will have access to.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * @return a {@link Builder} of {@link UserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolClientProps> {
        private software.amazon.awscdk.services.cognito.IUserPool userPool;
        private software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private java.lang.Boolean disableOAuth;
        private java.lang.Boolean generateSecret;
        private software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private java.lang.Boolean preventUserExistenceErrors;
        private java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private java.lang.String userPoolClientName;

        /**
         * Sets the value of {@link UserPoolClientProps#getUserPool}
         * @param userPool The UserPool resource this client will have access to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getAuthFlows}
         * @param authFlows The set of OAuth authentication flows to enable on the client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authFlows(software.amazon.awscdk.services.cognito.AuthFlow authFlows) {
            this.authFlows = authFlows;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getDisableOAuth}
         * @param disableOAuth Turns off all OAuth interactions for this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableOAuth(java.lang.Boolean disableOAuth) {
            this.disableOAuth = disableOAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getGenerateSecret}
         * @param generateSecret Whether to generate a client secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecret(java.lang.Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getOAuth}
         * @param oAuth OAuth settings for this to client to interact with the app.
         *              An error is thrown when this is specified and <code>disableOAuth</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oAuth(software.amazon.awscdk.services.cognito.OAuthSettings oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getPreventUserExistenceErrors}
         * @param preventUserExistenceErrors Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preventUserExistenceErrors(java.lang.Boolean preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getSupportedIdentityProviders}
         * @param supportedIdentityProviders The list of identity providers that users should be able to use to sign in using this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportedIdentityProviders(java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.supportedIdentityProviders = supportedIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientProps#getUserPoolClientName}
         * @param userPoolClientName Name of the application client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClientName(java.lang.String userPoolClientName) {
            this.userPoolClientName = userPoolClientName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolClientProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolClientProps build() {
            return new Jsii$Proxy(userPool, authFlows, disableOAuth, generateSecret, oAuth, preventUserExistenceErrors, supportedIdentityProviders, userPoolClientName);
        }
    }

    /**
     * An implementation for {@link UserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolClientProps {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private final java.lang.Boolean disableOAuth;
        private final java.lang.Boolean generateSecret;
        private final software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private final java.lang.Boolean preventUserExistenceErrors;
        private final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private final java.lang.String userPoolClientName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = this.jsiiGet("userPool", software.amazon.awscdk.services.cognito.IUserPool.class);
            this.authFlows = this.jsiiGet("authFlows", software.amazon.awscdk.services.cognito.AuthFlow.class);
            this.disableOAuth = this.jsiiGet("disableOAuth", java.lang.Boolean.class);
            this.generateSecret = this.jsiiGet("generateSecret", java.lang.Boolean.class);
            this.oAuth = this.jsiiGet("oAuth", software.amazon.awscdk.services.cognito.OAuthSettings.class);
            this.preventUserExistenceErrors = this.jsiiGet("preventUserExistenceErrors", java.lang.Boolean.class);
            this.supportedIdentityProviders = this.jsiiGet("supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class)));
            this.userPoolClientName = this.jsiiGet("userPoolClientName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cognito.IUserPool userPool, final software.amazon.awscdk.services.cognito.AuthFlow authFlows, final java.lang.Boolean disableOAuth, final java.lang.Boolean generateSecret, final software.amazon.awscdk.services.cognito.OAuthSettings oAuth, final java.lang.Boolean preventUserExistenceErrors, final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders, final java.lang.String userPoolClientName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(userPool, "userPool is required");
            this.authFlows = authFlows;
            this.disableOAuth = disableOAuth;
            this.generateSecret = generateSecret;
            this.oAuth = oAuth;
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            this.supportedIdentityProviders = supportedIdentityProviders;
            this.userPoolClientName = userPoolClientName;
        }

        @Override
        public software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AuthFlow getAuthFlows() {
            return this.authFlows;
        }

        @Override
        public java.lang.Boolean getDisableOAuth() {
            return this.disableOAuth;
        }

        @Override
        public java.lang.Boolean getGenerateSecret() {
            return this.generateSecret;
        }

        @Override
        public software.amazon.awscdk.services.cognito.OAuthSettings getOAuth() {
            return this.oAuth;
        }

        @Override
        public java.lang.Boolean getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public java.lang.String getUserPoolClientName() {
            return this.userPoolClientName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAuthFlows() != null) {
                data.set("authFlows", om.valueToTree(this.getAuthFlows()));
            }
            if (this.getDisableOAuth() != null) {
                data.set("disableOAuth", om.valueToTree(this.getDisableOAuth()));
            }
            if (this.getGenerateSecret() != null) {
                data.set("generateSecret", om.valueToTree(this.getGenerateSecret()));
            }
            if (this.getOAuth() != null) {
                data.set("oAuth", om.valueToTree(this.getOAuth()));
            }
            if (this.getPreventUserExistenceErrors() != null) {
                data.set("preventUserExistenceErrors", om.valueToTree(this.getPreventUserExistenceErrors()));
            }
            if (this.getSupportedIdentityProviders() != null) {
                data.set("supportedIdentityProviders", om.valueToTree(this.getSupportedIdentityProviders()));
            }
            if (this.getUserPoolClientName() != null) {
                data.set("userPoolClientName", om.valueToTree(this.getUserPoolClientName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolClientProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolClientProps.Jsii$Proxy that = (UserPoolClientProps.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            if (this.authFlows != null ? !this.authFlows.equals(that.authFlows) : that.authFlows != null) return false;
            if (this.disableOAuth != null ? !this.disableOAuth.equals(that.disableOAuth) : that.disableOAuth != null) return false;
            if (this.generateSecret != null ? !this.generateSecret.equals(that.generateSecret) : that.generateSecret != null) return false;
            if (this.oAuth != null ? !this.oAuth.equals(that.oAuth) : that.oAuth != null) return false;
            if (this.preventUserExistenceErrors != null ? !this.preventUserExistenceErrors.equals(that.preventUserExistenceErrors) : that.preventUserExistenceErrors != null) return false;
            if (this.supportedIdentityProviders != null ? !this.supportedIdentityProviders.equals(that.supportedIdentityProviders) : that.supportedIdentityProviders != null) return false;
            return this.userPoolClientName != null ? this.userPoolClientName.equals(that.userPoolClientName) : that.userPoolClientName == null;
        }

        @Override
        public int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.authFlows != null ? this.authFlows.hashCode() : 0);
            result = 31 * result + (this.disableOAuth != null ? this.disableOAuth.hashCode() : 0);
            result = 31 * result + (this.generateSecret != null ? this.generateSecret.hashCode() : 0);
            result = 31 * result + (this.oAuth != null ? this.oAuth.hashCode() : 0);
            result = 31 * result + (this.preventUserExistenceErrors != null ? this.preventUserExistenceErrors.hashCode() : 0);
            result = 31 * result + (this.supportedIdentityProviders != null ? this.supportedIdentityProviders.hashCode() : 0);
            result = 31 * result + (this.userPoolClientName != null ? this.userPoolClientName.hashCode() : 0);
            return result;
        }
    }
}
