package software.amazon.awscdk.services.cognito;

/**
 * Options to create a UserPoolClient.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolClientOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolClientOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolClientOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of OAuth authentication flows to enable on the client.
     * <p>
     * Default: - all auth flows disabled
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AuthFlow getAuthFlows() {
        return null;
    }

    /**
     * Turns off all OAuth interactions for this client.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableOAuth() {
        return null;
    }

    /**
     * Whether to generate a client secret.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGenerateSecret() {
        return null;
    }

    /**
     * OAuth settings for this to client to interact with the app.
     * <p>
     * An error is thrown when this is specified and <code>disableOAuth</code> is set.
     * <p>
     * Default: - see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OAuthSettings getOAuth() {
        return null;
    }

    /**
     * Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
     * <p>
     * Default: true for new stacks
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreventUserExistenceErrors() {
        return null;
    }

    /**
     * The list of identity providers that users should be able to use to sign in using this client.
     * <p>
     * Default: - supports all identity providers that are registered with the user pool. If the user pool and/or
     * identity providers are imported, either specify this option explicitly or ensure that the identity providers are
     * registered with the user pool using the `UserPool.registerIdentityProvider()` API.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> getSupportedIdentityProviders() {
        return null;
    }

    /**
     * Name of the application client.
     * <p>
     * Default: - cloudformation generated name
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolClientName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolClientOptions> {
        private software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private java.lang.Boolean disableOAuth;
        private java.lang.Boolean generateSecret;
        private software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private java.lang.Boolean preventUserExistenceErrors;
        private java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private java.lang.String userPoolClientName;

        /**
         * Sets the value of {@link UserPoolClientOptions#getAuthFlows}
         * @param authFlows The set of OAuth authentication flows to enable on the client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authFlows(software.amazon.awscdk.services.cognito.AuthFlow authFlows) {
            this.authFlows = authFlows;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getDisableOAuth}
         * @param disableOAuth Turns off all OAuth interactions for this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableOAuth(java.lang.Boolean disableOAuth) {
            this.disableOAuth = disableOAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getGenerateSecret}
         * @param generateSecret Whether to generate a client secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecret(java.lang.Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getOAuth}
         * @param oAuth OAuth settings for this to client to interact with the app.
         *              An error is thrown when this is specified and <code>disableOAuth</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oAuth(software.amazon.awscdk.services.cognito.OAuthSettings oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getPreventUserExistenceErrors}
         * @param preventUserExistenceErrors Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preventUserExistenceErrors(java.lang.Boolean preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getSupportedIdentityProviders}
         * @param supportedIdentityProviders The list of identity providers that users should be able to use to sign in using this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportedIdentityProviders(java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.supportedIdentityProviders = supportedIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getUserPoolClientName}
         * @param userPoolClientName Name of the application client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClientName(java.lang.String userPoolClientName) {
            this.userPoolClientName = userPoolClientName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolClientOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolClientOptions build() {
            return new Jsii$Proxy(authFlows, disableOAuth, generateSecret, oAuth, preventUserExistenceErrors, supportedIdentityProviders, userPoolClientName);
        }
    }

    /**
     * An implementation for {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolClientOptions {
        private final software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private final java.lang.Boolean disableOAuth;
        private final java.lang.Boolean generateSecret;
        private final software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private final java.lang.Boolean preventUserExistenceErrors;
        private final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private final java.lang.String userPoolClientName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authFlows = this.jsiiGet("authFlows", software.amazon.awscdk.services.cognito.AuthFlow.class);
            this.disableOAuth = this.jsiiGet("disableOAuth", java.lang.Boolean.class);
            this.generateSecret = this.jsiiGet("generateSecret", java.lang.Boolean.class);
            this.oAuth = this.jsiiGet("oAuth", software.amazon.awscdk.services.cognito.OAuthSettings.class);
            this.preventUserExistenceErrors = this.jsiiGet("preventUserExistenceErrors", java.lang.Boolean.class);
            this.supportedIdentityProviders = this.jsiiGet("supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class)));
            this.userPoolClientName = this.jsiiGet("userPoolClientName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cognito.AuthFlow authFlows, final java.lang.Boolean disableOAuth, final java.lang.Boolean generateSecret, final software.amazon.awscdk.services.cognito.OAuthSettings oAuth, final java.lang.Boolean preventUserExistenceErrors, final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders, final java.lang.String userPoolClientName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authFlows = authFlows;
            this.disableOAuth = disableOAuth;
            this.generateSecret = generateSecret;
            this.oAuth = oAuth;
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            this.supportedIdentityProviders = supportedIdentityProviders;
            this.userPoolClientName = userPoolClientName;
        }

        @Override
        public software.amazon.awscdk.services.cognito.AuthFlow getAuthFlows() {
            return this.authFlows;
        }

        @Override
        public java.lang.Boolean getDisableOAuth() {
            return this.disableOAuth;
        }

        @Override
        public java.lang.Boolean getGenerateSecret() {
            return this.generateSecret;
        }

        @Override
        public software.amazon.awscdk.services.cognito.OAuthSettings getOAuth() {
            return this.oAuth;
        }

        @Override
        public java.lang.Boolean getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public java.lang.String getUserPoolClientName() {
            return this.userPoolClientName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthFlows() != null) {
                data.set("authFlows", om.valueToTree(this.getAuthFlows()));
            }
            if (this.getDisableOAuth() != null) {
                data.set("disableOAuth", om.valueToTree(this.getDisableOAuth()));
            }
            if (this.getGenerateSecret() != null) {
                data.set("generateSecret", om.valueToTree(this.getGenerateSecret()));
            }
            if (this.getOAuth() != null) {
                data.set("oAuth", om.valueToTree(this.getOAuth()));
            }
            if (this.getPreventUserExistenceErrors() != null) {
                data.set("preventUserExistenceErrors", om.valueToTree(this.getPreventUserExistenceErrors()));
            }
            if (this.getSupportedIdentityProviders() != null) {
                data.set("supportedIdentityProviders", om.valueToTree(this.getSupportedIdentityProviders()));
            }
            if (this.getUserPoolClientName() != null) {
                data.set("userPoolClientName", om.valueToTree(this.getUserPoolClientName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolClientOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolClientOptions.Jsii$Proxy that = (UserPoolClientOptions.Jsii$Proxy) o;

            if (this.authFlows != null ? !this.authFlows.equals(that.authFlows) : that.authFlows != null) return false;
            if (this.disableOAuth != null ? !this.disableOAuth.equals(that.disableOAuth) : that.disableOAuth != null) return false;
            if (this.generateSecret != null ? !this.generateSecret.equals(that.generateSecret) : that.generateSecret != null) return false;
            if (this.oAuth != null ? !this.oAuth.equals(that.oAuth) : that.oAuth != null) return false;
            if (this.preventUserExistenceErrors != null ? !this.preventUserExistenceErrors.equals(that.preventUserExistenceErrors) : that.preventUserExistenceErrors != null) return false;
            if (this.supportedIdentityProviders != null ? !this.supportedIdentityProviders.equals(that.supportedIdentityProviders) : that.supportedIdentityProviders != null) return false;
            return this.userPoolClientName != null ? this.userPoolClientName.equals(that.userPoolClientName) : that.userPoolClientName == null;
        }

        @Override
        public int hashCode() {
            int result = this.authFlows != null ? this.authFlows.hashCode() : 0;
            result = 31 * result + (this.disableOAuth != null ? this.disableOAuth.hashCode() : 0);
            result = 31 * result + (this.generateSecret != null ? this.generateSecret.hashCode() : 0);
            result = 31 * result + (this.oAuth != null ? this.oAuth.hashCode() : 0);
            result = 31 * result + (this.preventUserExistenceErrors != null ? this.preventUserExistenceErrors.hashCode() : 0);
            result = 31 * result + (this.supportedIdentityProviders != null ? this.supportedIdentityProviders.hashCode() : 0);
            result = 31 * result + (this.userPoolClientName != null ? this.userPoolClientName.hashCode() : 0);
            return result;
        }
    }
}
