package software.amazon.awscdk.services.cognito;

/**
 * Define a UserPool App Client.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.714Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolClient")
public class UserPoolClient extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.IUserPoolClient {

    protected UserPoolClient(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolClient(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UserPoolClient(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClientProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a user pool client given its id.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolClientId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolClient fromUserPoolClientId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolClientId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolClient.class, "fromUserPoolClientId", software.amazon.awscdk.services.cognito.IUserPoolClient.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolClientId, "userPoolClientId is required") });
    }

    /**
     * The OAuth flows enabled for this client.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.OAuthFlows getOAuthFlows() {
        return this.jsiiGet("oAuthFlows", software.amazon.awscdk.services.cognito.OAuthFlows.class);
    }

    /**
     * Name of the application client.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientId() {
        return this.jsiiGet("userPoolClientId", java.lang.String.class);
    }

    /**
     * The client name that was specified via the `userPoolClientName` property during initialization, throws an error otherwise.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientName() {
        return this.jsiiGet("userPoolClientName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolClient}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolClient> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolClientProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolClientProps.Builder();
        }

        /**
         * The set of OAuth authentication flows to enable on the client.
         * <p>
         * Default: - all auth flows disabled
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
         * @param authFlows The set of OAuth authentication flows to enable on the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authFlows(final software.amazon.awscdk.services.cognito.AuthFlow authFlows) {
            this.props.authFlows(authFlows);
            return this;
        }

        /**
         * Turns off all OAuth interactions for this client.
         * <p>
         * Default: false
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param disableOAuth Turns off all OAuth interactions for this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableOAuth(final java.lang.Boolean disableOAuth) {
            this.props.disableOAuth(disableOAuth);
            return this;
        }

        /**
         * Whether to generate a client secret.
         * <p>
         * Default: false
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param generateSecret Whether to generate a client secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecret(final java.lang.Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        /**
         * OAuth settings for this to client to interact with the app.
         * <p>
         * An error is thrown when this is specified and <code>disableOAuth</code> is set.
         * <p>
         * Default: - see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param oAuth OAuth settings for this to client to interact with the app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oAuth(final software.amazon.awscdk.services.cognito.OAuthSettings oAuth) {
            this.props.oAuth(oAuth);
            return this;
        }

        /**
         * Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
         * <p>
         * Default: true for new stacks
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html
         * @param preventUserExistenceErrors Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preventUserExistenceErrors(final java.lang.Boolean preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        /**
         * The list of identity providers that users should be able to use to sign in using this client.
         * <p>
         * Default: - supports all identity providers that are registered with the user pool. If the user pool and/or
         * identity providers are imported, either specify this option explicitly or ensure that the identity providers are
         * registered with the user pool using the `UserPool.registerIdentityProvider()` API.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param supportedIdentityProviders The list of identity providers that users should be able to use to sign in using this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportedIdentityProviders(final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        /**
         * Name of the application client.
         * <p>
         * Default: - cloudformation generated name
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param userPoolClientName Name of the application client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClientName(final java.lang.String userPoolClientName) {
            this.props.userPoolClientName(userPoolClientName);
            return this;
        }

        /**
         * The UserPool resource this client will have access to.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param userPool The UserPool resource this client will have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolClient}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolClient build() {
            return new software.amazon.awscdk.services.cognito.UserPoolClient(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
