package software.amazon.awscdk.services.cognito;

/**
 * Define a Cognito User Pool.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.713Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPool")
public class UserPool extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.cognito.IUserPool {

    protected UserPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UserPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public UserPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing user pool based on its ARN.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool fromUserPoolArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPool.class, "fromUserPoolArn", software.amazon.awscdk.services.cognito.IUserPool.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolArn, "userPoolArn is required") });
    }

    /**
     * Import an existing user pool based on its id.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool fromUserPoolId(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPool.class, "fromUserPoolId", software.amazon.awscdk.services.cognito.IUserPool.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolId, "userPoolId is required") });
    }

    /**
     * Add a new app client to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolClientOptions options) {
        return this.jsiiCall("addClient", software.amazon.awscdk.services.cognito.UserPoolClient.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add a new app client to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("addClient", software.amazon.awscdk.services.cognito.UserPoolClient.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Associate a domain to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomainOptions options) {
        return this.jsiiCall("addDomain", software.amazon.awscdk.services.cognito.UserPoolDomain.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a lambda trigger to a user pool operation.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
     * @param operation This parameter is required.
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addTrigger(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolOperation operation, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        this.jsiiCall("addTrigger", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(operation, "operation is required"), java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * Register an identity provider with this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param provider This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void registerIdentityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider provider) {
        this.jsiiCall("registerIdentityProvider", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(provider, "provider is required") });
    }

    /**
     * Get all identity providers registered with this user pool.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider> getIdentityProviders() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("identityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider.class))));
    }

    /**
     * The ARN of the user pool.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn() {
        return this.jsiiGet("userPoolArn", java.lang.String.class);
    }

    /**
     * The physical ID of this user pool resource.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return this.jsiiGet("userPoolId", java.lang.String.class);
    }

    /**
     * User pool provider name.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolProviderName() {
        return this.jsiiGet("userPoolProviderName", java.lang.String.class);
    }

    /**
     * User pool provider URL.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolProviderUrl() {
        return this.jsiiGet("userPoolProviderUrl", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPool> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cognito.UserPoolProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * How will a user be able to recover their account?
         * <p>
         * Default: AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param accountRecovery How will a user be able to recover their account?. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accountRecovery(final software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery) {
            this.props().accountRecovery(accountRecovery);
            return this;
        }

        /**
         * Attributes which Cognito will look to verify automatically upon user sign up.
         * <p>
         * EMAIL and PHONE are the only available options.
         * <p>
         * Default: - If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default.
         * If absent, no attributes will be auto-verified.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param autoVerify Attributes which Cognito will look to verify automatically upon user sign up. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoVerify(final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify) {
            this.props().autoVerify(autoVerify);
            return this;
        }

        /**
         * Define a set of custom attributes that can be configured for each user in the user pool.
         * <p>
         * Default: - No custom attributes.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param customAttributes Define a set of custom attributes that can be configured for each user in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customAttributes(final java.util.Map<java.lang.String, software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes) {
            this.props().customAttributes(customAttributes);
            return this;
        }

        /**
         * Email settings for a user pool.
         * <p>
         * Default: - see defaults on each property of EmailSettings.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param emailSettings Email settings for a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder emailSettings(final software.amazon.awscdk.services.cognito.EmailSettings emailSettings) {
            this.props().emailSettings(emailSettings);
            return this;
        }

        /**
         * Setting this would explicitly enable or disable SMS role creation.
         * <p>
         * When left unspecified, CDK will determine based on other properties if a role is needed or not.
         * <p>
         * Default: - CDK will determine based on other properties of the user pool if an SMS role should be created or not.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param enableSmsRole Setting this would explicitly enable or disable SMS role creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableSmsRole(final java.lang.Boolean enableSmsRole) {
            this.props().enableSmsRole(enableSmsRole);
            return this;
        }

        /**
         * Lambda functions to use for supported Cognito triggers.
         * <p>
         * Default: - No Lambda triggers.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
         * @param lambdaTriggers Lambda functions to use for supported Cognito triggers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaTriggers(final software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers) {
            this.props().lambdaTriggers(lambdaTriggers);
            return this;
        }

        /**
         * Configure whether users of this user pool can or are required use MFA to sign in.
         * <p>
         * Default: Mfa.OFF
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param mfa Configure whether users of this user pool can or are required use MFA to sign in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfa(final software.amazon.awscdk.services.cognito.Mfa mfa) {
            this.props().mfa(mfa);
            return this;
        }

        /**
         * Configure the MFA types that users can use in this user pool.
         * <p>
         * Ignored if <code>mfa</code> is set to <code>OFF</code>.
         * <p>
         * Default: - { sms: true, oneTimePassword: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`.
         * { sms: false, oneTimePassword: false }, otherwise
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param mfaSecondFactor Configure the MFA types that users can use in this user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mfaSecondFactor(final software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor) {
            this.props().mfaSecondFactor(mfaSecondFactor);
            return this;
        }

        /**
         * Password policy for this user pool.
         * <p>
         * Default: - see defaults on each property of PasswordPolicy.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param passwordPolicy Password policy for this user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder passwordPolicy(final software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy) {
            this.props().passwordPolicy(passwordPolicy);
            return this;
        }

        /**
         * Whether self sign up should be enabled.
         * <p>
         * This can be further configured via the <code>selfSignUp</code> property.
         * <p>
         * Default: false
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param selfSignUpEnabled Whether self sign up should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder selfSignUpEnabled(final java.lang.Boolean selfSignUpEnabled) {
            this.props().selfSignUpEnabled(selfSignUpEnabled);
            return this;
        }

        /**
         * Methods in which a user registers or signs in to a user pool.
         * <p>
         * Allows either username with aliases OR sign in with email, phone, or both.
         * <p>
         * Read the sections on usernames and aliases to learn more -
         * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * <p>
         * To match with 'Option 1' in the above link, with a verified email, this property should be set to
         * <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
         * number, this property should be set to <code>{ email: true, phone: true }</code>.
         * <p>
         * Default: { username: true }
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param signInAliases Methods in which a user registers or signs in to a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInAliases(final software.amazon.awscdk.services.cognito.SignInAliases signInAliases) {
            this.props().signInAliases(signInAliases);
            return this;
        }

        /**
         * Whether sign-in aliases should be evaluated with case sensitivity.
         * <p>
         * For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
         * <p>
         * Default: true
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param signInCaseSensitive Whether sign-in aliases should be evaluated with case sensitivity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signInCaseSensitive(final java.lang.Boolean signInCaseSensitive) {
            this.props().signInCaseSensitive(signInCaseSensitive);
            return this;
        }

        /**
         * The IAM role that Cognito will assume while sending SMS messages.
         * <p>
         * Default: - a new IAM role is created
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param smsRole The IAM role that Cognito will assume while sending SMS messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRole(final software.amazon.awscdk.services.iam.IRole smsRole) {
            this.props().smsRole(smsRole);
            return this;
        }

        /**
         * The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
         * <p>
         * Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
         * <p>
         * This property will be ignored if <code>smsRole</code> is not specified.
         * <p>
         * Default: - No external id will be configured
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param smsRoleExternalId The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder smsRoleExternalId(final java.lang.String smsRoleExternalId) {
            this.props().smsRoleExternalId(smsRoleExternalId);
            return this;
        }

        /**
         * The set of attributes that are required for every user in the user pool.
         * <p>
         * Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * <p>
         * Default: - All standard attributes are optional and mutable.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param standardAttributes The set of attributes that are required for every user in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder standardAttributes(final software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes) {
            this.props().standardAttributes(standardAttributes);
            return this;
        }

        /**
         * Configuration around admins signing up users into a user pool.
         * <p>
         * Default: - see defaults in UserInvitationConfig
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param userInvitation Configuration around admins signing up users into a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userInvitation(final software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation) {
            this.props().userInvitation(userInvitation);
            return this;
        }

        /**
         * Name of the user pool.
         * <p>
         * Default: - automatically generated name by CloudFormation at deploy time
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param userPoolName Name of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolName(final java.lang.String userPoolName) {
            this.props().userPoolName(userPoolName);
            return this;
        }

        /**
         * Configuration around users signing themselves up to the user pool.
         * <p>
         * Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
         * <p>
         * Default: - see defaults in UserVerificationConfig
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param userVerification Configuration around users signing themselves up to the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userVerification(final software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification) {
            this.props().userVerification(userVerification);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cognito.UserPool build() {
            return new software.amazon.awscdk.services.cognito.UserPool(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cognito.UserPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cognito.UserPoolProps.Builder();
            }
            return this.props;
        }
    }
}
