package software.amazon.awscdk.services.cognito;

/**
 * Password policy for User Pools.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.710Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.PasswordPolicy")
@software.amazon.jsii.Jsii.Proxy(PasswordPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PasswordPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Minimum length required for a user's password.
     * <p>
     * Default: 8
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinLength() {
        return null;
    }

    /**
     * Whether the user is required to have digits in their password.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireDigits() {
        return null;
    }

    /**
     * Whether the user is required to have lowercase characters in their password.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireLowercase() {
        return null;
    }

    /**
     * Whether the user is required to have symbols in their password.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireSymbols() {
        return null;
    }

    /**
     * Whether the user is required to have uppercase characters in their password.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireUppercase() {
        return null;
    }

    /**
     * The length of time the temporary password generated by an admin is valid.
     * <p>
     * This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
     * Fractional days, such as Duration.hours(20), will generate an error.
     * <p>
     * Default: Duration.days(7)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTempPasswordValidity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PasswordPolicy> {
        private java.lang.Number minLength;
        private java.lang.Boolean requireDigits;
        private java.lang.Boolean requireLowercase;
        private java.lang.Boolean requireSymbols;
        private java.lang.Boolean requireUppercase;
        private software.amazon.awscdk.core.Duration tempPasswordValidity;

        /**
         * Sets the value of {@link PasswordPolicy#getMinLength}
         * @param minLength Minimum length required for a user's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minLength(java.lang.Number minLength) {
            this.minLength = minLength;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireDigits}
         * @param requireDigits Whether the user is required to have digits in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requireDigits(java.lang.Boolean requireDigits) {
            this.requireDigits = requireDigits;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireLowercase}
         * @param requireLowercase Whether the user is required to have lowercase characters in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requireLowercase(java.lang.Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireSymbols}
         * @param requireSymbols Whether the user is required to have symbols in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requireSymbols(java.lang.Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getRequireUppercase}
         * @param requireUppercase Whether the user is required to have uppercase characters in their password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requireUppercase(java.lang.Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        /**
         * Sets the value of {@link PasswordPolicy#getTempPasswordValidity}
         * @param tempPasswordValidity The length of time the temporary password generated by an admin is valid.
         *                             This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
         *                             Fractional days, such as Duration.hours(20), will generate an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tempPasswordValidity(software.amazon.awscdk.core.Duration tempPasswordValidity) {
            this.tempPasswordValidity = tempPasswordValidity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PasswordPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PasswordPolicy build() {
            return new Jsii$Proxy(minLength, requireDigits, requireLowercase, requireSymbols, requireUppercase, tempPasswordValidity);
        }
    }

    /**
     * An implementation for {@link PasswordPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PasswordPolicy {
        private final java.lang.Number minLength;
        private final java.lang.Boolean requireDigits;
        private final java.lang.Boolean requireLowercase;
        private final java.lang.Boolean requireSymbols;
        private final java.lang.Boolean requireUppercase;
        private final software.amazon.awscdk.core.Duration tempPasswordValidity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minLength = this.jsiiGet("minLength", java.lang.Number.class);
            this.requireDigits = this.jsiiGet("requireDigits", java.lang.Boolean.class);
            this.requireLowercase = this.jsiiGet("requireLowercase", java.lang.Boolean.class);
            this.requireSymbols = this.jsiiGet("requireSymbols", java.lang.Boolean.class);
            this.requireUppercase = this.jsiiGet("requireUppercase", java.lang.Boolean.class);
            this.tempPasswordValidity = this.jsiiGet("tempPasswordValidity", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number minLength, final java.lang.Boolean requireDigits, final java.lang.Boolean requireLowercase, final java.lang.Boolean requireSymbols, final java.lang.Boolean requireUppercase, final software.amazon.awscdk.core.Duration tempPasswordValidity) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minLength = minLength;
            this.requireDigits = requireDigits;
            this.requireLowercase = requireLowercase;
            this.requireSymbols = requireSymbols;
            this.requireUppercase = requireUppercase;
            this.tempPasswordValidity = tempPasswordValidity;
        }

        @Override
        public java.lang.Number getMinLength() {
            return this.minLength;
        }

        @Override
        public java.lang.Boolean getRequireDigits() {
            return this.requireDigits;
        }

        @Override
        public java.lang.Boolean getRequireLowercase() {
            return this.requireLowercase;
        }

        @Override
        public java.lang.Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public java.lang.Boolean getRequireUppercase() {
            return this.requireUppercase;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTempPasswordValidity() {
            return this.tempPasswordValidity;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMinLength() != null) {
                data.set("minLength", om.valueToTree(this.getMinLength()));
            }
            if (this.getRequireDigits() != null) {
                data.set("requireDigits", om.valueToTree(this.getRequireDigits()));
            }
            if (this.getRequireLowercase() != null) {
                data.set("requireLowercase", om.valueToTree(this.getRequireLowercase()));
            }
            if (this.getRequireSymbols() != null) {
                data.set("requireSymbols", om.valueToTree(this.getRequireSymbols()));
            }
            if (this.getRequireUppercase() != null) {
                data.set("requireUppercase", om.valueToTree(this.getRequireUppercase()));
            }
            if (this.getTempPasswordValidity() != null) {
                data.set("tempPasswordValidity", om.valueToTree(this.getTempPasswordValidity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.PasswordPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PasswordPolicy.Jsii$Proxy that = (PasswordPolicy.Jsii$Proxy) o;

            if (this.minLength != null ? !this.minLength.equals(that.minLength) : that.minLength != null) return false;
            if (this.requireDigits != null ? !this.requireDigits.equals(that.requireDigits) : that.requireDigits != null) return false;
            if (this.requireLowercase != null ? !this.requireLowercase.equals(that.requireLowercase) : that.requireLowercase != null) return false;
            if (this.requireSymbols != null ? !this.requireSymbols.equals(that.requireSymbols) : that.requireSymbols != null) return false;
            if (this.requireUppercase != null ? !this.requireUppercase.equals(that.requireUppercase) : that.requireUppercase != null) return false;
            return this.tempPasswordValidity != null ? this.tempPasswordValidity.equals(that.tempPasswordValidity) : that.tempPasswordValidity == null;
        }

        @Override
        public int hashCode() {
            int result = this.minLength != null ? this.minLength.hashCode() : 0;
            result = 31 * result + (this.requireDigits != null ? this.requireDigits.hashCode() : 0);
            result = 31 * result + (this.requireLowercase != null ? this.requireLowercase.hashCode() : 0);
            result = 31 * result + (this.requireSymbols != null ? this.requireSymbols.hashCode() : 0);
            result = 31 * result + (this.requireUppercase != null ? this.requireUppercase.hashCode() : 0);
            result = 31 * result + (this.tempPasswordValidity != null ? this.tempPasswordValidity.hashCode() : 0);
            return result;
        }
    }
}
