package software.amazon.awscdk.services.cognito;

/**
 * OAuth settings to configure the interaction between the app and this client.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.710Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.OAuthSettings")
@software.amazon.jsii.Jsii.Proxy(OAuthSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OAuthSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of allowed redirect URLs for the identity providers.
     * <p>
     * Default: - ['https://example.com'] if either authorizationCodeGrant or implicitCodeGrant flows are enabled, no callback URLs otherwise.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrls() {
        return null;
    }

    /**
     * OAuth flows that are allowed with this client.
     * <p>
     * Default: {authorizationCodeGrant:true,implicitCodeGrant:true}
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see - the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OAuthFlows getFlows() {
        return null;
    }

    /**
     * OAuth scopes that are allowed with this client.
     * <p>
     * Default: [OAuthScope.PHONE,OAuthScope.EMAIL,OAuthScope.OPENID,OAuthScope.PROFILE,OAuthScope.COGNITO_ADMIN]
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<OAuthSettings> {
        private java.util.List<java.lang.String> callbackUrls;
        private software.amazon.awscdk.services.cognito.OAuthFlows flows;
        private java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes;

        /**
         * Sets the value of {@link OAuthSettings#getCallbackUrls}
         * @param callbackUrls List of allowed redirect URLs for the identity providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder callbackUrls(java.util.List<java.lang.String> callbackUrls) {
            this.callbackUrls = callbackUrls;
            return this;
        }

        /**
         * Sets the value of {@link OAuthSettings#getFlows}
         * @param flows OAuth flows that are allowed with this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder flows(software.amazon.awscdk.services.cognito.OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        /**
         * Sets the value of {@link OAuthSettings#getScopes}
         * @param scopes OAuth scopes that are allowed with this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scopes(java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OAuthSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public OAuthSettings build() {
            return new Jsii$Proxy(callbackUrls, flows, scopes);
        }
    }

    /**
     * An implementation for {@link OAuthSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthSettings {
        private final java.util.List<java.lang.String> callbackUrls;
        private final software.amazon.awscdk.services.cognito.OAuthFlows flows;
        private final java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.callbackUrls = this.jsiiGet("callbackUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.flows = this.jsiiGet("flows", software.amazon.awscdk.services.cognito.OAuthFlows.class);
            this.scopes = this.jsiiGet("scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> callbackUrls, final software.amazon.awscdk.services.cognito.OAuthFlows flows, final java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> scopes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.callbackUrls = callbackUrls;
            this.flows = flows;
            this.scopes = scopes;
        }

        @Override
        public java.util.List<java.lang.String> getCallbackUrls() {
            return this.callbackUrls;
        }

        @Override
        public software.amazon.awscdk.services.cognito.OAuthFlows getFlows() {
            return this.flows;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cognito.OAuthScope> getScopes() {
            return this.scopes;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCallbackUrls() != null) {
                data.set("callbackUrls", om.valueToTree(this.getCallbackUrls()));
            }
            if (this.getFlows() != null) {
                data.set("flows", om.valueToTree(this.getFlows()));
            }
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.OAuthSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OAuthSettings.Jsii$Proxy that = (OAuthSettings.Jsii$Proxy) o;

            if (this.callbackUrls != null ? !this.callbackUrls.equals(that.callbackUrls) : that.callbackUrls != null) return false;
            if (this.flows != null ? !this.flows.equals(that.flows) : that.flows != null) return false;
            return this.scopes != null ? this.scopes.equals(that.scopes) : that.scopes == null;
        }

        @Override
        public int hashCode() {
            int result = this.callbackUrls != null ? this.callbackUrls.hashCode() : 0;
            result = 31 * result + (this.flows != null ? this.flows.hashCode() : 0);
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            return result;
        }
    }
}
