package software.amazon.awscdk.services.cognito;

/**
 * Represents a Cognito UserPool.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.707Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.IUserPool")
@software.amazon.jsii.Jsii.Proxy(IUserPool.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IUserPool extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * Get all identity providers registered with this user pool.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider> getIdentityProviders();

    /**
     * The ARN of this user pool resource.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

    /**
     * The physical ID of this user pool resource.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * Add a new app client to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolClientOptions options);

    /**
     * Add a new app client to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Associate a domain to this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomainOptions options);

    /**
     * Register an identity provider with this user pool.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param provider This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    void registerIdentityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider provider);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cognito.IUserPool {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Get all identity providers registered with this user pool.
         * <p>
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider> getIdentityProviders() {
            return java.util.Collections.unmodifiableList(this.jsiiGet("identityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider.class))));
        }

        /**
         * The ARN of this user pool resource.
         * <p>
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn() {
            return this.jsiiGet("userPoolArn", java.lang.String.class);
        }

        /**
         * The physical ID of this user pool resource.
         * <p>
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
            return this.jsiiGet("userPoolId", java.lang.String.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Add a new app client to this user pool.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html
         * @param id This parameter is required.
         * @param options
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolClientOptions options) {
            return this.jsiiCall("addClient", software.amazon.awscdk.services.cognito.UserPoolClient.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Add a new app client to this user pool.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("addClient", software.amazon.awscdk.services.cognito.UserPoolClient.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Associate a domain to this user pool.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html
         * @param id This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomainOptions options) {
            return this.jsiiCall("addDomain", software.amazon.awscdk.services.cognito.UserPoolDomain.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Register an identity provider with this user pool.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @param provider This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public void registerIdentityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider provider) {
            this.jsiiCall("registerIdentityProvider", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(provider, "provider is required") });
        }
    }
}
