package software.amazon.awscdk.services.cognito;

/**
 * Options while specifying custom domain.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.706Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CustomDomainOptions")
@software.amazon.jsii.Jsii.Proxy(CustomDomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CustomDomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The certificate to associate with this domain.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate();

    /**
     * The custom domain name that you would like to associate with this User Pool.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * @return a {@link Builder} of {@link CustomDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CustomDomainOptions> {
        private software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private java.lang.String domainName;

        /**
         * Sets the value of {@link CustomDomainOptions#getCertificate}
         * @param certificate The certificate to associate with this domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link CustomDomainOptions#getDomainName}
         * @param domainName The custom domain name that you would like to associate with this User Pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomDomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CustomDomainOptions build() {
            return new Jsii$Proxy(certificate, domainName);
        }
    }

    /**
     * An implementation for {@link CustomDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomDomainOptions {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String domainName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate, final java.lang.String domainName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(certificate, "certificate is required");
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificate", om.valueToTree(this.getCertificate()));
            data.set("domainName", om.valueToTree(this.getDomainName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CustomDomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomDomainOptions.Jsii$Proxy that = (CustomDomainOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            return this.domainName.equals(that.domainName);
        }

        @Override
        public int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            return result;
        }
    }
}
