package software.amazon.awscdk.services.cognito;

/**
 * Configuration that will be fed into CloudFormation for any custom attribute type.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CustomAttributeConfig")
@software.amazon.jsii.Jsii.Proxy(CustomAttributeConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CustomAttributeConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The data type of the custom attribute.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SchemaAttributeType.html#CognitoUserPools-Type-SchemaAttributeType-AttributeDataType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getDataType();

    /**
     * Specifies whether the value of the attribute can be changed.
     * <p>
     * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * The constraints for a custom attribute of the 'Number' data type.
     * <p>
     * Default: - None.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.NumberAttributeConstraints getNumberConstraints() {
        return null;
    }

    /**
     * The constraints for a custom attribute of 'String' data type.
     * <p>
     * Default: - None.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StringAttributeConstraints getStringConstraints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CustomAttributeConfig> {
        private java.lang.String dataType;
        private java.lang.Boolean mutable;
        private software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints;
        private software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints;

        /**
         * Sets the value of {@link CustomAttributeConfig#getDataType}
         * @param dataType The data type of the custom attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataType(java.lang.String dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getMutable}
         * @param mutable Specifies whether the value of the attribute can be changed.
         *                For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
         *                Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         *                If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getNumberConstraints}
         * @param numberConstraints The constraints for a custom attribute of the 'Number' data type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder numberConstraints(software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints) {
            this.numberConstraints = numberConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CustomAttributeConfig#getStringConstraints}
         * @param stringConstraints The constraints for a custom attribute of 'String' data type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stringConstraints(software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints) {
            this.stringConstraints = stringConstraints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomAttributeConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CustomAttributeConfig build() {
            return new Jsii$Proxy(dataType, mutable, numberConstraints, stringConstraints);
        }
    }

    /**
     * An implementation for {@link CustomAttributeConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAttributeConfig {
        private final java.lang.String dataType;
        private final java.lang.Boolean mutable;
        private final software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints;
        private final software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataType = this.jsiiGet("dataType", java.lang.String.class);
            this.mutable = this.jsiiGet("mutable", java.lang.Boolean.class);
            this.numberConstraints = this.jsiiGet("numberConstraints", software.amazon.awscdk.services.cognito.NumberAttributeConstraints.class);
            this.stringConstraints = this.jsiiGet("stringConstraints", software.amazon.awscdk.services.cognito.StringAttributeConstraints.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String dataType, final java.lang.Boolean mutable, final software.amazon.awscdk.services.cognito.NumberAttributeConstraints numberConstraints, final software.amazon.awscdk.services.cognito.StringAttributeConstraints stringConstraints) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataType = java.util.Objects.requireNonNull(dataType, "dataType is required");
            this.mutable = mutable;
            this.numberConstraints = numberConstraints;
            this.stringConstraints = stringConstraints;
        }

        @Override
        public java.lang.String getDataType() {
            return this.dataType;
        }

        @Override
        public java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        public software.amazon.awscdk.services.cognito.NumberAttributeConstraints getNumberConstraints() {
            return this.numberConstraints;
        }

        @Override
        public software.amazon.awscdk.services.cognito.StringAttributeConstraints getStringConstraints() {
            return this.stringConstraints;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataType", om.valueToTree(this.getDataType()));
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }
            if (this.getNumberConstraints() != null) {
                data.set("numberConstraints", om.valueToTree(this.getNumberConstraints()));
            }
            if (this.getStringConstraints() != null) {
                data.set("stringConstraints", om.valueToTree(this.getStringConstraints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CustomAttributeConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomAttributeConfig.Jsii$Proxy that = (CustomAttributeConfig.Jsii$Proxy) o;

            if (!dataType.equals(that.dataType)) return false;
            if (this.mutable != null ? !this.mutable.equals(that.mutable) : that.mutable != null) return false;
            if (this.numberConstraints != null ? !this.numberConstraints.equals(that.numberConstraints) : that.numberConstraints != null) return false;
            return this.stringConstraints != null ? this.stringConstraints.equals(that.stringConstraints) : that.stringConstraints == null;
        }

        @Override
        public int hashCode() {
            int result = this.dataType.hashCode();
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            result = 31 * result + (this.numberConstraints != null ? this.numberConstraints.hashCode() : 0);
            result = 31 * result + (this.stringConstraints != null ? this.stringConstraints.hashCode() : 0);
            return result;
        }
    }
}
