package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.703Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolRiskConfigurationAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountTakeoverRiskConfiguration() {
        return null;
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompromisedCredentialsRiskConfiguration() {
        return null;
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRiskExceptionConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolRiskConfigurationAttachmentProps> {
        private java.lang.String clientId;
        private java.lang.String userPoolId;
        private java.lang.Object accountTakeoverRiskConfiguration;
        private java.lang.Object compromisedCredentialsRiskConfiguration;
        private java.lang.Object riskExceptionConfiguration;

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getClientId}
         * @param clientId `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getUserPoolId}
         * @param userPoolId `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getAccountTakeoverRiskConfiguration}
         * @param accountTakeoverRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(software.amazon.awscdk.core.IResolvable accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getAccountTakeoverRiskConfiguration}
         * @param accountTakeoverRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getCompromisedCredentialsRiskConfiguration}
         * @param compromisedCredentialsRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(software.amazon.awscdk.core.IResolvable compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getCompromisedCredentialsRiskConfiguration}
         * @param compromisedCredentialsRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getRiskExceptionConfiguration}
         * @param riskExceptionConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(software.amazon.awscdk.core.IResolvable riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getRiskExceptionConfiguration}
         * @param riskExceptionConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolRiskConfigurationAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolRiskConfigurationAttachmentProps build() {
            return new Jsii$Proxy(clientId, userPoolId, accountTakeoverRiskConfiguration, compromisedCredentialsRiskConfiguration, riskExceptionConfiguration);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolRiskConfigurationAttachmentProps {
        private final java.lang.String clientId;
        private final java.lang.String userPoolId;
        private final java.lang.Object accountTakeoverRiskConfiguration;
        private final java.lang.Object compromisedCredentialsRiskConfiguration;
        private final java.lang.Object riskExceptionConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = this.jsiiGet("clientId", java.lang.String.class);
            this.userPoolId = this.jsiiGet("userPoolId", java.lang.String.class);
            this.accountTakeoverRiskConfiguration = this.jsiiGet("accountTakeoverRiskConfiguration", java.lang.Object.class);
            this.compromisedCredentialsRiskConfiguration = this.jsiiGet("compromisedCredentialsRiskConfiguration", java.lang.Object.class);
            this.riskExceptionConfiguration = this.jsiiGet("riskExceptionConfiguration", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String clientId, final java.lang.String userPoolId, final java.lang.Object accountTakeoverRiskConfiguration, final java.lang.Object compromisedCredentialsRiskConfiguration, final java.lang.Object riskExceptionConfiguration) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(clientId, "clientId is required");
            this.userPoolId = java.util.Objects.requireNonNull(userPoolId, "userPoolId is required");
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            this.riskExceptionConfiguration = riskExceptionConfiguration;
        }

        @Override
        public java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public java.lang.Object getAccountTakeoverRiskConfiguration() {
            return this.accountTakeoverRiskConfiguration;
        }

        @Override
        public java.lang.Object getCompromisedCredentialsRiskConfiguration() {
            return this.compromisedCredentialsRiskConfiguration;
        }

        @Override
        public java.lang.Object getRiskExceptionConfiguration() {
            return this.riskExceptionConfiguration;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getAccountTakeoverRiskConfiguration() != null) {
                data.set("accountTakeoverRiskConfiguration", om.valueToTree(this.getAccountTakeoverRiskConfiguration()));
            }
            if (this.getCompromisedCredentialsRiskConfiguration() != null) {
                data.set("compromisedCredentialsRiskConfiguration", om.valueToTree(this.getCompromisedCredentialsRiskConfiguration()));
            }
            if (this.getRiskExceptionConfiguration() != null) {
                data.set("riskExceptionConfiguration", om.valueToTree(this.getRiskExceptionConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy that = (CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.accountTakeoverRiskConfiguration != null ? !this.accountTakeoverRiskConfiguration.equals(that.accountTakeoverRiskConfiguration) : that.accountTakeoverRiskConfiguration != null) return false;
            if (this.compromisedCredentialsRiskConfiguration != null ? !this.compromisedCredentialsRiskConfiguration.equals(that.compromisedCredentialsRiskConfiguration) : that.compromisedCredentialsRiskConfiguration != null) return false;
            return this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.equals(that.riskExceptionConfiguration) : that.riskExceptionConfiguration == null;
        }

        @Override
        public int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.accountTakeoverRiskConfiguration != null ? this.accountTakeoverRiskConfiguration.hashCode() : 0);
            result = 31 * result + (this.compromisedCredentialsRiskConfiguration != null ? this.compromisedCredentialsRiskConfiguration.hashCode() : 0);
            result = 31 * result + (this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.hashCode() : 0);
            return result;
        }
    }
}
