package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.701Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment")
public class CfnUserPoolRiskConfigurationAttachment extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnUserPoolRiskConfigurationAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolRiskConfigurationAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolRiskConfigurationAttachment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClientId() {
        return this.jsiiGet("clientId", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("clientId", java.util.Objects.requireNonNull(value, "clientId is required"));
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return this.jsiiGet("userPoolId", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccountTakeoverRiskConfiguration() {
        return this.jsiiGet("accountTakeoverRiskConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountTakeoverRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accountTakeoverRiskConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountTakeoverRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty value) {
        this.jsiiSet("accountTakeoverRiskConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCompromisedCredentialsRiskConfiguration() {
        return this.jsiiGet("compromisedCredentialsRiskConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompromisedCredentialsRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("compromisedCredentialsRiskConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompromisedCredentialsRiskConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty value) {
        this.jsiiSet("compromisedCredentialsRiskConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRiskExceptionConfiguration() {
        return this.jsiiGet("riskExceptionConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRiskExceptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("riskExceptionConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRiskExceptionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty value) {
        this.jsiiSet("riskExceptionConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverActionTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverActionTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.EventAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-eventaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventAction();

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.Notify`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractiontype-notify
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNotify();

        /**
         * @return a {@link Builder} of {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverActionTypeProperty> {
            private java.lang.String eventAction;
            private java.lang.Object notify;

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getEventAction}
             * @param eventAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.EventAction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventAction(java.lang.String eventAction) {
                this.eventAction = eventAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getNotify}
             * @param notify `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.Notify`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notify(java.lang.Boolean notify) {
                this.notify = notify;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionTypeProperty#getNotify}
             * @param notify `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty.Notify`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notify(software.amazon.awscdk.core.IResolvable notify) {
                this.notify = notify;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverActionTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverActionTypeProperty build() {
                return new Jsii$Proxy(eventAction, notify);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverActionTypeProperty {
            private final java.lang.String eventAction;
            private final java.lang.Object notify;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventAction = this.jsiiGet("eventAction", java.lang.String.class);
                this.notify = this.jsiiGet("notify", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String eventAction, final java.lang.Object notify) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventAction = java.util.Objects.requireNonNull(eventAction, "eventAction is required");
                this.notify = java.util.Objects.requireNonNull(notify, "notify is required");
            }

            @Override
            public java.lang.String getEventAction() {
                return this.eventAction;
            }

            @Override
            public java.lang.Object getNotify() {
                return this.notify;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventAction", om.valueToTree(this.getEventAction()));
                data.set("notify", om.valueToTree(this.getNotify()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverActionTypeProperty.Jsii$Proxy that = (AccountTakeoverActionTypeProperty.Jsii$Proxy) o;

                if (!eventAction.equals(that.eventAction)) return false;
                return this.notify.equals(that.notify);
            }

            @Override
            public int hashCode() {
                int result = this.eventAction.hashCode();
                result = 31 * result + (this.notify.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverActionsTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverActionsTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.HighAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-highaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHighAction() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.LowAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-lowaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLowAction() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.MediumAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoveractionstype-mediumaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediumAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverActionsTypeProperty> {
            private java.lang.Object highAction;
            private java.lang.Object lowAction;
            private java.lang.Object mediumAction;

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getHighAction}
             * @param highAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.HighAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder highAction(software.amazon.awscdk.core.IResolvable highAction) {
                this.highAction = highAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getHighAction}
             * @param highAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.HighAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder highAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty highAction) {
                this.highAction = highAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getLowAction}
             * @param lowAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.LowAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowAction(software.amazon.awscdk.core.IResolvable lowAction) {
                this.lowAction = lowAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getLowAction}
             * @param lowAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.LowAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty lowAction) {
                this.lowAction = lowAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getMediumAction}
             * @param mediumAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.MediumAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediumAction(software.amazon.awscdk.core.IResolvable mediumAction) {
                this.mediumAction = mediumAction;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverActionsTypeProperty#getMediumAction}
             * @param mediumAction `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty.MediumAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediumAction(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionTypeProperty mediumAction) {
                this.mediumAction = mediumAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverActionsTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverActionsTypeProperty build() {
                return new Jsii$Proxy(highAction, lowAction, mediumAction);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverActionsTypeProperty {
            private final java.lang.Object highAction;
            private final java.lang.Object lowAction;
            private final java.lang.Object mediumAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.highAction = this.jsiiGet("highAction", java.lang.Object.class);
                this.lowAction = this.jsiiGet("lowAction", java.lang.Object.class);
                this.mediumAction = this.jsiiGet("mediumAction", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object highAction, final java.lang.Object lowAction, final java.lang.Object mediumAction) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.highAction = highAction;
                this.lowAction = lowAction;
                this.mediumAction = mediumAction;
            }

            @Override
            public java.lang.Object getHighAction() {
                return this.highAction;
            }

            @Override
            public java.lang.Object getLowAction() {
                return this.lowAction;
            }

            @Override
            public java.lang.Object getMediumAction() {
                return this.mediumAction;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHighAction() != null) {
                    data.set("highAction", om.valueToTree(this.getHighAction()));
                }
                if (this.getLowAction() != null) {
                    data.set("lowAction", om.valueToTree(this.getLowAction()));
                }
                if (this.getMediumAction() != null) {
                    data.set("mediumAction", om.valueToTree(this.getMediumAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverActionsTypeProperty.Jsii$Proxy that = (AccountTakeoverActionsTypeProperty.Jsii$Proxy) o;

                if (this.highAction != null ? !this.highAction.equals(that.highAction) : that.highAction != null) return false;
                if (this.lowAction != null ? !this.lowAction.equals(that.lowAction) : that.lowAction != null) return false;
                return this.mediumAction != null ? this.mediumAction.equals(that.mediumAction) : that.mediumAction == null;
            }

            @Override
            public int hashCode() {
                int result = this.highAction != null ? this.highAction.hashCode() : 0;
                result = 31 * result + (this.lowAction != null ? this.lowAction.hashCode() : 0);
                result = 31 * result + (this.mediumAction != null ? this.mediumAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountTakeoverRiskConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.Actions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-actions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.NotifyConfiguration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfigurationtype-notifyconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotifyConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountTakeoverRiskConfigurationTypeProperty> {
            private java.lang.Object actions;
            private java.lang.Object notifyConfiguration;

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getActions}
             * @param actions `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.Actions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.core.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getActions}
             * @param actions `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.Actions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverActionsTypeProperty actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getNotifyConfiguration}
             * @param notifyConfiguration `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.NotifyConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notifyConfiguration(software.amazon.awscdk.core.IResolvable notifyConfiguration) {
                this.notifyConfiguration = notifyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AccountTakeoverRiskConfigurationTypeProperty#getNotifyConfiguration}
             * @param notifyConfiguration `CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty.NotifyConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notifyConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty notifyConfiguration) {
                this.notifyConfiguration = notifyConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountTakeoverRiskConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountTakeoverRiskConfigurationTypeProperty build() {
                return new Jsii$Proxy(actions, notifyConfiguration);
            }
        }

        /**
         * An implementation for {@link AccountTakeoverRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountTakeoverRiskConfigurationTypeProperty {
            private final java.lang.Object actions;
            private final java.lang.Object notifyConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = this.jsiiGet("actions", java.lang.Object.class);
                this.notifyConfiguration = this.jsiiGet("notifyConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object actions, final java.lang.Object notifyConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
                this.notifyConfiguration = notifyConfiguration;
            }

            @Override
            public java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public java.lang.Object getNotifyConfiguration() {
                return this.notifyConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                if (this.getNotifyConfiguration() != null) {
                    data.set("notifyConfiguration", om.valueToTree(this.getNotifyConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy that = (AccountTakeoverRiskConfigurationTypeProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.notifyConfiguration != null ? this.notifyConfiguration.equals(that.notifyConfiguration) : that.notifyConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.notifyConfiguration != null ? this.notifyConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CompromisedCredentialsActionsTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompromisedCredentialsActionsTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty.EventAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsactionstype-eventaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventAction();

        /**
         * @return a {@link Builder} of {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompromisedCredentialsActionsTypeProperty> {
            private java.lang.String eventAction;

            /**
             * Sets the value of {@link CompromisedCredentialsActionsTypeProperty#getEventAction}
             * @param eventAction `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty.EventAction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventAction(java.lang.String eventAction) {
                this.eventAction = eventAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompromisedCredentialsActionsTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompromisedCredentialsActionsTypeProperty build() {
                return new Jsii$Proxy(eventAction);
            }
        }

        /**
         * An implementation for {@link CompromisedCredentialsActionsTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompromisedCredentialsActionsTypeProperty {
            private final java.lang.String eventAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventAction = this.jsiiGet("eventAction", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String eventAction) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventAction = java.util.Objects.requireNonNull(eventAction, "eventAction is required");
            }

            @Override
            public java.lang.String getEventAction() {
                return this.eventAction;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventAction", om.valueToTree(this.getEventAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompromisedCredentialsActionsTypeProperty.Jsii$Proxy that = (CompromisedCredentialsActionsTypeProperty.Jsii$Proxy) o;

                return this.eventAction.equals(that.eventAction);
            }

            @Override
            public int hashCode() {
                int result = this.eventAction.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompromisedCredentialsRiskConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.Actions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-actions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.EventFilter`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfigurationtype-eventfilter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompromisedCredentialsRiskConfigurationTypeProperty> {
            private java.lang.Object actions;
            private java.util.List<java.lang.String> eventFilter;

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getActions}
             * @param actions `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.Actions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.core.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getActions}
             * @param actions `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.Actions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsTypeProperty actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link CompromisedCredentialsRiskConfigurationTypeProperty#getEventFilter}
             * @param eventFilter `CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty.EventFilter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventFilter(java.util.List<java.lang.String> eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompromisedCredentialsRiskConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompromisedCredentialsRiskConfigurationTypeProperty build() {
                return new Jsii$Proxy(actions, eventFilter);
            }
        }

        /**
         * An implementation for {@link CompromisedCredentialsRiskConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompromisedCredentialsRiskConfigurationTypeProperty {
            private final java.lang.Object actions;
            private final java.util.List<java.lang.String> eventFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = this.jsiiGet("actions", java.lang.Object.class);
                this.eventFilter = this.jsiiGet("eventFilter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object actions, final java.util.List<java.lang.String> eventFilter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
                this.eventFilter = eventFilter;
            }

            @Override
            public java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public java.util.List<java.lang.String> getEventFilter() {
                return this.eventFilter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                if (this.getEventFilter() != null) {
                    data.set("eventFilter", om.valueToTree(this.getEventFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy that = (CompromisedCredentialsRiskConfigurationTypeProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.eventFilter != null ? this.eventFilter.equals(that.eventFilter) : that.eventFilter == null;
            }

            @Override
            public int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.eventFilter != null ? this.eventFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotifyConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotifyConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.SourceArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-sourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceArn();

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.BlockEmail`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-blockemail
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockEmail() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.From`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-from
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrom() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.MfaEmail`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-mfaemail
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMfaEmail() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.NoActionEmail`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-noactionemail
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoActionEmail() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.ReplyTo`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyconfigurationtype-replyto
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplyTo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotifyConfigurationTypeProperty> {
            private java.lang.String sourceArn;
            private java.lang.Object blockEmail;
            private java.lang.String from;
            private java.lang.Object mfaEmail;
            private java.lang.Object noActionEmail;
            private java.lang.String replyTo;

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getSourceArn}
             * @param sourceArn `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.SourceArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceArn(java.lang.String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getBlockEmail}
             * @param blockEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.BlockEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockEmail(software.amazon.awscdk.core.IResolvable blockEmail) {
                this.blockEmail = blockEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getBlockEmail}
             * @param blockEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.BlockEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty blockEmail) {
                this.blockEmail = blockEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getFrom}
             * @param from `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.From`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder from(java.lang.String from) {
                this.from = from;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getMfaEmail}
             * @param mfaEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.MfaEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mfaEmail(software.amazon.awscdk.core.IResolvable mfaEmail) {
                this.mfaEmail = mfaEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getMfaEmail}
             * @param mfaEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.MfaEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mfaEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty mfaEmail) {
                this.mfaEmail = mfaEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getNoActionEmail}
             * @param noActionEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.NoActionEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noActionEmail(software.amazon.awscdk.core.IResolvable noActionEmail) {
                this.noActionEmail = noActionEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getNoActionEmail}
             * @param noActionEmail `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.NoActionEmail`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noActionEmail(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty noActionEmail) {
                this.noActionEmail = noActionEmail;
                return this;
            }

            /**
             * Sets the value of {@link NotifyConfigurationTypeProperty#getReplyTo}
             * @param replyTo `CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty.ReplyTo`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replyTo(java.lang.String replyTo) {
                this.replyTo = replyTo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotifyConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotifyConfigurationTypeProperty build() {
                return new Jsii$Proxy(sourceArn, blockEmail, from, mfaEmail, noActionEmail, replyTo);
            }
        }

        /**
         * An implementation for {@link NotifyConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotifyConfigurationTypeProperty {
            private final java.lang.String sourceArn;
            private final java.lang.Object blockEmail;
            private final java.lang.String from;
            private final java.lang.Object mfaEmail;
            private final java.lang.Object noActionEmail;
            private final java.lang.String replyTo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceArn = this.jsiiGet("sourceArn", java.lang.String.class);
                this.blockEmail = this.jsiiGet("blockEmail", java.lang.Object.class);
                this.from = this.jsiiGet("from", java.lang.String.class);
                this.mfaEmail = this.jsiiGet("mfaEmail", java.lang.Object.class);
                this.noActionEmail = this.jsiiGet("noActionEmail", java.lang.Object.class);
                this.replyTo = this.jsiiGet("replyTo", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String sourceArn, final java.lang.Object blockEmail, final java.lang.String from, final java.lang.Object mfaEmail, final java.lang.Object noActionEmail, final java.lang.String replyTo) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceArn = java.util.Objects.requireNonNull(sourceArn, "sourceArn is required");
                this.blockEmail = blockEmail;
                this.from = from;
                this.mfaEmail = mfaEmail;
                this.noActionEmail = noActionEmail;
                this.replyTo = replyTo;
            }

            @Override
            public java.lang.String getSourceArn() {
                return this.sourceArn;
            }

            @Override
            public java.lang.Object getBlockEmail() {
                return this.blockEmail;
            }

            @Override
            public java.lang.String getFrom() {
                return this.from;
            }

            @Override
            public java.lang.Object getMfaEmail() {
                return this.mfaEmail;
            }

            @Override
            public java.lang.Object getNoActionEmail() {
                return this.noActionEmail;
            }

            @Override
            public java.lang.String getReplyTo() {
                return this.replyTo;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceArn", om.valueToTree(this.getSourceArn()));
                if (this.getBlockEmail() != null) {
                    data.set("blockEmail", om.valueToTree(this.getBlockEmail()));
                }
                if (this.getFrom() != null) {
                    data.set("from", om.valueToTree(this.getFrom()));
                }
                if (this.getMfaEmail() != null) {
                    data.set("mfaEmail", om.valueToTree(this.getMfaEmail()));
                }
                if (this.getNoActionEmail() != null) {
                    data.set("noActionEmail", om.valueToTree(this.getNoActionEmail()));
                }
                if (this.getReplyTo() != null) {
                    data.set("replyTo", om.valueToTree(this.getReplyTo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.NotifyConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotifyConfigurationTypeProperty.Jsii$Proxy that = (NotifyConfigurationTypeProperty.Jsii$Proxy) o;

                if (!sourceArn.equals(that.sourceArn)) return false;
                if (this.blockEmail != null ? !this.blockEmail.equals(that.blockEmail) : that.blockEmail != null) return false;
                if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
                if (this.mfaEmail != null ? !this.mfaEmail.equals(that.mfaEmail) : that.mfaEmail != null) return false;
                if (this.noActionEmail != null ? !this.noActionEmail.equals(that.noActionEmail) : that.noActionEmail != null) return false;
                return this.replyTo != null ? this.replyTo.equals(that.replyTo) : that.replyTo == null;
            }

            @Override
            public int hashCode() {
                int result = this.sourceArn.hashCode();
                result = 31 * result + (this.blockEmail != null ? this.blockEmail.hashCode() : 0);
                result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
                result = 31 * result + (this.mfaEmail != null ? this.mfaEmail.hashCode() : 0);
                result = 31 * result + (this.noActionEmail != null ? this.noActionEmail.hashCode() : 0);
                result = 31 * result + (this.replyTo != null ? this.replyTo.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotifyEmailTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotifyEmailTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.Subject`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-subject
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubject();

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.HtmlBody`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-htmlbody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHtmlBody() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.TextBody`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-notifyemailtype.html#cfn-cognito-userpoolriskconfigurationattachment-notifyemailtype-textbody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotifyEmailTypeProperty> {
            private java.lang.String subject;
            private java.lang.String htmlBody;
            private java.lang.String textBody;

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getSubject}
             * @param subject `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.Subject`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(java.lang.String subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getHtmlBody}
             * @param htmlBody `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.HtmlBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder htmlBody(java.lang.String htmlBody) {
                this.htmlBody = htmlBody;
                return this;
            }

            /**
             * Sets the value of {@link NotifyEmailTypeProperty#getTextBody}
             * @param textBody `CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty.TextBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textBody(java.lang.String textBody) {
                this.textBody = textBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotifyEmailTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotifyEmailTypeProperty build() {
                return new Jsii$Proxy(subject, htmlBody, textBody);
            }
        }

        /**
         * An implementation for {@link NotifyEmailTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotifyEmailTypeProperty {
            private final java.lang.String subject;
            private final java.lang.String htmlBody;
            private final java.lang.String textBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subject = this.jsiiGet("subject", java.lang.String.class);
                this.htmlBody = this.jsiiGet("htmlBody", java.lang.String.class);
                this.textBody = this.jsiiGet("textBody", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String subject, final java.lang.String htmlBody, final java.lang.String textBody) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subject = java.util.Objects.requireNonNull(subject, "subject is required");
                this.htmlBody = htmlBody;
                this.textBody = textBody;
            }

            @Override
            public java.lang.String getSubject() {
                return this.subject;
            }

            @Override
            public java.lang.String getHtmlBody() {
                return this.htmlBody;
            }

            @Override
            public java.lang.String getTextBody() {
                return this.textBody;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subject", om.valueToTree(this.getSubject()));
                if (this.getHtmlBody() != null) {
                    data.set("htmlBody", om.valueToTree(this.getHtmlBody()));
                }
                if (this.getTextBody() != null) {
                    data.set("textBody", om.valueToTree(this.getTextBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.NotifyEmailTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotifyEmailTypeProperty.Jsii$Proxy that = (NotifyEmailTypeProperty.Jsii$Proxy) o;

                if (!subject.equals(that.subject)) return false;
                if (this.htmlBody != null ? !this.htmlBody.equals(that.htmlBody) : that.htmlBody != null) return false;
                return this.textBody != null ? this.textBody.equals(that.textBody) : that.textBody == null;
            }

            @Override
            public int hashCode() {
                int result = this.subject.hashCode();
                result = 31 * result + (this.htmlBody != null ? this.htmlBody.hashCode() : 0);
                result = 31 * result + (this.textBody != null ? this.textBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(RiskExceptionConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RiskExceptionConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.BlockedIPRangeList`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-blockediprangelist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBlockedIpRangeList() {
            return null;
        }

        /**
         * `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.SkippedIPRangeList`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfigurationtype-skippediprangelist
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSkippedIpRangeList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RiskExceptionConfigurationTypeProperty> {
            private java.util.List<java.lang.String> blockedIpRangeList;
            private java.util.List<java.lang.String> skippedIpRangeList;

            /**
             * Sets the value of {@link RiskExceptionConfigurationTypeProperty#getBlockedIpRangeList}
             * @param blockedIpRangeList `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.BlockedIPRangeList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockedIpRangeList(java.util.List<java.lang.String> blockedIpRangeList) {
                this.blockedIpRangeList = blockedIpRangeList;
                return this;
            }

            /**
             * Sets the value of {@link RiskExceptionConfigurationTypeProperty#getSkippedIpRangeList}
             * @param skippedIpRangeList `CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty.SkippedIPRangeList`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skippedIpRangeList(java.util.List<java.lang.String> skippedIpRangeList) {
                this.skippedIpRangeList = skippedIpRangeList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RiskExceptionConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RiskExceptionConfigurationTypeProperty build() {
                return new Jsii$Proxy(blockedIpRangeList, skippedIpRangeList);
            }
        }

        /**
         * An implementation for {@link RiskExceptionConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RiskExceptionConfigurationTypeProperty {
            private final java.util.List<java.lang.String> blockedIpRangeList;
            private final java.util.List<java.lang.String> skippedIpRangeList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockedIpRangeList = this.jsiiGet("blockedIpRangeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.skippedIpRangeList = this.jsiiGet("skippedIpRangeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> blockedIpRangeList, final java.util.List<java.lang.String> skippedIpRangeList) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockedIpRangeList = blockedIpRangeList;
                this.skippedIpRangeList = skippedIpRangeList;
            }

            @Override
            public java.util.List<java.lang.String> getBlockedIpRangeList() {
                return this.blockedIpRangeList;
            }

            @Override
            public java.util.List<java.lang.String> getSkippedIpRangeList() {
                return this.skippedIpRangeList;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockedIpRangeList() != null) {
                    data.set("blockedIpRangeList", om.valueToTree(this.getBlockedIpRangeList()));
                }
                if (this.getSkippedIpRangeList() != null) {
                    data.set("skippedIpRangeList", om.valueToTree(this.getSkippedIpRangeList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RiskExceptionConfigurationTypeProperty.Jsii$Proxy that = (RiskExceptionConfigurationTypeProperty.Jsii$Proxy) o;

                if (this.blockedIpRangeList != null ? !this.blockedIpRangeList.equals(that.blockedIpRangeList) : that.blockedIpRangeList != null) return false;
                return this.skippedIpRangeList != null ? this.skippedIpRangeList.equals(that.skippedIpRangeList) : that.skippedIpRangeList == null;
            }

            @Override
            public int hashCode() {
                int result = this.blockedIpRangeList != null ? this.blockedIpRangeList.hashCode() : 0;
                result = 31 * result + (this.skippedIpRangeList != null ? this.skippedIpRangeList.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachmentProps.Builder();
        }

        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid
         * @param clientId `AWS::Cognito::UserPoolRiskConfigurationAttachment.ClientId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid
         * @param userPoolId `AWS::Cognito::UserPoolRiskConfigurationAttachment.UserPoolId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
         * @param accountTakeoverRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(final software.amazon.awscdk.core.IResolvable accountTakeoverRiskConfiguration) {
            this.props.accountTakeoverRiskConfiguration(accountTakeoverRiskConfiguration);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration
         * @param accountTakeoverRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty accountTakeoverRiskConfiguration) {
            this.props.accountTakeoverRiskConfiguration(accountTakeoverRiskConfiguration);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
         * @param compromisedCredentialsRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(final software.amazon.awscdk.core.IResolvable compromisedCredentialsRiskConfiguration) {
            this.props.compromisedCredentialsRiskConfiguration(compromisedCredentialsRiskConfiguration);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration
         * @param compromisedCredentialsRiskConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty compromisedCredentialsRiskConfiguration) {
            this.props.compromisedCredentialsRiskConfiguration(compromisedCredentialsRiskConfiguration);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
         * @param riskExceptionConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(final software.amazon.awscdk.core.IResolvable riskExceptionConfiguration) {
            this.props.riskExceptionConfiguration(riskExceptionConfiguration);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration
         * @param riskExceptionConfiguration `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty riskExceptionConfiguration) {
            this.props.riskExceptionConfiguration(riskExceptionConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
