package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.685Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolClient")
public class CfnUserPoolClient extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolClient(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolClient.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Cognito::UserPoolClient`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolClient(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolClientProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClientSecret() {
        return this.jsiiGet("attrClientSecret", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return this.jsiiGet("attrName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Cognito::UserPoolClient.UserPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return this.jsiiGet("userPoolId", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.UserPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("allowedOAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("allowedOAuthFlows", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowedOAuthFlowsUserPoolClient() {
        return this.jsiiGet("allowedOAuthFlowsUserPoolClient", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthFlowsUserPoolClient(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("allowedOAuthFlowsUserPoolClient", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("allowedOAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedOAuthScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("allowedOAuthScopes", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfiguration() {
        return this.jsiiGet("analyticsConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("analyticsConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty value) {
        this.jsiiSet("analyticsConfiguration", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.CallbackURLs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("callbackUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.CallbackURLs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCallbackUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("callbackUrLs", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ClientName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientName() {
        return this.jsiiGet("clientName", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ClientName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("clientName", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.DefaultRedirectURI`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultRedirectUri() {
        return this.jsiiGet("defaultRedirectUri", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.DefaultRedirectURI`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRedirectUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("defaultRedirectUri", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExplicitAuthFlows() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("explicitAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExplicitAuthFlows(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("explicitAuthFlows", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.GenerateSecret`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecret() {
        return this.jsiiGet("generateSecret", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.GenerateSecret`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("generateSecret", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.GenerateSecret`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGenerateSecret(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("generateSecret", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.LogoutURLs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogoutUrLs() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("logoutUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.LogoutURLs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogoutUrLs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("logoutUrLs", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreventUserExistenceErrors() {
        return this.jsiiGet("preventUserExistenceErrors", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreventUserExistenceErrors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("preventUserExistenceErrors", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ReadAttributes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("readAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.ReadAttributes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReadAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("readAttributes", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.RefreshTokenValidity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRefreshTokenValidity() {
        return this.jsiiGet("refreshTokenValidity", java.lang.Number.class);
    }

    /**
     * `AWS::Cognito::UserPoolClient.RefreshTokenValidity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRefreshTokenValidity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("refreshTokenValidity", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedIdentityProviders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportedIdentityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("supportedIdentityProviders", value);
    }

    /**
     * `AWS::Cognito::UserPoolClient.WriteAttributes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWriteAttributes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("writeAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::UserPoolClient.WriteAttributes`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("writeAttributes", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolClient.AnalyticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnalyticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnalyticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.ApplicationId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-applicationid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
            return null;
        }

        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.ExternalId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-externalid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.RoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * `CfnUserPoolClient.AnalyticsConfigurationProperty.UserDataShared`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpoolclient-analyticsconfiguration.html#cfn-cognito-userpoolclient-analyticsconfiguration-userdatashared
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDataShared() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnalyticsConfigurationProperty> {
            private java.lang.String applicationId;
            private java.lang.String externalId;
            private java.lang.String roleArn;
            private java.lang.Object userDataShared;

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getApplicationId}
             * @param applicationId `CfnUserPoolClient.AnalyticsConfigurationProperty.ApplicationId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationId(java.lang.String applicationId) {
                this.applicationId = applicationId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getExternalId}
             * @param externalId `CfnUserPoolClient.AnalyticsConfigurationProperty.ExternalId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getRoleArn}
             * @param roleArn `CfnUserPoolClient.AnalyticsConfigurationProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared `CfnUserPoolClient.AnalyticsConfigurationProperty.UserDataShared`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(java.lang.Boolean userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Sets the value of {@link AnalyticsConfigurationProperty#getUserDataShared}
             * @param userDataShared `CfnUserPoolClient.AnalyticsConfigurationProperty.UserDataShared`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDataShared(software.amazon.awscdk.core.IResolvable userDataShared) {
                this.userDataShared = userDataShared;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnalyticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnalyticsConfigurationProperty build() {
                return new Jsii$Proxy(applicationId, externalId, roleArn, userDataShared);
            }
        }

        /**
         * An implementation for {@link AnalyticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalyticsConfigurationProperty {
            private final java.lang.String applicationId;
            private final java.lang.String externalId;
            private final java.lang.String roleArn;
            private final java.lang.Object userDataShared;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationId = this.jsiiGet("applicationId", java.lang.String.class);
                this.externalId = this.jsiiGet("externalId", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
                this.userDataShared = this.jsiiGet("userDataShared", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String applicationId, final java.lang.String externalId, final java.lang.String roleArn, final java.lang.Object userDataShared) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationId = applicationId;
                this.externalId = externalId;
                this.roleArn = roleArn;
                this.userDataShared = userDataShared;
            }

            @Override
            public java.lang.String getApplicationId() {
                return this.applicationId;
            }

            @Override
            public java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public java.lang.Object getUserDataShared() {
                return this.userDataShared;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationId() != null) {
                    data.set("applicationId", om.valueToTree(this.getApplicationId()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserDataShared() != null) {
                    data.set("userDataShared", om.valueToTree(this.getUserDataShared()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolClient.AnalyticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnalyticsConfigurationProperty.Jsii$Proxy that = (AnalyticsConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userDataShared != null ? this.userDataShared.equals(that.userDataShared) : that.userDataShared == null;
            }

            @Override
            public int hashCode() {
                int result = this.applicationId != null ? this.applicationId.hashCode() : 0;
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userDataShared != null ? this.userDataShared.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolClient> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolClientProps.Builder();
        }

        /**
         * `AWS::Cognito::UserPoolClient.UserPoolId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-userpoolid
         * @param userPoolId `AWS::Cognito::UserPoolClient.UserPoolId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflows
         * @param allowedOAuthFlows `AWS::Cognito::UserPoolClient.AllowedOAuthFlows`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlows(final java.util.List<java.lang.String> allowedOAuthFlows) {
            this.props.allowedOAuthFlows(allowedOAuthFlows);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
         * @param allowedOAuthFlowsUserPoolClient `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final java.lang.Boolean allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthflowsuserpoolclient
         * @param allowedOAuthFlowsUserPoolClient `AWS::Cognito::UserPoolClient.AllowedOAuthFlowsUserPoolClient`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(final software.amazon.awscdk.core.IResolvable allowedOAuthFlowsUserPoolClient) {
            this.props.allowedOAuthFlowsUserPoolClient(allowedOAuthFlowsUserPoolClient);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
         * @param allowedOAuthScopes `AWS::Cognito::UserPoolClient.AllowedOAuthScopes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthScopes(final java.util.List<java.lang.String> allowedOAuthScopes) {
            this.props.allowedOAuthScopes(allowedOAuthScopes);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
         * @param analyticsConfiguration `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.core.IResolvable analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-analyticsconfiguration
         * @param analyticsConfiguration `AWS::Cognito::UserPoolClient.AnalyticsConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(final software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty analyticsConfiguration) {
            this.props.analyticsConfiguration(analyticsConfiguration);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.CallbackURLs`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-callbackurls
         * @param callbackUrLs `AWS::Cognito::UserPoolClient.CallbackURLs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callbackUrLs(final java.util.List<java.lang.String> callbackUrLs) {
            this.props.callbackUrLs(callbackUrLs);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.ClientName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-clientname
         * @param clientName `AWS::Cognito::UserPoolClient.ClientName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientName(final java.lang.String clientName) {
            this.props.clientName(clientName);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.DefaultRedirectURI`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-defaultredirecturi
         * @param defaultRedirectUri `AWS::Cognito::UserPoolClient.DefaultRedirectURI`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRedirectUri(final java.lang.String defaultRedirectUri) {
            this.props.defaultRedirectUri(defaultRedirectUri);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-explicitauthflows
         * @param explicitAuthFlows `AWS::Cognito::UserPoolClient.ExplicitAuthFlows`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explicitAuthFlows(final java.util.List<java.lang.String> explicitAuthFlows) {
            this.props.explicitAuthFlows(explicitAuthFlows);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.GenerateSecret`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
         * @param generateSecret `AWS::Cognito::UserPoolClient.GenerateSecret`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final java.lang.Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }
        /**
         * `AWS::Cognito::UserPoolClient.GenerateSecret`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-generatesecret
         * @param generateSecret `AWS::Cognito::UserPoolClient.GenerateSecret`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final software.amazon.awscdk.core.IResolvable generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.LogoutURLs`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-logouturls
         * @param logoutUrLs `AWS::Cognito::UserPoolClient.LogoutURLs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logoutUrLs(final java.util.List<java.lang.String> logoutUrLs) {
            this.props.logoutUrLs(logoutUrLs);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-preventuserexistenceerrors
         * @param preventUserExistenceErrors `AWS::Cognito::UserPoolClient.PreventUserExistenceErrors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventUserExistenceErrors(final java.lang.String preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.ReadAttributes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-readattributes
         * @param readAttributes `AWS::Cognito::UserPoolClient.ReadAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readAttributes(final java.util.List<java.lang.String> readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.RefreshTokenValidity`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-refreshtokenvalidity
         * @param refreshTokenValidity `AWS::Cognito::UserPoolClient.RefreshTokenValidity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshTokenValidity(final java.lang.Number refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-supportedidentityproviders
         * @param supportedIdentityProviders `AWS::Cognito::UserPoolClient.SupportedIdentityProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedIdentityProviders(final java.util.List<java.lang.String> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        /**
         * `AWS::Cognito::UserPoolClient.WriteAttributes`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-writeattributes
         * @param writeAttributes `AWS::Cognito::UserPoolClient.WriteAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeAttributes(final java.util.List<java.lang.String> writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolClient}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolClient build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolClient(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
