package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `AWS::Cognito::IdentityPoolRoleAttachment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.680Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityPoolRoleAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId();

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoleMappings() {
        return null;
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityPoolRoleAttachmentProps> {
        private java.lang.String identityPoolId;
        private java.lang.Object roleMappings;
        private java.lang.Object roles;

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getIdentityPoolId}
         * @param identityPoolId `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolId(java.lang.String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoleMappings}
         * @param roleMappings `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(software.amazon.awscdk.core.IResolvable roleMappings) {
            this.roleMappings = roleMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoleMappings}
         * @param roleMappings `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(java.util.Map<java.lang.String, java.lang.Object> roleMappings) {
            this.roleMappings = roleMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolRoleAttachmentProps#getRoles}
         * @param roles `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(java.lang.Object roles) {
            this.roles = roles;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityPoolRoleAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityPoolRoleAttachmentProps build() {
            return new Jsii$Proxy(identityPoolId, roleMappings, roles);
        }
    }

    /**
     * An implementation for {@link CfnIdentityPoolRoleAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityPoolRoleAttachmentProps {
        private final java.lang.String identityPoolId;
        private final java.lang.Object roleMappings;
        private final java.lang.Object roles;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityPoolId = this.jsiiGet("identityPoolId", java.lang.String.class);
            this.roleMappings = this.jsiiGet("roleMappings", java.lang.Object.class);
            this.roles = this.jsiiGet("roles", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String identityPoolId, final java.lang.Object roleMappings, final java.lang.Object roles) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityPoolId = java.util.Objects.requireNonNull(identityPoolId, "identityPoolId is required");
            this.roleMappings = roleMappings;
            this.roles = roles;
        }

        @Override
        public java.lang.String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public java.lang.Object getRoleMappings() {
            return this.roleMappings;
        }

        @Override
        public java.lang.Object getRoles() {
            return this.roles;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
            if (this.getRoleMappings() != null) {
                data.set("roleMappings", om.valueToTree(this.getRoleMappings()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy that = (CfnIdentityPoolRoleAttachmentProps.Jsii$Proxy) o;

            if (!identityPoolId.equals(that.identityPoolId)) return false;
            if (this.roleMappings != null ? !this.roleMappings.equals(that.roleMappings) : that.roleMappings != null) return false;
            return this.roles != null ? this.roles.equals(that.roles) : that.roles == null;
        }

        @Override
        public int hashCode() {
            int result = this.identityPoolId.hashCode();
            result = 31 * result + (this.roleMappings != null ? this.roleMappings.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            return result;
        }
    }
}
