package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment")
public class CfnIdentityPoolRoleAttachment extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnIdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Cognito::IdentityPoolRoleAttachment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityPoolRoleAttachment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId() {
        return this.jsiiGet("identityPoolId", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("identityPoolId", java.util.Objects.requireNonNull(value, "identityPoolId is required"));
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRoles() {
        return this.jsiiGet("roles", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoles(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("roles", java.util.Objects.requireNonNull(value, "roles is required"));
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRoleMappings() {
        return this.jsiiGet("roleMappings", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("roleMappings", value);
    }

    /**
     * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleMappings(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("roleMappings", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.MappingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Claim`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-claim
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClaim();

        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.MatchType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-matchtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchType();

        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.RoleARN`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-mappingrule.html#cfn-cognito-identitypoolroleattachment-mappingrule-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingRuleProperty> {
            private java.lang.String claim;
            private java.lang.String matchType;
            private java.lang.String roleArn;
            private java.lang.String value;

            /**
             * Sets the value of {@link MappingRuleProperty#getClaim}
             * @param claim `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Claim`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder claim(java.lang.String claim) {
                this.claim = claim;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getMatchType}
             * @param matchType `CfnIdentityPoolRoleAttachment.MappingRuleProperty.MatchType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchType(java.lang.String matchType) {
                this.matchType = matchType;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getRoleArn}
             * @param roleArn `CfnIdentityPoolRoleAttachment.MappingRuleProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getValue}
             * @param value `CfnIdentityPoolRoleAttachment.MappingRuleProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingRuleProperty build() {
                return new Jsii$Proxy(claim, matchType, roleArn, value);
            }
        }

        /**
         * An implementation for {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingRuleProperty {
            private final java.lang.String claim;
            private final java.lang.String matchType;
            private final java.lang.String roleArn;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.claim = this.jsiiGet("claim", java.lang.String.class);
                this.matchType = this.jsiiGet("matchType", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String claim, final java.lang.String matchType, final java.lang.String roleArn, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.claim = java.util.Objects.requireNonNull(claim, "claim is required");
                this.matchType = java.util.Objects.requireNonNull(matchType, "matchType is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getClaim() {
                return this.claim;
            }

            @Override
            public java.lang.String getMatchType() {
                return this.matchType;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("claim", om.valueToTree(this.getClaim()));
                data.set("matchType", om.valueToTree(this.getMatchType()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.MappingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingRuleProperty.Jsii$Proxy that = (MappingRuleProperty.Jsii$Proxy) o;

                if (!claim.equals(that.claim)) return false;
                if (!matchType.equals(that.matchType)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.claim.hashCode();
                result = 31 * result + (this.matchType.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(RoleMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoleMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.AmbiguousRoleResolution`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-ambiguousroleresolution
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAmbiguousRoleResolution() {
            return null;
        }

        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.IdentityProvider`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-identityprovider
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityProvider() {
            return null;
        }

        /**
         * `CfnIdentityPoolRoleAttachment.RoleMappingProperty.RulesConfiguration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html#cfn-cognito-identitypoolroleattachment-rolemapping-rulesconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRulesConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoleMappingProperty> {
            private java.lang.String type;
            private java.lang.String ambiguousRoleResolution;
            private java.lang.String identityProvider;
            private java.lang.Object rulesConfiguration;

            /**
             * Sets the value of {@link RoleMappingProperty#getType}
             * @param type `CfnIdentityPoolRoleAttachment.RoleMappingProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getAmbiguousRoleResolution}
             * @param ambiguousRoleResolution `CfnIdentityPoolRoleAttachment.RoleMappingProperty.AmbiguousRoleResolution`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ambiguousRoleResolution(java.lang.String ambiguousRoleResolution) {
                this.ambiguousRoleResolution = ambiguousRoleResolution;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getIdentityProvider}
             * @param identityProvider `CfnIdentityPoolRoleAttachment.RoleMappingProperty.IdentityProvider`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityProvider(java.lang.String identityProvider) {
                this.identityProvider = identityProvider;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getRulesConfiguration}
             * @param rulesConfiguration `CfnIdentityPoolRoleAttachment.RoleMappingProperty.RulesConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesConfiguration(software.amazon.awscdk.core.IResolvable rulesConfiguration) {
                this.rulesConfiguration = rulesConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getRulesConfiguration}
             * @param rulesConfiguration `CfnIdentityPoolRoleAttachment.RoleMappingProperty.RulesConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesConfiguration(software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty rulesConfiguration) {
                this.rulesConfiguration = rulesConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoleMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoleMappingProperty build() {
                return new Jsii$Proxy(type, ambiguousRoleResolution, identityProvider, rulesConfiguration);
            }
        }

        /**
         * An implementation for {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleMappingProperty {
            private final java.lang.String type;
            private final java.lang.String ambiguousRoleResolution;
            private final java.lang.String identityProvider;
            private final java.lang.Object rulesConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.ambiguousRoleResolution = this.jsiiGet("ambiguousRoleResolution", java.lang.String.class);
                this.identityProvider = this.jsiiGet("identityProvider", java.lang.String.class);
                this.rulesConfiguration = this.jsiiGet("rulesConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.String ambiguousRoleResolution, final java.lang.String identityProvider, final java.lang.Object rulesConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.ambiguousRoleResolution = ambiguousRoleResolution;
                this.identityProvider = identityProvider;
                this.rulesConfiguration = rulesConfiguration;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getAmbiguousRoleResolution() {
                return this.ambiguousRoleResolution;
            }

            @Override
            public java.lang.String getIdentityProvider() {
                return this.identityProvider;
            }

            @Override
            public java.lang.Object getRulesConfiguration() {
                return this.rulesConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAmbiguousRoleResolution() != null) {
                    data.set("ambiguousRoleResolution", om.valueToTree(this.getAmbiguousRoleResolution()));
                }
                if (this.getIdentityProvider() != null) {
                    data.set("identityProvider", om.valueToTree(this.getIdentityProvider()));
                }
                if (this.getRulesConfiguration() != null) {
                    data.set("rulesConfiguration", om.valueToTree(this.getRulesConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoleMappingProperty.Jsii$Proxy that = (RoleMappingProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.ambiguousRoleResolution != null ? !this.ambiguousRoleResolution.equals(that.ambiguousRoleResolution) : that.ambiguousRoleResolution != null) return false;
                if (this.identityProvider != null ? !this.identityProvider.equals(that.identityProvider) : that.identityProvider != null) return false;
                return this.rulesConfiguration != null ? this.rulesConfiguration.equals(that.rulesConfiguration) : that.rulesConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.ambiguousRoleResolution != null ? this.ambiguousRoleResolution.hashCode() : 0);
                result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
                result = 31 * result + (this.rulesConfiguration != null ? this.rulesConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rulesconfigurationtype.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(RulesConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RulesConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty.Rules`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rulesconfigurationtype.html#cfn-cognito-identitypoolroleattachment-rulesconfigurationtype-rules
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RulesConfigurationTypeProperty> {
            private java.lang.Object rules;

            /**
             * Sets the value of {@link RulesConfigurationTypeProperty#getRules}
             * @param rules `CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link RulesConfigurationTypeProperty#getRules}
             * @param rules `CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty.Rules`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RulesConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RulesConfigurationTypeProperty build() {
                return new Jsii$Proxy(rules);
            }
        }

        /**
         * An implementation for {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RulesConfigurationTypeProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = this.jsiiGet("rules", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RulesConfigurationTypeProperty.Jsii$Proxy that = (RulesConfigurationTypeProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps.Builder();
        }

        /**
         * `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-identitypoolid
         * @param identityPoolId `AWS::Cognito::IdentityPoolRoleAttachment.IdentityPoolId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolId(final java.lang.String identityPoolId) {
            this.props.identityPoolId(identityPoolId);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
         * @param roleMappings `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(final software.amazon.awscdk.core.IResolvable roleMappings) {
            this.props.roleMappings(roleMappings);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-rolemappings
         * @param roleMappings `AWS::Cognito::IdentityPoolRoleAttachment.RoleMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(final java.util.Map<java.lang.String, java.lang.Object> roleMappings) {
            this.props.roleMappings(roleMappings);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPoolRoleAttachment.Roles`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html#cfn-cognito-identitypoolroleattachment-roles
         * @param roles `AWS::Cognito::IdentityPoolRoleAttachment.Roles`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.lang.Object roles) {
            this.props.roles(roles);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment build() {
            return new software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
