package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::IdentityPool`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.678Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPool")
public class CfnIdentityPool extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnIdentityPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnIdentityPool.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Cognito::IdentityPool`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnIdentityPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return this.jsiiGet("attrName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAllowUnauthenticatedIdentities() {
        return this.jsiiGet("allowUnauthenticatedIdentities", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowUnauthenticatedIdentities(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        this.jsiiSet("allowUnauthenticatedIdentities", java.util.Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowUnauthenticatedIdentities(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("allowUnauthenticatedIdentities", java.util.Objects.requireNonNull(value, "allowUnauthenticatedIdentities is required"));
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoEvents`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCognitoEvents() {
        return this.jsiiGet("cognitoEvents", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoEvents`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoEvents(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("cognitoEvents", java.util.Objects.requireNonNull(value, "cognitoEvents is required"));
    }

    /**
     * `AWS::Cognito::IdentityPool.SupportedLoginProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSupportedLoginProviders() {
        return this.jsiiGet("supportedLoginProviders", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.SupportedLoginProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSupportedLoginProviders(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        this.jsiiSet("supportedLoginProviders", java.util.Objects.requireNonNull(value, "supportedLoginProviders is required"));
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowClassicFlow() {
        return this.jsiiGet("allowClassicFlow", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowClassicFlow(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("allowClassicFlow", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowClassicFlow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("allowClassicFlow", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoIdentityProviders() {
        return this.jsiiGet("cognitoIdentityProviders", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoIdentityProviders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cognitoIdentityProviders", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoIdentityProviders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("cognitoIdentityProviders", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoStreams`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoStreams() {
        return this.jsiiGet("cognitoStreams", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoStreams`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoStreams(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cognitoStreams", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.CognitoStreams`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoStreams(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty value) {
        this.jsiiSet("cognitoStreams", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.DeveloperProviderName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeveloperProviderName() {
        return this.jsiiGet("developerProviderName", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.DeveloperProviderName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeveloperProviderName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("developerProviderName", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.IdentityPoolName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolName() {
        return this.jsiiGet("identityPoolName", java.lang.String.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.IdentityPoolName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityPoolName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("identityPoolName", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOpenIdConnectProviderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("openIdConnectProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenIdConnectProviderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("openIdConnectProviderArns", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.PushSync`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPushSync() {
        return this.jsiiGet("pushSync", java.lang.Object.class);
    }

    /**
     * `AWS::Cognito::IdentityPool.PushSync`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPushSync(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("pushSync", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.PushSync`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPushSync(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty value) {
        this.jsiiSet("pushSync", value);
    }

    /**
     * `AWS::Cognito::IdentityPool.SamlProviderARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSamlProviderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("samlProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::Cognito::IdentityPool.SamlProviderARNs`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamlProviderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("samlProviderArns", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPool.CognitoIdentityProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoIdentityProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoIdentityProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ClientId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-clientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ProviderName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-providername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProviderName() {
            return null;
        }

        /**
         * `CfnIdentityPool.CognitoIdentityProviderProperty.ServerSideTokenCheck`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitoidentityprovider.html#cfn-cognito-identitypool-cognitoidentityprovider-serversidetokencheck
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideTokenCheck() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoIdentityProviderProperty> {
            private java.lang.String clientId;
            private java.lang.String providerName;
            private java.lang.Object serverSideTokenCheck;

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getClientId}
             * @param clientId `CfnIdentityPool.CognitoIdentityProviderProperty.ClientId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getProviderName}
             * @param providerName `CfnIdentityPool.CognitoIdentityProviderProperty.ProviderName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerName(java.lang.String providerName) {
                this.providerName = providerName;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getServerSideTokenCheck}
             * @param serverSideTokenCheck `CfnIdentityPool.CognitoIdentityProviderProperty.ServerSideTokenCheck`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideTokenCheck(java.lang.Boolean serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            /**
             * Sets the value of {@link CognitoIdentityProviderProperty#getServerSideTokenCheck}
             * @param serverSideTokenCheck `CfnIdentityPool.CognitoIdentityProviderProperty.ServerSideTokenCheck`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideTokenCheck(software.amazon.awscdk.core.IResolvable serverSideTokenCheck) {
                this.serverSideTokenCheck = serverSideTokenCheck;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoIdentityProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoIdentityProviderProperty build() {
                return new Jsii$Proxy(clientId, providerName, serverSideTokenCheck);
            }
        }

        /**
         * An implementation for {@link CognitoIdentityProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoIdentityProviderProperty {
            private final java.lang.String clientId;
            private final java.lang.String providerName;
            private final java.lang.Object serverSideTokenCheck;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = this.jsiiGet("clientId", java.lang.String.class);
                this.providerName = this.jsiiGet("providerName", java.lang.String.class);
                this.serverSideTokenCheck = this.jsiiGet("serverSideTokenCheck", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String clientId, final java.lang.String providerName, final java.lang.Object serverSideTokenCheck) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = clientId;
                this.providerName = providerName;
                this.serverSideTokenCheck = serverSideTokenCheck;
            }

            @Override
            public java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public java.lang.String getProviderName() {
                return this.providerName;
            }

            @Override
            public java.lang.Object getServerSideTokenCheck() {
                return this.serverSideTokenCheck;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getProviderName() != null) {
                    data.set("providerName", om.valueToTree(this.getProviderName()));
                }
                if (this.getServerSideTokenCheck() != null) {
                    data.set("serverSideTokenCheck", om.valueToTree(this.getServerSideTokenCheck()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPool.CognitoIdentityProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoIdentityProviderProperty.Jsii$Proxy that = (CognitoIdentityProviderProperty.Jsii$Proxy) o;

                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.providerName != null ? !this.providerName.equals(that.providerName) : that.providerName != null) return false;
                return this.serverSideTokenCheck != null ? this.serverSideTokenCheck.equals(that.serverSideTokenCheck) : that.serverSideTokenCheck == null;
            }

            @Override
            public int hashCode() {
                int result = this.clientId != null ? this.clientId.hashCode() : 0;
                result = 31 * result + (this.providerName != null ? this.providerName.hashCode() : 0);
                result = 31 * result + (this.serverSideTokenCheck != null ? this.serverSideTokenCheck.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPool.CognitoStreamsProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoStreamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoStreamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPool.CognitoStreamsProperty.RoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * `CfnIdentityPool.CognitoStreamsProperty.StreamingStatus`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamingstatus
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamingStatus() {
            return null;
        }

        /**
         * `CfnIdentityPool.CognitoStreamsProperty.StreamName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-cognitostreams.html#cfn-cognito-identitypool-cognitostreams-streamname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoStreamsProperty> {
            private java.lang.String roleArn;
            private java.lang.String streamingStatus;
            private java.lang.String streamName;

            /**
             * Sets the value of {@link CognitoStreamsProperty#getRoleArn}
             * @param roleArn `CfnIdentityPool.CognitoStreamsProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoStreamsProperty#getStreamingStatus}
             * @param streamingStatus `CfnIdentityPool.CognitoStreamsProperty.StreamingStatus`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamingStatus(java.lang.String streamingStatus) {
                this.streamingStatus = streamingStatus;
                return this;
            }

            /**
             * Sets the value of {@link CognitoStreamsProperty#getStreamName}
             * @param streamName `CfnIdentityPool.CognitoStreamsProperty.StreamName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoStreamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoStreamsProperty build() {
                return new Jsii$Proxy(roleArn, streamingStatus, streamName);
            }
        }

        /**
         * An implementation for {@link CognitoStreamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoStreamsProperty {
            private final java.lang.String roleArn;
            private final java.lang.String streamingStatus;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
                this.streamingStatus = this.jsiiGet("streamingStatus", java.lang.String.class);
                this.streamName = this.jsiiGet("streamName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String roleArn, final java.lang.String streamingStatus, final java.lang.String streamName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = roleArn;
                this.streamingStatus = streamingStatus;
                this.streamName = streamName;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public java.lang.String getStreamingStatus() {
                return this.streamingStatus;
            }

            @Override
            public java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getStreamingStatus() != null) {
                    data.set("streamingStatus", om.valueToTree(this.getStreamingStatus()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPool.CognitoStreamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoStreamsProperty.Jsii$Proxy that = (CognitoStreamsProperty.Jsii$Proxy) o;

                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.streamingStatus != null ? !this.streamingStatus.equals(that.streamingStatus) : that.streamingStatus != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public int hashCode() {
                int result = this.roleArn != null ? this.roleArn.hashCode() : 0;
                result = 31 * result + (this.streamingStatus != null ? this.streamingStatus.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnIdentityPool.PushSyncProperty")
    @software.amazon.jsii.Jsii.Proxy(PushSyncProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PushSyncProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIdentityPool.PushSyncProperty.ApplicationArns`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-applicationarns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getApplicationArns() {
            return null;
        }

        /**
         * `CfnIdentityPool.PushSyncProperty.RoleArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypool-pushsync.html#cfn-cognito-identitypool-pushsync-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PushSyncProperty> {
            private java.util.List<java.lang.String> applicationArns;
            private java.lang.String roleArn;

            /**
             * Sets the value of {@link PushSyncProperty#getApplicationArns}
             * @param applicationArns `CfnIdentityPool.PushSyncProperty.ApplicationArns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArns(java.util.List<java.lang.String> applicationArns) {
                this.applicationArns = applicationArns;
                return this;
            }

            /**
             * Sets the value of {@link PushSyncProperty#getRoleArn}
             * @param roleArn `CfnIdentityPool.PushSyncProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PushSyncProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PushSyncProperty build() {
                return new Jsii$Proxy(applicationArns, roleArn);
            }
        }

        /**
         * An implementation for {@link PushSyncProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PushSyncProperty {
            private final java.util.List<java.lang.String> applicationArns;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationArns = this.jsiiGet("applicationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> applicationArns, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationArns = applicationArns;
                this.roleArn = roleArn;
            }

            @Override
            public java.util.List<java.lang.String> getApplicationArns() {
                return this.applicationArns;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationArns() != null) {
                    data.set("applicationArns", om.valueToTree(this.getApplicationArns()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnIdentityPool.PushSyncProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PushSyncProperty.Jsii$Proxy that = (PushSyncProperty.Jsii$Proxy) o;

                if (this.applicationArns != null ? !this.applicationArns.equals(that.applicationArns) : that.applicationArns != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.applicationArns != null ? this.applicationArns.hashCode() : 0;
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnIdentityPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnIdentityPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnIdentityPoolProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnIdentityPoolProps.Builder();
        }

        /**
         * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
         * @param allowUnauthenticatedIdentities `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(final java.lang.Boolean allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities
         * @param allowUnauthenticatedIdentities `AWS::Cognito::IdentityPool.AllowUnauthenticatedIdentities`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(final software.amazon.awscdk.core.IResolvable allowUnauthenticatedIdentities) {
            this.props.allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
         * @param allowClassicFlow `AWS::Cognito::IdentityPool.AllowClassicFlow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(final java.lang.Boolean allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPool.AllowClassicFlow`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow
         * @param allowClassicFlow `AWS::Cognito::IdentityPool.AllowClassicFlow`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(final software.amazon.awscdk.core.IResolvable allowClassicFlow) {
            this.props.allowClassicFlow(allowClassicFlow);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.CognitoEvents`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents
         * @param cognitoEvents `AWS::Cognito::IdentityPool.CognitoEvents`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoEvents(final java.lang.Object cognitoEvents) {
            this.props.cognitoEvents(cognitoEvents);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
         * @param cognitoIdentityProviders `AWS::Cognito::IdentityPool.CognitoIdentityProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(final software.amazon.awscdk.core.IResolvable cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPool.CognitoIdentityProviders`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders
         * @param cognitoIdentityProviders `AWS::Cognito::IdentityPool.CognitoIdentityProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(final java.util.List<java.lang.Object> cognitoIdentityProviders) {
            this.props.cognitoIdentityProviders(cognitoIdentityProviders);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.CognitoStreams`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
         * @param cognitoStreams `AWS::Cognito::IdentityPool.CognitoStreams`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(final software.amazon.awscdk.core.IResolvable cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPool.CognitoStreams`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams
         * @param cognitoStreams `AWS::Cognito::IdentityPool.CognitoStreams`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(final software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty cognitoStreams) {
            this.props.cognitoStreams(cognitoStreams);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.DeveloperProviderName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername
         * @param developerProviderName `AWS::Cognito::IdentityPool.DeveloperProviderName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder developerProviderName(final java.lang.String developerProviderName) {
            this.props.developerProviderName(developerProviderName);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.IdentityPoolName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname
         * @param identityPoolName `AWS::Cognito::IdentityPool.IdentityPoolName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolName(final java.lang.String identityPoolName) {
            this.props.identityPoolName(identityPoolName);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns
         * @param openIdConnectProviderArns `AWS::Cognito::IdentityPool.OpenIdConnectProviderARNs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectProviderArns(final java.util.List<java.lang.String> openIdConnectProviderArns) {
            this.props.openIdConnectProviderArns(openIdConnectProviderArns);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.PushSync`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
         * @param pushSync `AWS::Cognito::IdentityPool.PushSync`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(final software.amazon.awscdk.core.IResolvable pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }
        /**
         * `AWS::Cognito::IdentityPool.PushSync`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync
         * @param pushSync `AWS::Cognito::IdentityPool.PushSync`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(final software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty pushSync) {
            this.props.pushSync(pushSync);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.SamlProviderARNs`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns
         * @param samlProviderArns `AWS::Cognito::IdentityPool.SamlProviderARNs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlProviderArns(final java.util.List<java.lang.String> samlProviderArns) {
            this.props.samlProviderArns(samlProviderArns);
            return this;
        }

        /**
         * `AWS::Cognito::IdentityPool.SupportedLoginProviders`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders
         * @param supportedLoginProviders `AWS::Cognito::IdentityPool.SupportedLoginProviders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedLoginProviders(final java.lang.Object supportedLoginProviders) {
            this.props.supportedLoginProviders(supportedLoginProviders);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnIdentityPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnIdentityPool build() {
            return new software.amazon.awscdk.services.cognito.CfnIdentityPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
