package software.amazon.awscdk.services.cognito;

/**
 * Attributes that can be automatically verified for users in a user pool.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.677Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.AutoVerifiedAttrs")
@software.amazon.jsii.Jsii.Proxy(AutoVerifiedAttrs.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AutoVerifiedAttrs extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the email address of the user should be auto verified at sign up.
     * <p>
     * Note: If both <code>email</code> and <code>phone</code> is set, Cognito only verifies the phone number. To also verify email, see here -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
     * <p>
     * Default: - true, if email is turned on for `signIn`. false, otherwise.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmail() {
        return null;
    }

    /**
     * Whether the phone number of the user should be auto verified at sign up.
     * <p>
     * Default: - true, if phone is turned on for `signIn`. false, otherwise.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPhone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AutoVerifiedAttrs> {
        private java.lang.Boolean email;
        private java.lang.Boolean phone;

        /**
         * Sets the value of {@link AutoVerifiedAttrs#getEmail}
         * @param email Whether the email address of the user should be auto verified at sign up.
         *              Note: If both <code>email</code> and <code>phone</code> is set, Cognito only verifies the phone number. To also verify email, see here -
         *              https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder email(java.lang.Boolean email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link AutoVerifiedAttrs#getPhone}
         * @param phone Whether the phone number of the user should be auto verified at sign up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder phone(java.lang.Boolean phone) {
            this.phone = phone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoVerifiedAttrs}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AutoVerifiedAttrs build() {
            return new Jsii$Proxy(email, phone);
        }
    }

    /**
     * An implementation for {@link AutoVerifiedAttrs}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoVerifiedAttrs {
        private final java.lang.Boolean email;
        private final java.lang.Boolean phone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.email = this.jsiiGet("email", java.lang.Boolean.class);
            this.phone = this.jsiiGet("phone", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean email, final java.lang.Boolean phone) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.email = email;
            this.phone = phone;
        }

        @Override
        public java.lang.Boolean getEmail() {
            return this.email;
        }

        @Override
        public java.lang.Boolean getPhone() {
            return this.phone;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getPhone() != null) {
                data.set("phone", om.valueToTree(this.getPhone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.AutoVerifiedAttrs"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoVerifiedAttrs.Jsii$Proxy that = (AutoVerifiedAttrs.Jsii$Proxy) o;

            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            return this.phone != null ? this.phone.equals(that.phone) : that.phone == null;
        }

        @Override
        public int hashCode() {
            int result = this.email != null ? this.email.hashCode() : 0;
            result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
            return result;
        }
    }
}
