package software.amazon.awscdk.services.cognito;

/**
 * Types of authentication flow.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.677Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.AuthFlow")
@software.amazon.jsii.Jsii.Proxy(AuthFlow.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AuthFlow extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enable admin based user password authentication flow.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAdminUserPassword() {
        return null;
    }

    /**
     * Enable custom authentication flow.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCustom() {
        return null;
    }

    /**
     * Enable authflow to refresh tokens.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRefreshToken() {
        return null;
    }

    /**
     * Enable auth using username & password.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserPassword() {
        return null;
    }

    /**
     * Enable SRP based authentication.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserSrp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AuthFlow> {
        private java.lang.Boolean adminUserPassword;
        private java.lang.Boolean custom;
        private java.lang.Boolean refreshToken;
        private java.lang.Boolean userPassword;
        private java.lang.Boolean userSrp;

        /**
         * Sets the value of {@link AuthFlow#getAdminUserPassword}
         * @param adminUserPassword Enable admin based user password authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminUserPassword(java.lang.Boolean adminUserPassword) {
            this.adminUserPassword = adminUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getCustom}
         * @param custom Enable custom authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder custom(java.lang.Boolean custom) {
            this.custom = custom;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getRefreshToken}
         * @param refreshToken Enable authflow to refresh tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder refreshToken(java.lang.Boolean refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getUserPassword}
         * @param userPassword Enable auth using username & password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPassword(java.lang.Boolean userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        /**
         * Sets the value of {@link AuthFlow#getUserSrp}
         * @param userSrp Enable SRP based authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userSrp(java.lang.Boolean userSrp) {
            this.userSrp = userSrp;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AuthFlow}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AuthFlow build() {
            return new Jsii$Proxy(adminUserPassword, custom, refreshToken, userPassword, userSrp);
        }
    }

    /**
     * An implementation for {@link AuthFlow}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthFlow {
        private final java.lang.Boolean adminUserPassword;
        private final java.lang.Boolean custom;
        private final java.lang.Boolean refreshToken;
        private final java.lang.Boolean userPassword;
        private final java.lang.Boolean userSrp;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminUserPassword = this.jsiiGet("adminUserPassword", java.lang.Boolean.class);
            this.custom = this.jsiiGet("custom", java.lang.Boolean.class);
            this.refreshToken = this.jsiiGet("refreshToken", java.lang.Boolean.class);
            this.userPassword = this.jsiiGet("userPassword", java.lang.Boolean.class);
            this.userSrp = this.jsiiGet("userSrp", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean adminUserPassword, final java.lang.Boolean custom, final java.lang.Boolean refreshToken, final java.lang.Boolean userPassword, final java.lang.Boolean userSrp) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminUserPassword = adminUserPassword;
            this.custom = custom;
            this.refreshToken = refreshToken;
            this.userPassword = userPassword;
            this.userSrp = userSrp;
        }

        @Override
        public java.lang.Boolean getAdminUserPassword() {
            return this.adminUserPassword;
        }

        @Override
        public java.lang.Boolean getCustom() {
            return this.custom;
        }

        @Override
        public java.lang.Boolean getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public java.lang.Boolean getUserPassword() {
            return this.userPassword;
        }

        @Override
        public java.lang.Boolean getUserSrp() {
            return this.userSrp;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdminUserPassword() != null) {
                data.set("adminUserPassword", om.valueToTree(this.getAdminUserPassword()));
            }
            if (this.getCustom() != null) {
                data.set("custom", om.valueToTree(this.getCustom()));
            }
            if (this.getRefreshToken() != null) {
                data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
            }
            if (this.getUserPassword() != null) {
                data.set("userPassword", om.valueToTree(this.getUserPassword()));
            }
            if (this.getUserSrp() != null) {
                data.set("userSrp", om.valueToTree(this.getUserSrp()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.AuthFlow"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AuthFlow.Jsii$Proxy that = (AuthFlow.Jsii$Proxy) o;

            if (this.adminUserPassword != null ? !this.adminUserPassword.equals(that.adminUserPassword) : that.adminUserPassword != null) return false;
            if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
            if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) return false;
            if (this.userPassword != null ? !this.userPassword.equals(that.userPassword) : that.userPassword != null) return false;
            return this.userSrp != null ? this.userSrp.equals(that.userSrp) : that.userSrp == null;
        }

        @Override
        public int hashCode() {
            int result = this.adminUserPassword != null ? this.adminUserPassword.hashCode() : 0;
            result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
            result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
            result = 31 * result + (this.userPassword != null ? this.userPassword.hashCode() : 0);
            result = 31 * result + (this.userSrp != null ? this.userSrp.hashCode() : 0);
            return result;
        }
    }
}
