package software.amazon.awscdk.services.cognito;

/**
 * The email verification style.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .selfSignUpEnabled(true)
 *         .userVerification(UserVerificationConfig.builder()
 *                 .emailSubject("Verify your email for our awesome app!")
 *                 .emailBody("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .emailStyle(VerificationEmailStyle.CODE)
 *                 .smsMessage("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:42.193Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.VerificationEmailStyle")
public enum VerificationEmailStyle {
    /**
     * Verify email via code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE,
    /**
     * Verify email via link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINK,
}
