package software.amazon.awscdk.services.cognito;

/**
 * An attribute available from a third party identity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .userPool(userpool)
 *         .attributeMapping(AttributeMapping.builder()
 *                 .email(ProviderAttribute.AMAZON_EMAIL)
 *                 .website(ProviderAttribute.other("url")) // use other() when an attribute is not pre-defined in the CDK
 *                 .custom(Map.of(
 *                         // custom user pool attributes go here
 *                         "uniqueId", ProviderAttribute.AMAZON_USER_ID))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:42.127Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.ProviderAttribute")
public class ProviderAttribute extends software.amazon.jsii.JsiiObject {

    protected ProviderAttribute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProviderAttribute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_POSTAL_CODE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_POSTAL_CODE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        AMAZON_USER_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "AMAZON_USER_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_FIRST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_FIRST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_LAST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_LAST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        APPLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "APPLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_BIRTHDAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_BIRTHDAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_FIRST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_FIRST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_GENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_GENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_ID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_LAST_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_LAST_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_LOCALE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_LOCALE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_MIDDLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_MIDDLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        FACEBOOK_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "FACEBOOK_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_BIRTHDAYS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_BIRTHDAYS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_FAMILY_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_FAMILY_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_GENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_GENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_GIVEN_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_GIVEN_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_NAMES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_NAMES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_PHONE_NUMBERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_PHONE_NUMBERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
        GOOGLE_PICTURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "GOOGLE_PICTURE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class));
    }

    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * <p>
     * @param attributeName the attribute value string as recognized by the provider. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ProviderAttribute other(final @org.jetbrains.annotations.NotNull java.lang.String attributeName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.ProviderAttribute.class, "other", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ProviderAttribute.class), new Object[] { java.util.Objects.requireNonNull(attributeName, "attributeName is required") });
    }

    /**
     * The email attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_EMAIL;

    /**
     * The name attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_NAME;

    /**
     * The postal code attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_POSTAL_CODE;

    /**
     * The user id attribute provided by Amazon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute AMAZON_USER_ID;

    /**
     * The email attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_EMAIL;

    /**
     * The first name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_FIRST_NAME;

    /**
     * The last name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_LAST_NAME;

    /**
     * The name attribute provided by Apple.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute APPLE_NAME;

    /**
     * The birthday attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_BIRTHDAY;

    /**
     * The email attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_EMAIL;

    /**
     * The first name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_FIRST_NAME;

    /**
     * The gender attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_GENDER;

    /**
     * The user id attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_ID;

    /**
     * The last name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_LAST_NAME;

    /**
     * The locale attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_LOCALE;

    /**
     * The middle name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_MIDDLE_NAME;

    /**
     * The name attribute provided by Facebook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute FACEBOOK_NAME;

    /**
     * The birthday attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_BIRTHDAYS;

    /**
     * The email attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_EMAIL;

    /**
     * The family name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_FAMILY_NAME;

    /**
     * The gender attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_GENDER;

    /**
     * The given name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_GIVEN_NAME;

    /**
     * The name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_NAME;

    /**
     * The name attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_NAMES;

    /**
     * The phone number attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_PHONE_NUMBERS;

    /**
     * The picture attribute provided by Google.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.ProviderAttribute GOOGLE_PICTURE;

    /**
     * The attribute value string as recognized by the provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttributeName() {
        return software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
