package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPoolIdentityProvider`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object attributeMapping;
 * Object providerDetails;
 * CfnUserPoolIdentityProviderProps cfnUserPoolIdentityProviderProps = CfnUserPoolIdentityProviderProps.builder()
 *         .providerName("providerName")
 *         .providerType("providerType")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .attributeMapping(attributeMapping)
 *         .idpIdentifiers(List.of("idpIdentifiers"))
 *         .providerDetails(providerDetails)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:42.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolIdentityProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolIdentityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolIdentityProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IdP name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

    /**
     * The IdP type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderType();

    /**
     * The user pool ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * A mapping of IdP attributes to standard and custom user pool attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributeMapping() {
        return null;
    }

    /**
     * A list of IdP identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdpIdentifiers() {
        return null;
    }

    /**
     * The IdP details. The following list describes the provider detail keys for each IdP type.
     * <p>
     * <ul>
     * <li>For Google and Login with Amazon:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>For Facebook:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>api_version</li>
     * <li>For Sign in with Apple:</li>
     * <li>client_id</li>
     * <li>team_id</li>
     * <li>key_id</li>
     * <li>private_key</li>
     * <li>authorize_scopes</li>
     * <li>For OpenID Connect (OIDC) providers:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>attributes_request_method</li>
     * <li>oidc_issuer</li>
     * <li>authorize_scopes</li>
     * <li>The following keys are only present if Amazon Cognito didn't discover them at the <code>oidc_issuer</code> URL.</li>
     * <li>authorize_url</li>
     * <li>token_url</li>
     * <li>attributes_url</li>
     * <li>jwks_uri</li>
     * <li>Amazon Cognito sets the value of the following keys automatically. They are read-only.</li>
     * <li>attributes_url_add_attributes</li>
     * <li>For SAML providers:</li>
     * <li>MetadataFile or MetadataURL</li>
     * <li>IDPSignout <em>optional</em></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProviderDetails() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolIdentityProviderProps> {
        java.lang.String providerName;
        java.lang.String providerType;
        java.lang.String userPoolId;
        java.lang.Object attributeMapping;
        java.util.List<java.lang.String> idpIdentifiers;
        java.lang.Object providerDetails;

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getProviderName}
         * @param providerName The IdP name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(java.lang.String providerName) {
            this.providerName = providerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getProviderType}
         * @param providerType The IdP type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerType(java.lang.String providerType) {
            this.providerType = providerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getUserPoolId}
         * @param userPoolId The user pool ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getAttributeMapping}
         * @param attributeMapping A mapping of IdP attributes to standard and custom user pool attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(java.lang.Object attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getIdpIdentifiers}
         * @param idpIdentifiers A list of IdP identifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpIdentifiers(java.util.List<java.lang.String> idpIdentifiers) {
            this.idpIdentifiers = idpIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolIdentityProviderProps#getProviderDetails}
         * @param providerDetails The IdP details. The following list describes the provider detail keys for each IdP type.
         *                        <ul>
         *                        <li>For Google and Login with Amazon:</li>
         *                        <li>client_id</li>
         *                        <li>client_secret</li>
         *                        <li>authorize_scopes</li>
         *                        <li>For Facebook:</li>
         *                        <li>client_id</li>
         *                        <li>client_secret</li>
         *                        <li>authorize_scopes</li>
         *                        <li>api_version</li>
         *                        <li>For Sign in with Apple:</li>
         *                        <li>client_id</li>
         *                        <li>team_id</li>
         *                        <li>key_id</li>
         *                        <li>private_key</li>
         *                        <li>authorize_scopes</li>
         *                        <li>For OpenID Connect (OIDC) providers:</li>
         *                        <li>client_id</li>
         *                        <li>client_secret</li>
         *                        <li>attributes_request_method</li>
         *                        <li>oidc_issuer</li>
         *                        <li>authorize_scopes</li>
         *                        <li>The following keys are only present if Amazon Cognito didn't discover them at the <code>oidc_issuer</code> URL.</li>
         *                        <li>authorize_url</li>
         *                        <li>token_url</li>
         *                        <li>attributes_url</li>
         *                        <li>jwks_uri</li>
         *                        <li>Amazon Cognito sets the value of the following keys automatically. They are read-only.</li>
         *                        <li>attributes_url_add_attributes</li>
         *                        <li>For SAML providers:</li>
         *                        <li>MetadataFile or MetadataURL</li>
         *                        <li>IDPSignout <em>optional</em></li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerDetails(java.lang.Object providerDetails) {
            this.providerDetails = providerDetails;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolIdentityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolIdentityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolIdentityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolIdentityProviderProps {
        private final java.lang.String providerName;
        private final java.lang.String providerType;
        private final java.lang.String userPoolId;
        private final java.lang.Object attributeMapping;
        private final java.util.List<java.lang.String> idpIdentifiers;
        private final java.lang.Object providerDetails;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.providerType = software.amazon.jsii.Kernel.get(this, "providerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributeMapping = software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.idpIdentifiers = software.amazon.jsii.Kernel.get(this, "idpIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.providerDetails = software.amazon.jsii.Kernel.get(this, "providerDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
            this.providerType = java.util.Objects.requireNonNull(builder.providerType, "providerType is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.attributeMapping = builder.attributeMapping;
            this.idpIdentifiers = builder.idpIdentifiers;
            this.providerDetails = builder.providerDetails;
        }

        @Override
        public final java.lang.String getProviderName() {
            return this.providerName;
        }

        @Override
        public final java.lang.String getProviderType() {
            return this.providerType;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        public final java.util.List<java.lang.String> getIdpIdentifiers() {
            return this.idpIdentifiers;
        }

        @Override
        public final java.lang.Object getProviderDetails() {
            return this.providerDetails;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("providerName", om.valueToTree(this.getProviderName()));
            data.set("providerType", om.valueToTree(this.getProviderType()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }
            if (this.getIdpIdentifiers() != null) {
                data.set("idpIdentifiers", om.valueToTree(this.getIdpIdentifiers()));
            }
            if (this.getProviderDetails() != null) {
                data.set("providerDetails", om.valueToTree(this.getProviderDetails()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolIdentityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolIdentityProviderProps.Jsii$Proxy that = (CfnUserPoolIdentityProviderProps.Jsii$Proxy) o;

            if (!providerName.equals(that.providerName)) return false;
            if (!providerType.equals(that.providerType)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.attributeMapping != null ? !this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping != null) return false;
            if (this.idpIdentifiers != null ? !this.idpIdentifiers.equals(that.idpIdentifiers) : that.idpIdentifiers != null) return false;
            return this.providerDetails != null ? this.providerDetails.equals(that.providerDetails) : that.providerDetails == null;
        }

        @Override
        public final int hashCode() {
            int result = this.providerName.hashCode();
            result = 31 * result + (this.providerType.hashCode());
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            result = 31 * result + (this.idpIdentifiers != null ? this.idpIdentifiers.hashCode() : 0);
            result = 31 * result + (this.providerDetails != null ? this.providerDetails.hashCode() : 0);
            return result;
        }
    }
}
