package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPoolUser`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object clientMetadata;
 * CfnUserPoolUserProps cfnUserPoolUserProps = CfnUserPoolUserProps.builder()
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .clientMetadata(clientMetadata)
 *         .desiredDeliveryMediums(List.of("desiredDeliveryMediums"))
 *         .forceAliasCreation(false)
 *         .messageAction("messageAction")
 *         .userAttributes(List.of(AttributeTypeProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .username("username")
 *         .validationData(List.of(AttributeTypeProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:33.164Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user pool ID for the user pool where the user will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * A map of custom key-value pairs that you can provide as input for the custom workflow that is invoked by the *pre sign-up* trigger.
     * <p>
     * You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you create a <code>UserPoolUser</code> resource and include the <code>ClientMetadata</code> property, Amazon Cognito invokes the function that is assigned to the <em>pre sign-up</em> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata property. In your function code in AWS Lambda , you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <em>Amazon Cognito Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Take the following limitations into consideration when you use the ClientMetadata parameter:
     * <p>
     * <ul>
     * <li>Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</li>
     * <li>Amazon Cognito does not validate the ClientMetadata value.</li>
     * <li>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientMetadata() {
        return null;
    }

    /**
     * Specify `"EMAIL"` if email will be used to send the welcome message.
     * <p>
     * Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code> . You can specify more than one value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDesiredDeliveryMediums() {
        return null;
    }

    /**
     * This parameter is used only if the `phone_number_verified` or `email_verified` attribute is set to `True` .
     * <p>
     * Otherwise, it is ignored.
     * <p>
     * If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.
     * <p>
     * If this parameter is set to <code>False</code> , the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceAliasCreation() {
        return null;
    }

    /**
     * Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account.
     * <p>
     * Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMessageAction() {
        return null;
    }

    /**
     * The user attributes and attribute values to be set for the user to be created.
     * <p>
     * These are name-value pairs You can create a user without specifying any attributes other than <code>Username</code> . However, any attributes that you specify as required (in <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html"></a> or in the <em>Attributes</em> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code> ) or by the user (when they sign up in response to your welcome message).
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * <p>
     * To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <em>Users</em> tab of the Amazon Cognito console for managing your user pools.
     * <p>
     * In your call to <code>AdminCreateUser</code> , you can set the <code>email_verified</code> attribute to <code>True</code> , and you can set the <code>phone_number_verified</code> attribute to <code>True</code> . (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html"></a> .)
     * <p>
     * <ul>
     * <li><em>email</em> : The email address of the user to whom the message that contains the code and user name will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code> , or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
     * <li><em>phone_number</em> : The phone number of the user to whom the message that contains the code and user name will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code> , or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserAttributes() {
        return null;
    }

    /**
     * The username for the user.
     * <p>
     * Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username can't be changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return null;
    }

    /**
     * The user's validation data.
     * <p>
     * This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.
     * <p>
     * To configure custom validation, you must create a Pre Sign-up AWS Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.
     * <p>
     * The user's validation data isn't persisted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidationData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolUserProps> {
        java.lang.String userPoolId;
        java.lang.Object clientMetadata;
        java.util.List<java.lang.String> desiredDeliveryMediums;
        java.lang.Object forceAliasCreation;
        java.lang.String messageAction;
        java.lang.Object userAttributes;
        java.lang.String username;
        java.lang.Object validationData;

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getUserPoolId}
         * @param userPoolId The user pool ID for the user pool where the user will be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getClientMetadata}
         * @param clientMetadata A map of custom key-value pairs that you can provide as input for the custom workflow that is invoked by the *pre sign-up* trigger.
         *                       You create custom workflows by assigning AWS Lambda functions to user pool triggers. When you create a <code>UserPoolUser</code> resource and include the <code>ClientMetadata</code> property, Amazon Cognito invokes the function that is assigned to the <em>pre sign-up</em> trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a <code>clientMetadata</code> attribute, which provides the data that you assigned to the ClientMetadata property. In your function code in AWS Lambda , you can process the <code>clientMetadata</code> value to enhance your workflow for your specific needs.
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">Customizing User Pool Workflows with Lambda Triggers</a> in the <em>Amazon Cognito Developer Guide</em> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       Take the following limitations into consideration when you use the ClientMetadata parameter:
         *                       <p>
         *                       <ul>
         *                       <li>Amazon Cognito does not store the ClientMetadata value. This data is available only to AWS Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.</li>
         *                       <li>Amazon Cognito does not validate the ClientMetadata value.</li>
         *                       <li>Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.</li>
         *                       </ul>
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientMetadata(java.lang.Object clientMetadata) {
            this.clientMetadata = clientMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getDesiredDeliveryMediums}
         * @param desiredDeliveryMediums Specify `"EMAIL"` if email will be used to send the welcome message.
         *                               Specify <code>"SMS"</code> if the phone number will be used. The default value is <code>"SMS"</code> . You can specify more than one value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredDeliveryMediums(java.util.List<java.lang.String> desiredDeliveryMediums) {
            this.desiredDeliveryMediums = desiredDeliveryMediums;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getForceAliasCreation}
         * @param forceAliasCreation This parameter is used only if the `phone_number_verified` or `email_verified` attribute is set to `True` .
         *                           Otherwise, it is ignored.
         *                           <p>
         *                           If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.
         *                           <p>
         *                           If this parameter is set to <code>False</code> , the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceAliasCreation(java.lang.Boolean forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getForceAliasCreation}
         * @param forceAliasCreation This parameter is used only if the `phone_number_verified` or `email_verified` attribute is set to `True` .
         *                           Otherwise, it is ignored.
         *                           <p>
         *                           If this parameter is set to <code>True</code> and the phone number or email address specified in the UserAttributes parameter already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias.
         *                           <p>
         *                           If this parameter is set to <code>False</code> , the API throws an <code>AliasExistsException</code> error if the alias already exists. The default value is <code>False</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceAliasCreation(software.amazon.awscdk.core.IResolvable forceAliasCreation) {
            this.forceAliasCreation = forceAliasCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getMessageAction}
         * @param messageAction Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account.
         *                      Set to <code>SUPPRESS</code> to suppress sending the message. You can specify only one value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageAction(java.lang.String messageAction) {
            this.messageAction = messageAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getUserAttributes}
         * @param userAttributes The user attributes and attribute values to be set for the user to be created.
         *                       These are name-value pairs You can create a user without specifying any attributes other than <code>Username</code> . However, any attributes that you specify as required (in <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html"></a> or in the <em>Attributes</em> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code> ) or by the user (when they sign up in response to your welcome message).
         *                       <p>
         *                       For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         *                       <p>
         *                       To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <em>Users</em> tab of the Amazon Cognito console for managing your user pools.
         *                       <p>
         *                       In your call to <code>AdminCreateUser</code> , you can set the <code>email_verified</code> attribute to <code>True</code> , and you can set the <code>phone_number_verified</code> attribute to <code>True</code> . (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html"></a> .)
         *                       <p>
         *                       <ul>
         *                       <li><em>email</em> : The email address of the user to whom the message that contains the code and user name will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code> , or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
         *                       <li><em>phone_number</em> : The phone number of the user to whom the message that contains the code and user name will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code> , or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributes(software.amazon.awscdk.core.IResolvable userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getUserAttributes}
         * @param userAttributes The user attributes and attribute values to be set for the user to be created.
         *                       These are name-value pairs You can create a user without specifying any attributes other than <code>Username</code> . However, any attributes that you specify as required (in <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html"></a> or in the <em>Attributes</em> tab of the console) must be supplied either by you (in your call to <code>AdminCreateUser</code> ) or by the user (when they sign up in response to your welcome message).
         *                       <p>
         *                       For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         *                       <p>
         *                       To send a message inviting the user to sign up, you must specify the user's email address or phone number. This can be done in your call to AdminCreateUser or in the <em>Users</em> tab of the Amazon Cognito console for managing your user pools.
         *                       <p>
         *                       In your call to <code>AdminCreateUser</code> , you can set the <code>email_verified</code> attribute to <code>True</code> , and you can set the <code>phone_number_verified</code> attribute to <code>True</code> . (You can also do this by calling <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html"></a> .)
         *                       <p>
         *                       <ul>
         *                       <li><em>email</em> : The email address of the user to whom the message that contains the code and user name will be sent. Required if the <code>email_verified</code> attribute is set to <code>True</code> , or if <code>"EMAIL"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
         *                       <li><em>phone_number</em> : The phone number of the user to whom the message that contains the code and user name will be sent. Required if the <code>phone_number_verified</code> attribute is set to <code>True</code> , or if <code>"SMS"</code> is specified in the <code>DesiredDeliveryMediums</code> parameter.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributes(java.util.List<? extends java.lang.Object> userAttributes) {
            this.userAttributes = userAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getUsername}
         * @param username The username for the user.
         *                 Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username can't be changed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getValidationData}
         * @param validationData The user's validation data.
         *                       This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.
         *                       <p>
         *                       To configure custom validation, you must create a Pre Sign-up AWS Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.
         *                       <p>
         *                       The user's validation data isn't persisted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationData(software.amazon.awscdk.core.IResolvable validationData) {
            this.validationData = validationData;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUserProps#getValidationData}
         * @param validationData The user's validation data.
         *                       This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. For example, you might choose to allow or disallow user sign-up based on the user's domain.
         *                       <p>
         *                       To configure custom validation, you must create a Pre Sign-up AWS Lambda trigger for the user pool as described in the Amazon Cognito Developer Guide. The Lambda trigger receives the validation data and uses it in the validation process.
         *                       <p>
         *                       The user's validation data isn't persisted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationData(java.util.List<? extends java.lang.Object> validationData) {
            this.validationData = validationData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolUserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolUserProps {
        private final java.lang.String userPoolId;
        private final java.lang.Object clientMetadata;
        private final java.util.List<java.lang.String> desiredDeliveryMediums;
        private final java.lang.Object forceAliasCreation;
        private final java.lang.String messageAction;
        private final java.lang.Object userAttributes;
        private final java.lang.String username;
        private final java.lang.Object validationData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientMetadata = software.amazon.jsii.Kernel.get(this, "clientMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.desiredDeliveryMediums = software.amazon.jsii.Kernel.get(this, "desiredDeliveryMediums", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.forceAliasCreation = software.amazon.jsii.Kernel.get(this, "forceAliasCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.messageAction = software.amazon.jsii.Kernel.get(this, "messageAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userAttributes = software.amazon.jsii.Kernel.get(this, "userAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validationData = software.amazon.jsii.Kernel.get(this, "validationData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.clientMetadata = builder.clientMetadata;
            this.desiredDeliveryMediums = builder.desiredDeliveryMediums;
            this.forceAliasCreation = builder.forceAliasCreation;
            this.messageAction = builder.messageAction;
            this.userAttributes = builder.userAttributes;
            this.username = builder.username;
            this.validationData = builder.validationData;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getClientMetadata() {
            return this.clientMetadata;
        }

        @Override
        public final java.util.List<java.lang.String> getDesiredDeliveryMediums() {
            return this.desiredDeliveryMediums;
        }

        @Override
        public final java.lang.Object getForceAliasCreation() {
            return this.forceAliasCreation;
        }

        @Override
        public final java.lang.String getMessageAction() {
            return this.messageAction;
        }

        @Override
        public final java.lang.Object getUserAttributes() {
            return this.userAttributes;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final java.lang.Object getValidationData() {
            return this.validationData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getClientMetadata() != null) {
                data.set("clientMetadata", om.valueToTree(this.getClientMetadata()));
            }
            if (this.getDesiredDeliveryMediums() != null) {
                data.set("desiredDeliveryMediums", om.valueToTree(this.getDesiredDeliveryMediums()));
            }
            if (this.getForceAliasCreation() != null) {
                data.set("forceAliasCreation", om.valueToTree(this.getForceAliasCreation()));
            }
            if (this.getMessageAction() != null) {
                data.set("messageAction", om.valueToTree(this.getMessageAction()));
            }
            if (this.getUserAttributes() != null) {
                data.set("userAttributes", om.valueToTree(this.getUserAttributes()));
            }
            if (this.getUsername() != null) {
                data.set("username", om.valueToTree(this.getUsername()));
            }
            if (this.getValidationData() != null) {
                data.set("validationData", om.valueToTree(this.getValidationData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolUserProps.Jsii$Proxy that = (CfnUserPoolUserProps.Jsii$Proxy) o;

            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.clientMetadata != null ? !this.clientMetadata.equals(that.clientMetadata) : that.clientMetadata != null) return false;
            if (this.desiredDeliveryMediums != null ? !this.desiredDeliveryMediums.equals(that.desiredDeliveryMediums) : that.desiredDeliveryMediums != null) return false;
            if (this.forceAliasCreation != null ? !this.forceAliasCreation.equals(that.forceAliasCreation) : that.forceAliasCreation != null) return false;
            if (this.messageAction != null ? !this.messageAction.equals(that.messageAction) : that.messageAction != null) return false;
            if (this.userAttributes != null ? !this.userAttributes.equals(that.userAttributes) : that.userAttributes != null) return false;
            if (this.username != null ? !this.username.equals(that.username) : that.username != null) return false;
            return this.validationData != null ? this.validationData.equals(that.validationData) : that.validationData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPoolId.hashCode();
            result = 31 * result + (this.clientMetadata != null ? this.clientMetadata.hashCode() : 0);
            result = 31 * result + (this.desiredDeliveryMediums != null ? this.desiredDeliveryMediums.hashCode() : 0);
            result = 31 * result + (this.forceAliasCreation != null ? this.forceAliasCreation.hashCode() : 0);
            result = 31 * result + (this.messageAction != null ? this.messageAction.hashCode() : 0);
            result = 31 * result + (this.userAttributes != null ? this.userAttributes.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            result = 31 * result + (this.validationData != null ? this.validationData.hashCode() : 0);
            return result;
        }
    }
}
