package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPoolDomain`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolDomainProps cfnUserPoolDomainProps = CfnUserPoolDomainProps.builder()
 *         .domain("domain")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .customDomainConfig(CustomDomainConfigTypeProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:33.118Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CfnUserPoolDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name for the domain that hosts the sign-up and sign-in pages for your application.
     * <p>
     * For example: <code>auth.example.com</code> . If you're using a prefix domain, this field denotes the first part of the domain before <code>.auth.[region].amazoncognito.com</code> .
     * <p>
     * This string can include only lowercase letters, numbers, and hyphens. Don't use a hyphen for the first or last character. Use periods to separate subdomain names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomain();

    /**
     * The user pool ID for the user pool where you want to associate a user pool domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
     * <p>
     * Use this object to specify an SSL certificate that is managed by ACM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomDomainConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolDomainProps> {
        java.lang.String domain;
        java.lang.String userPoolId;
        java.lang.Object customDomainConfig;

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getDomain}
         * @param domain The domain name for the domain that hosts the sign-up and sign-in pages for your application. This parameter is required.
         *               For example: <code>auth.example.com</code> . If you're using a prefix domain, this field denotes the first part of the domain before <code>.auth.[region].amazoncognito.com</code> .
         *               <p>
         *               This string can include only lowercase letters, numbers, and hyphens. Don't use a hyphen for the first or last character. Use periods to separate subdomain names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getUserPoolId}
         * @param userPoolId The user pool ID for the user pool where you want to associate a user pool domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getCustomDomainConfig}
         * @param customDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
         *                           Use this object to specify an SSL certificate that is managed by ACM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomainConfig(software.amazon.awscdk.core.IResolvable customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolDomainProps#getCustomDomainConfig}
         * @param customDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in pages for your application.
         *                           Use this object to specify an SSL certificate that is managed by ACM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomainConfig(software.amazon.awscdk.services.cognito.CfnUserPoolDomain.CustomDomainConfigTypeProperty customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolDomainProps {
        private final java.lang.String domain;
        private final java.lang.String userPoolId;
        private final java.lang.Object customDomainConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customDomainConfig = software.amazon.jsii.Kernel.get(this, "customDomainConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.customDomainConfig = builder.customDomainConfig;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getCustomDomainConfig() {
            return this.customDomainConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domain", om.valueToTree(this.getDomain()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getCustomDomainConfig() != null) {
                data.set("customDomainConfig", om.valueToTree(this.getCustomDomainConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CfnUserPoolDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolDomainProps.Jsii$Proxy that = (CfnUserPoolDomainProps.Jsii$Proxy) o;

            if (!domain.equals(that.domain)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            return this.customDomainConfig != null ? this.customDomainConfig.equals(that.customDomainConfig) : that.customDomainConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.customDomainConfig != null ? this.customDomainConfig.hashCode() : 0);
            return result;
        }
    }
}
