package software.amazon.awscdk.services.codestarnotifications;

/**
 * Standard set of options for `notifyOnXxx` codestar notification handler on construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * NotificationRuleOptions notificationRuleOptions = NotificationRuleOptions.builder()
 *         .detailType(DetailType.BASIC)
 *         .enabled(false)
 *         .notificationRuleName("notificationRuleName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:32.531Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codestarnotifications.$Module.class, fqn = "@aws-cdk/aws-codestarnotifications.NotificationRuleOptions")
@software.amazon.jsii.Jsii.Proxy(NotificationRuleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NotificationRuleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The level of detail to include in the notifications for this resource.
     * <p>
     * BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
     * FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     * <p>
     * Default: DetailType.FULL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.DetailType getDetailType() {
        return null;
    }

    /**
     * The status of the notification rule.
     * <p>
     * If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The name for the notification rule.
     * <p>
     * Notification rule names must be unique in your AWS account.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationRuleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NotificationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NotificationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NotificationRuleOptions> {
        software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        java.lang.Boolean enabled;
        java.lang.String notificationRuleName;

        /**
         * Sets the value of {@link NotificationRuleOptions#getDetailType}
         * @param detailType The level of detail to include in the notifications for this resource.
         *                   BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
         *                   FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(software.amazon.awscdk.services.codestarnotifications.DetailType detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleOptions#getEnabled}
         * @param enabled The status of the notification rule.
         *                If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleOptions#getNotificationRuleName}
         * @param notificationRuleName The name for the notification rule.
         *                             Notification rule names must be unique in your AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationRuleName(java.lang.String notificationRuleName) {
            this.notificationRuleName = notificationRuleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NotificationRuleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NotificationRuleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NotificationRuleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationRuleOptions {
        private final software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        private final java.lang.Boolean enabled;
        private final java.lang.String notificationRuleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.DetailType.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationRuleName = software.amazon.jsii.Kernel.get(this, "notificationRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detailType = builder.detailType;
            this.enabled = builder.enabled;
            this.notificationRuleName = builder.notificationRuleName;
        }

        @Override
        public final software.amazon.awscdk.services.codestarnotifications.DetailType getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getNotificationRuleName() {
            return this.notificationRuleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDetailType() != null) {
                data.set("detailType", om.valueToTree(this.getDetailType()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getNotificationRuleName() != null) {
                data.set("notificationRuleName", om.valueToTree(this.getNotificationRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codestarnotifications.NotificationRuleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NotificationRuleOptions.Jsii$Proxy that = (NotificationRuleOptions.Jsii$Proxy) o;

            if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.notificationRuleName != null ? this.notificationRuleName.equals(that.notificationRuleName) : that.notificationRuleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detailType != null ? this.detailType.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.notificationRuleName != null ? this.notificationRuleName.hashCode() : 0);
            return result;
        }
    }
}
