/**
 * <h1>AWS::CodeStar Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>GitHub Repository</h2>
 * <p>
 * To create a new GitHub Repository and commit the assets from S3 bucket into the repository after it is created:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.codestar.alpha.*;
 * import software.amazon.awscdk.services.s3.*;
 * 
 * GitHubRepository.Builder.create(stack, "GitHubRepo")
 *         .owner("aws")
 *         .repositoryName("aws-cdk")
 *         .accessToken(cdk.SecretValue.secretsManager("my-github-token", Map.of(
 *                 "jsonField", "token")))
 *         .contentsBucket(Bucket.fromBucketName(stack, "Bucket", "bucket-name"))
 *         .contentsKey("import.zip")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Update or Delete the GitHubRepository</h2>
 * <p>
 * At this moment, updates to the <code>GitHubRepository</code> are not supported and the repository will not be deleted upon the deletion of the CloudFormation stack. You will need to update or delete the GitHub repository manually.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.codestar.alpha;
