/**
 * <h2>AWS::CodeGuruProfiler Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance.
 * <p>
 * <h3>Installation</h3>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * </pre></blockquote>
 * <p>
 * <h3>Basic usage</h3>
 * <p>
 * Here's how to setup a profiling group and give your compute role permissions to publish to the profiling group to the profiling agent can publish profiling information:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // The execution role of your application that publishes to the ProfilingGroup via CodeGuru Profiler Profiling Agent. (the following is merely an example)
 * var publishAppRole = Role.Builder.create(stack, "PublishAppRole")
 *         .assumedBy(new AccountRootPrincipal())
 *         .build();
 * 
 * var profilingGroup = new ProfilingGroup(stack, "MyProfilingGroup");
 * profilingGroup.grantPublish(publishAppRole);
 * </pre></blockquote>
 * <p>
 * <h3>Compute Platform configuration</h3>
 * <p>
 * Code Guru Profiler supports multiple compute environments.
 * They can be configured when creating a Profiling Group by using the <code>computePlatform</code> property:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var profilingGroup = ProfilingGroup.Builder.create(stack, "MyProfilingGroup")
 *         .computePlatform(ComputePlatform.getAWS_LAMBDA())
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.codeguruprofiler;
