/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codecommit;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.codecommit.;
import software.amazon.awscdk.services.codecommit.IRepository;
import software.amazon.awscdk.services.codecommit.OnCommitOptions;
import software.amazon.awscdk.services.codecommit.RepositoryProps;
import software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-codecommit.Repository")
public class Repository
extends Resource
implements IRepository {
    protected Repository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Repository(@NotNull Construct scope, @NotNull String id, @NotNull RepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRepository fromRepositoryArn(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryArn) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryArn", IRepository.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryArn, "repositoryArn is required")});
    }

    @NotNull
    public static IRepository fromRepositoryName(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryName) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryName", IRepository.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryName, "repositoryName is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)this.jsiiCall("grant", Grant.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantPull(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantPull", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantPullPush(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantPullPush", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Repository notify(@NotNull String arn, @Nullable RepositoryTriggerOptions options) {
        return (Repository)this.jsiiCall("notify", Repository.class, new Object[]{Objects.requireNonNull(arn, "arn is required"), options});
    }

    @NotNull
    public Repository notify(@NotNull String arn) {
        return (Repository)this.jsiiCall("notify", Repository.class, new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    @Override
    @NotNull
    public Rule onCommentOnCommit(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onCommentOnCommit", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommentOnCommit(@NotNull String id) {
        return (Rule)this.jsiiCall("onCommentOnCommit", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCommentOnPullRequest(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onCommentOnPullRequest", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommentOnPullRequest(@NotNull String id) {
        return (Rule)this.jsiiCall("onCommentOnPullRequest", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCommit(@NotNull String id, @Nullable OnCommitOptions options) {
        return (Rule)this.jsiiCall("onCommit", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommit(@NotNull String id) {
        return (Rule)this.jsiiCall("onCommit", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)this.jsiiCall("onEvent", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onPullRequestStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onPullRequestStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onPullRequestStateChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onPullRequestStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceCreated(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onReferenceCreated", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceCreated(@NotNull String id) {
        return (Rule)this.jsiiCall("onReferenceCreated", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceDeleted(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onReferenceDeleted", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceDeleted(@NotNull String id) {
        return (Rule)this.jsiiCall("onReferenceDeleted", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceUpdated(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onReferenceUpdated", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceUpdated(@NotNull String id) {
        return (Rule)this.jsiiCall("onReferenceUpdated", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id) {
        return (Rule)this.jsiiCall("onStateChange", Rule.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public String getRepositoryArn() {
        return (String)this.jsiiGet("repositoryArn", String.class);
    }

    @Override
    @NotNull
    public String getRepositoryCloneUrlHttp() {
        return (String)this.jsiiGet("repositoryCloneUrlHttp", String.class);
    }

    @Override
    @NotNull
    public String getRepositoryCloneUrlSsh() {
        return (String)this.jsiiGet("repositoryCloneUrlSsh", String.class);
    }

    @Override
    @NotNull
    public String getRepositoryName() {
        return (String)this.jsiiGet("repositoryName", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Repository> {
        private final Construct scope;
        private final String id;
        private final RepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new RepositoryProps.Builder();
        }

        public Builder repositoryName(String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Repository build() {
            return new Repository(this.scope, this.id, this.props.build());
        }
    }
}

