package software.amazon.awscdk.services.codecommit;

/**
 * Creates for a repository trigger to an SNS topic or Lambda function.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.527Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.RepositoryTriggerOptions")
@software.amazon.jsii.Jsii.Proxy(RepositoryTriggerOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RepositoryTriggerOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The names of the branches in the AWS CodeCommit repository that contain events that you want to include in the trigger.
     * <p>
     * If you don't specify at
     * least one branch, the trigger applies to all branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranches() {
        return null;
    }

    /**
     * When an event is triggered, additional information that AWS CodeCommit includes when it sends information to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomData() {
        return null;
    }

    /**
     * The repository events for which AWS CodeCommit sends information to the target, which you specified in the DestinationArn property.If you don't specify events, the trigger runs for all repository events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> getEvents() {
        return null;
    }

    /**
     * A name for the trigger.Triggers on a repository must have unique names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RepositoryTriggerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RepositoryTriggerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RepositoryTriggerOptions> {
        private java.util.List<java.lang.String> branches;
        private java.lang.String customData;
        private java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> events;
        private java.lang.String name;

        /**
         * Sets the value of {@link RepositoryTriggerOptions#getBranches}
         * @param branches The names of the branches in the AWS CodeCommit repository that contain events that you want to include in the trigger.
         *                 If you don't specify at
         *                 least one branch, the trigger applies to all branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branches(java.util.List<java.lang.String> branches) {
            this.branches = branches;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryTriggerOptions#getCustomData}
         * @param customData When an event is triggered, additional information that AWS CodeCommit includes when it sends information to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customData(java.lang.String customData) {
            this.customData = customData;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryTriggerOptions#getEvents}
         * @param events The repository events for which AWS CodeCommit sends information to the target, which you specified in the DestinationArn property.If you don't specify events, the trigger runs for all repository events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link RepositoryTriggerOptions#getName}
         * @param name A name for the trigger.Triggers on a repository must have unique names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RepositoryTriggerOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RepositoryTriggerOptions build() {
            return new Jsii$Proxy(branches, customData, events, name);
        }
    }

    /**
     * An implementation for {@link RepositoryTriggerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryTriggerOptions {
        private final java.util.List<java.lang.String> branches;
        private final java.lang.String customData;
        private final java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> events;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.branches = this.jsiiGet("branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.customData = this.jsiiGet("customData", java.lang.String.class);
            this.events = this.jsiiGet("events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.RepositoryEventTrigger.class)));
            this.name = this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> branches, final java.lang.String customData, final java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> events, final java.lang.String name) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.branches = branches;
            this.customData = customData;
            this.events = events;
            this.name = name;
        }

        @Override
        public java.util.List<java.lang.String> getBranches() {
            return this.branches;
        }

        @Override
        public java.lang.String getCustomData() {
            return this.customData;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codecommit.RepositoryEventTrigger> getEvents() {
            return this.events;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBranches() != null) {
                data.set("branches", om.valueToTree(this.getBranches()));
            }
            if (this.getCustomData() != null) {
                data.set("customData", om.valueToTree(this.getCustomData()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codecommit.RepositoryTriggerOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RepositoryTriggerOptions.Jsii$Proxy that = (RepositoryTriggerOptions.Jsii$Proxy) o;

            if (this.branches != null ? !this.branches.equals(that.branches) : that.branches != null) return false;
            if (this.customData != null ? !this.customData.equals(that.customData) : that.customData != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public int hashCode() {
            int result = this.branches != null ? this.branches.hashCode() : 0;
            result = 31 * result + (this.customData != null ? this.customData.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
