package software.amazon.awscdk.services.codecommit;

/**
 * Fields of CloudWatch Events that change references.
 * <p>
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.ReferenceEvent")
public class ReferenceEvent extends software.amazon.jsii.JsiiObject {

    protected ReferenceEvent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReferenceEvent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Commit id this reference now points to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getCommitId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "commitId", java.lang.String.class);
    }

    /**
     * The type of reference event.
     * <p>
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEventType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "eventType", java.lang.String.class);
    }

    /**
     * Full reference name.
     * <p>
     * For example, 'refs/tags/myTag'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceFullName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceFullName", java.lang.String.class);
    }

    /**
     * Name of reference changed (branch or tag name).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceName", java.lang.String.class);
    }

    /**
     * Type of reference changed.
     * <p>
     * 'branch' or 'tag'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceType", java.lang.String.class);
    }

    /**
     * Id of the CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRepositoryId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "repositoryId", java.lang.String.class);
    }

    /**
     * Name of the CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "repositoryName", java.lang.String.class);
    }
}
