package software.amazon.awscdk.services.codecommit;

/**
 * A CloudFormation `AWS::CodeCommit::Repository`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.515Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.CfnRepository")
public class CfnRepository extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRepository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.CfnRepository.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CodeCommit::Repository`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.CfnRepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloneUrlHttp() {
        return this.jsiiGet("attrCloneUrlHttp", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloneUrlSsh() {
        return this.jsiiGet("attrCloneUrlSsh", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return this.jsiiGet("attrName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CodeCommit::Repository.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CodeCommit::Repository.RepositoryName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return this.jsiiGet("repositoryName", java.lang.String.class);
    }

    /**
     * `AWS::CodeCommit::Repository.RepositoryName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepositoryName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("repositoryName", java.util.Objects.requireNonNull(value, "repositoryName is required"));
    }

    /**
     * `AWS::CodeCommit::Repository.Code`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCode() {
        return this.jsiiGet("code", java.lang.Object.class);
    }

    /**
     * `AWS::CodeCommit::Repository.Code`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.CfnRepository.CodeProperty value) {
        this.jsiiSet("code", value);
    }

    /**
     * `AWS::CodeCommit::Repository.Code`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("code", value);
    }

    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRepositoryDescription() {
        return this.jsiiGet("repositoryDescription", java.lang.String.class);
    }

    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepositoryDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("repositoryDescription", value);
    }

    /**
     * `AWS::CodeCommit::Repository.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return this.jsiiGet("triggers", java.lang.Object.class);
    }

    /**
     * `AWS::CodeCommit::Repository.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("triggers", value);
    }

    /**
     * `AWS::CodeCommit::Repository.Triggers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("triggers", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.CfnRepository.CodeProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRepository.CodeProperty.S3`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html#cfn-codecommit-repository-code-s3
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3();

        /**
         * @return a {@link Builder} of {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeProperty> {
            private java.lang.Object s3;

            /**
             * Sets the value of {@link CodeProperty#getS3}
             * @param s3 `CfnRepository.CodeProperty.S3`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.core.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link CodeProperty#getS3}
             * @param s3 `CfnRepository.CodeProperty.S3`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.codecommit.CfnRepository.S3Property s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeProperty build() {
                return new Jsii$Proxy(s3);
            }
        }

        /**
         * An implementation for {@link CodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = this.jsiiGet("s3", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object s3) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = java.util.Objects.requireNonNull(s3, "s3 is required");
            }

            @Override
            public java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3", om.valueToTree(this.getS3()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codecommit.CfnRepository.CodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeProperty.Jsii$Proxy that = (CodeProperty.Jsii$Proxy) o;

                return this.s3.equals(that.s3);
            }

            @Override
            public int hashCode() {
                int result = this.s3.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.CfnRepository.RepositoryTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(RepositoryTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RepositoryTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRepository.RepositoryTriggerProperty.DestinationArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationArn();

        /**
         * `CfnRepository.RepositoryTriggerProperty.Events`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-events
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

        /**
         * `CfnRepository.RepositoryTriggerProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnRepository.RepositoryTriggerProperty.Branches`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-branches
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranches() {
            return null;
        }

        /**
         * `CfnRepository.RepositoryTriggerProperty.CustomData`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-customdata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RepositoryTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RepositoryTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RepositoryTriggerProperty> {
            private java.lang.String destinationArn;
            private java.util.List<java.lang.String> events;
            private java.lang.String name;
            private java.util.List<java.lang.String> branches;
            private java.lang.String customData;

            /**
             * Sets the value of {@link RepositoryTriggerProperty#getDestinationArn}
             * @param destinationArn `CfnRepository.RepositoryTriggerProperty.DestinationArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link RepositoryTriggerProperty#getEvents}
             * @param events `CfnRepository.RepositoryTriggerProperty.Events`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link RepositoryTriggerProperty#getName}
             * @param name `CfnRepository.RepositoryTriggerProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RepositoryTriggerProperty#getBranches}
             * @param branches `CfnRepository.RepositoryTriggerProperty.Branches`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branches(java.util.List<java.lang.String> branches) {
                this.branches = branches;
                return this;
            }

            /**
             * Sets the value of {@link RepositoryTriggerProperty#getCustomData}
             * @param customData `CfnRepository.RepositoryTriggerProperty.CustomData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customData(java.lang.String customData) {
                this.customData = customData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RepositoryTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RepositoryTriggerProperty build() {
                return new Jsii$Proxy(destinationArn, events, name, branches, customData);
            }
        }

        /**
         * An implementation for {@link RepositoryTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryTriggerProperty {
            private final java.lang.String destinationArn;
            private final java.util.List<java.lang.String> events;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> branches;
            private final java.lang.String customData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.events = this.jsiiGet("events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.branches = this.jsiiGet("branches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customData = this.jsiiGet("customData", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationArn, final java.util.List<java.lang.String> events, final java.lang.String name, final java.util.List<java.lang.String> branches, final java.lang.String customData) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = java.util.Objects.requireNonNull(destinationArn, "destinationArn is required");
                this.events = java.util.Objects.requireNonNull(events, "events is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.branches = branches;
                this.customData = customData;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.util.List<java.lang.String> getBranches() {
                return this.branches;
            }

            @Override
            public java.lang.String getCustomData() {
                return this.customData;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                data.set("events", om.valueToTree(this.getEvents()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getBranches() != null) {
                    data.set("branches", om.valueToTree(this.getBranches()));
                }
                if (this.getCustomData() != null) {
                    data.set("customData", om.valueToTree(this.getCustomData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codecommit.CfnRepository.RepositoryTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RepositoryTriggerProperty.Jsii$Proxy that = (RepositoryTriggerProperty.Jsii$Proxy) o;

                if (!destinationArn.equals(that.destinationArn)) return false;
                if (!events.equals(that.events)) return false;
                if (!name.equals(that.name)) return false;
                if (this.branches != null ? !this.branches.equals(that.branches) : that.branches != null) return false;
                return this.customData != null ? this.customData.equals(that.customData) : that.customData == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn.hashCode();
                result = 31 * result + (this.events.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.branches != null ? this.branches.hashCode() : 0);
                result = 31 * result + (this.customData != null ? this.customData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codecommit.$Module.class, fqn = "@aws-cdk/aws-codecommit.CfnRepository.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRepository.S3Property.Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnRepository.S3Property.Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnRepository.S3Property.ObjectVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-objectversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            private java.lang.String bucket;
            private java.lang.String key;
            private java.lang.String objectVersion;

            /**
             * Sets the value of {@link S3Property#getBucket}
             * @param bucket `CfnRepository.S3Property.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getKey}
             * @param key `CfnRepository.S3Property.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getObjectVersion}
             * @param objectVersion `CfnRepository.S3Property.ObjectVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectVersion(java.lang.String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(bucket, key, objectVersion);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String objectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.objectVersion = this.jsiiGet("objectVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.String key, final java.lang.String objectVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.objectVersion = objectVersion;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getObjectVersion() {
                return this.objectVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getObjectVersion() != null) {
                    data.set("objectVersion", om.valueToTree(this.getObjectVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codecommit.CfnRepository.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.objectVersion != null ? this.objectVersion.equals(that.objectVersion) : that.objectVersion == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.objectVersion != null ? this.objectVersion.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codecommit.CfnRepository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codecommit.CfnRepository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codecommit.CfnRepositoryProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codecommit.CfnRepositoryProps.Builder();
        }

        /**
         * `AWS::CodeCommit::Repository.RepositoryName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
         * @param repositoryName `AWS::CodeCommit::Repository.RepositoryName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * `AWS::CodeCommit::Repository.Code`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
         * @param code `AWS::CodeCommit::Repository.Code`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.codecommit.CfnRepository.CodeProperty code) {
            this.props.code(code);
            return this;
        }
        /**
         * `AWS::CodeCommit::Repository.Code`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
         * @param code `AWS::CodeCommit::Repository.Code`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.core.IResolvable code) {
            this.props.code(code);
            return this;
        }

        /**
         * `AWS::CodeCommit::Repository.RepositoryDescription`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
         * @param repositoryDescription `AWS::CodeCommit::Repository.RepositoryDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryDescription(final java.lang.String repositoryDescription) {
            this.props.repositoryDescription(repositoryDescription);
            return this;
        }

        /**
         * `AWS::CodeCommit::Repository.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
         * @param tags `AWS::CodeCommit::Repository.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::CodeCommit::Repository.Triggers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
         * @param triggers `AWS::CodeCommit::Repository.Triggers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.core.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * `AWS::CodeCommit::Repository.Triggers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
         * @param triggers `AWS::CodeCommit::Repository.Triggers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final java.util.List<java.lang.Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codecommit.CfnRepository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codecommit.CfnRepository build() {
            return new software.amazon.awscdk.services.codecommit.CfnRepository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
