package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for {@link ReportGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.929Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.ReportGroupProps")
@software.amazon.jsii.Jsii.Proxy(ReportGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReportGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An optional S3 bucket to export the reports to.
     * <p>
     * Default: - the reports will not be exported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getExportBucket() {
        return null;
    }

    /**
     * What to do when this resource is deleted from a stack.
     * <p>
     * As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
     * this is set to retain the resource by default.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The physical name of the report group.
     * <p>
     * Default: - CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReportGroupName() {
        return null;
    }

    /**
     * Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
     * <p>
     * Ignored if {&#64;link exportBucket} has not been provided.
     * <p>
     * Default: - false (the files will not be ZIPped)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getZipExport() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReportGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReportGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReportGroupProps> {
        private software.amazon.awscdk.services.s3.IBucket exportBucket;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private java.lang.String reportGroupName;
        private java.lang.Boolean zipExport;

        /**
         * Sets the value of {@link ReportGroupProps#getExportBucket}
         * @param exportBucket An optional S3 bucket to export the reports to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportBucket(software.amazon.awscdk.services.s3.IBucket exportBucket) {
            this.exportBucket = exportBucket;
            return this;
        }

        /**
         * Sets the value of {@link ReportGroupProps#getRemovalPolicy}
         * @param removalPolicy What to do when this resource is deleted from a stack.
         *                      As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
         *                      this is set to retain the resource by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ReportGroupProps#getReportGroupName}
         * @param reportGroupName The physical name of the report group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportGroupName(java.lang.String reportGroupName) {
            this.reportGroupName = reportGroupName;
            return this;
        }

        /**
         * Sets the value of {@link ReportGroupProps#getZipExport}
         * @param zipExport Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
         *                  Ignored if {&#64;link exportBucket} has not been provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zipExport(java.lang.Boolean zipExport) {
            this.zipExport = zipExport;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReportGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReportGroupProps build() {
            return new Jsii$Proxy(exportBucket, removalPolicy, reportGroupName, zipExport);
        }
    }

    /**
     * An implementation for {@link ReportGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportGroupProps {
        private final software.amazon.awscdk.services.s3.IBucket exportBucket;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.lang.String reportGroupName;
        private final java.lang.Boolean zipExport;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.exportBucket = this.jsiiGet("exportBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.reportGroupName = this.jsiiGet("reportGroupName", java.lang.String.class);
            this.zipExport = this.jsiiGet("zipExport", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket exportBucket, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final java.lang.String reportGroupName, final java.lang.Boolean zipExport) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.exportBucket = exportBucket;
            this.removalPolicy = removalPolicy;
            this.reportGroupName = reportGroupName;
            this.zipExport = zipExport;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getExportBucket() {
            return this.exportBucket;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public java.lang.String getReportGroupName() {
            return this.reportGroupName;
        }

        @Override
        public java.lang.Boolean getZipExport() {
            return this.zipExport;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExportBucket() != null) {
                data.set("exportBucket", om.valueToTree(this.getExportBucket()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReportGroupName() != null) {
                data.set("reportGroupName", om.valueToTree(this.getReportGroupName()));
            }
            if (this.getZipExport() != null) {
                data.set("zipExport", om.valueToTree(this.getZipExport()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.ReportGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReportGroupProps.Jsii$Proxy that = (ReportGroupProps.Jsii$Proxy) o;

            if (this.exportBucket != null ? !this.exportBucket.equals(that.exportBucket) : that.exportBucket != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.reportGroupName != null ? !this.reportGroupName.equals(that.reportGroupName) : that.reportGroupName != null) return false;
            return this.zipExport != null ? this.zipExport.equals(that.zipExport) : that.zipExport == null;
        }

        @Override
        public int hashCode() {
            int result = this.exportBucket != null ? this.exportBucket.hashCode() : 0;
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.reportGroupName != null ? this.reportGroupName.hashCode() : 0);
            result = 31 * result + (this.zipExport != null ? this.zipExport.hashCode() : 0);
            return result;
        }
    }
}
