package software.amazon.awscdk.services.codebuild;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.924Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.PipelineProjectProps")
@software.amazon.jsii.Jsii.Proxy(PipelineProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineProjectProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.CommonProjectProps {

    /**
     * @return a {@link Builder} of {@link PipelineProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineProjectProps> {
        private java.lang.Boolean allowAllOutbound;
        private java.lang.Boolean badge;
        private software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private software.amazon.awscdk.services.codebuild.Cache cache;
        private java.lang.String description;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private java.lang.Boolean grantReportGroupPermissions;
        private java.lang.String projectName;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private software.amazon.awscdk.core.Duration timeout;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link PipelineProjectProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the CodeBuild to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         CodeBuild project to connect to network targets.
         *                         <p>
         *                         Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getBadge}
         * @param badge Indicates whether AWS CodeBuild generates a publicly accessible URL for your project's build badge.
         *              For more information, see Build Badges Sample
         *              in the AWS CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder badge(java.lang.Boolean badge) {
            this.badge = badge;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getBuildSpec}
         * @param buildSpec Filename or contents of buildspec in JSON format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(software.amazon.awscdk.services.codebuild.BuildSpec buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getCache}
         * @param cache Caching strategy to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(software.amazon.awscdk.services.codebuild.Cache cache) {
            this.cache = cache;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getDescription}
         * @param description A description of the project.
         *                    Use the description to identify the purpose
         *                    of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getEncryptionKey}
         * @param encryptionKey Encryption key to use to read and write artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getEnvironment}
         * @param environment Build environment to use for the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.services.codebuild.BuildEnvironment environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getEnvironmentVariables}
         * @param environmentVariables Additional environment variables to add to the build environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getFileSystemLocations}
         * @param fileSystemLocations An  ProjectFileSystemLocation objects for a CodeBuild build project.
         *                            A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         *                            and type of a file system created using Amazon Elastic File System.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = fileSystemLocations;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getGrantReportGroupPermissions}
         * @param grantReportGroupPermissions Add permissions to this project's role to create and use test report groups with name starting with the name of this project.
         *                                    That is the standard report group that gets created when a simple name
         *                                    (in contrast to an ARN)
         *                                    is used in the 'reports' section of the buildspec of this project.
         *                                    This is usually harmless, but you can turn these off if you don't plan on using test
         *                                    reports in this project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantReportGroupPermissions(java.lang.Boolean grantReportGroupPermissions) {
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getProjectName}
         * @param projectName The physical, human-readable name of the CodeBuild Project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getRole}
         * @param role Service Role to assume while running the build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getSecurityGroups}
         * @param securityGroups What security group to associate with the codebuild project's network interfaces.
         *                       If no security group is identified, one will be created automatically.
         *                       <p>
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getSubnetSelection}
         * @param subnetSelection Where to place the network interfaces within the VPC.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProjectProps#getVpc}
         * @param vpc VPC network to place codebuild network interfaces.
         *            Specify this if the codebuild project needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineProjectProps build() {
            return new Jsii$Proxy(allowAllOutbound, badge, buildSpec, cache, description, encryptionKey, environment, environmentVariables, fileSystemLocations, grantReportGroupPermissions, projectName, role, securityGroups, subnetSelection, timeout, vpc);
        }
    }

    /**
     * An implementation for {@link PipelineProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineProjectProps {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean badge;
        private final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec;
        private final software.amazon.awscdk.services.codebuild.Cache cache;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment environment;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables;
        private final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private final java.lang.Boolean grantReportGroupPermissions;
        private final java.lang.String projectName;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.core.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.badge = this.jsiiGet("badge", java.lang.Boolean.class);
            this.buildSpec = this.jsiiGet("buildSpec", software.amazon.awscdk.services.codebuild.BuildSpec.class);
            this.cache = this.jsiiGet("cache", software.amazon.awscdk.services.codebuild.Cache.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
            this.environment = this.jsiiGet("environment", software.amazon.awscdk.services.codebuild.BuildEnvironment.class);
            this.environmentVariables = this.jsiiGet("environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable.class)));
            this.fileSystemLocations = this.jsiiGet("fileSystemLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class)));
            this.grantReportGroupPermissions = this.jsiiGet("grantReportGroupPermissions", java.lang.Boolean.class);
            this.projectName = this.jsiiGet("projectName", java.lang.String.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean allowAllOutbound, final java.lang.Boolean badge, final software.amazon.awscdk.services.codebuild.BuildSpec buildSpec, final software.amazon.awscdk.services.codebuild.Cache cache, final java.lang.String description, final software.amazon.awscdk.services.kms.IKey encryptionKey, final software.amazon.awscdk.services.codebuild.BuildEnvironment environment, final java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> environmentVariables, final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations, final java.lang.Boolean grantReportGroupPermissions, final java.lang.String projectName, final software.amazon.awscdk.services.iam.IRole role, final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final software.amazon.awscdk.core.Duration timeout, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = allowAllOutbound;
            this.badge = badge;
            this.buildSpec = buildSpec;
            this.cache = cache;
            this.description = description;
            this.encryptionKey = encryptionKey;
            this.environment = environment;
            this.environmentVariables = environmentVariables;
            this.fileSystemLocations = fileSystemLocations;
            this.grantReportGroupPermissions = grantReportGroupPermissions;
            this.projectName = projectName;
            this.role = role;
            this.securityGroups = securityGroups;
            this.subnetSelection = subnetSelection;
            this.timeout = timeout;
            this.vpc = vpc;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public java.lang.Boolean getBadge() {
            return this.badge;
        }

        @Override
        public software.amazon.awscdk.services.codebuild.BuildSpec getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public software.amazon.awscdk.services.codebuild.Cache getCache() {
            return this.cache;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public software.amazon.awscdk.services.codebuild.BuildEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
            return this.fileSystemLocations;
        }

        @Override
        public java.lang.Boolean getGrantReportGroupPermissions() {
            return this.grantReportGroupPermissions;
        }

        @Override
        public java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getBadge() != null) {
                data.set("badge", om.valueToTree(this.getBadge()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getCache() != null) {
                data.set("cache", om.valueToTree(this.getCache()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getFileSystemLocations() != null) {
                data.set("fileSystemLocations", om.valueToTree(this.getFileSystemLocations()));
            }
            if (this.getGrantReportGroupPermissions() != null) {
                data.set("grantReportGroupPermissions", om.valueToTree(this.getGrantReportGroupPermissions()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.PipelineProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineProjectProps.Jsii$Proxy that = (PipelineProjectProps.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.fileSystemLocations != null ? !this.fileSystemLocations.equals(that.fileSystemLocations) : that.fileSystemLocations != null) return false;
            if (this.grantReportGroupPermissions != null ? !this.grantReportGroupPermissions.equals(that.grantReportGroupPermissions) : that.grantReportGroupPermissions != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.fileSystemLocations != null ? this.fileSystemLocations.hashCode() : 0);
            result = 31 * result + (this.grantReportGroupPermissions != null ? this.grantReportGroupPermissions.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
