package software.amazon.awscdk.services.codebuild;

/**
 * The type returned from {@link IFileSystemLocation#bind}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:30.406Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.FileSystemConfig")
@software.amazon.jsii.Jsii.Proxy(FileSystemConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSystemConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * File system location wrapper property.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty getLocation();

    /**
     * @return a {@link Builder} of {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemConfig> {
        private software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty location;

        /**
         * Sets the value of {@link FileSystemConfig#getLocation}
         * @param location File system location wrapper property. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty location) {
            this.location = location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSystemConfig build() {
            return new Jsii$Proxy(location);
        }
    }

    /**
     * An implementation for {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemConfig {
        private final software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.location = this.jsiiGet("location", software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty location) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.location = java.util.Objects.requireNonNull(location, "location is required");
        }

        @Override
        public software.amazon.awscdk.services.codebuild.CfnProject.ProjectFileSystemLocationProperty getLocation() {
            return this.location;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("location", om.valueToTree(this.getLocation()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.FileSystemConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemConfig.Jsii$Proxy that = (FileSystemConfig.Jsii$Proxy) o;

            return this.location.equals(that.location);
        }

        @Override
        public int hashCode() {
            int result = this.location.hashCode();
            return result;
        }
    }
}
