package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for {@link BitBucketSource}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:27.904Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.BitBucketSourceProps")
@software.amazon.jsii.Jsii.Proxy(BitBucketSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BitBucketSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.SourceProps {

    /**
     * The BitBucket account/user that owns the repo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "awslabs";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * The name of the repo (without the username).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "aws-cdk";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepo();

    /**
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     * <p>
     * Default: the default branch's HEAD commit ID is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "mybranch";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranchOrRef() {
        return null;
    }

    /**
     * The depth of history to download.
     * <p>
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCloneDepth() {
        return null;
    }

    /**
     * Whether to send notifications on your build's start and end.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReportBuildStatus() {
        return null;
    }

    /**
     * Whether to create a webhook that will trigger a build every time an event happens in the repository.
     * <p>
     * Default: true if any `webhookFilters` were provided, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebhook() {
        return null;
    }

    /**
     * A list of webhook filters that can constraint what events in the repository will trigger a build.
     * <p>
     * A build is triggered if any of the provided filter groups match.
     * Only valid if <code>webhook</code> was not provided as false.
     * <p>
     * Default: every push and every Pull Request (create or update) triggers a build
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BitBucketSourceProps> {
        private java.lang.String owner;
        private java.lang.String repo;
        private java.lang.String branchOrRef;
        private java.lang.Number cloneDepth;
        private java.lang.Boolean reportBuildStatus;
        private java.lang.Boolean webhook;
        private java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        private java.lang.String identifier;

        /**
         * Sets the value of {@link BitBucketSourceProps#getOwner}
         * @param owner The BitBucket account/user that owns the repo. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getRepo}
         * @param repo The name of the repo (without the username). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repo(java.lang.String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getBranchOrRef}
         * @param branchOrRef The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchOrRef(java.lang.String branchOrRef) {
            this.branchOrRef = branchOrRef;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getCloneDepth}
         * @param cloneDepth The depth of history to download.
         *                   Minimum value is 0.
         *                   If this value is 0, greater than 25, or not provided,
         *                   then the full history is downloaded with each build of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneDepth(java.lang.Number cloneDepth) {
            this.cloneDepth = cloneDepth;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getReportBuildStatus}
         * @param reportBuildStatus Whether to send notifications on your build's start and end.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBuildStatus(java.lang.Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getWebhook}
         * @param webhook Whether to create a webhook that will trigger a build every time an event happens in the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webhook(java.lang.Boolean webhook) {
            this.webhook = webhook;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getWebhookFilters}
         * @param webhookFilters A list of webhook filters that can constraint what events in the repository will trigger a build.
         *                       A build is triggered if any of the provided filter groups match.
         *                       Only valid if <code>webhook</code> was not provided as false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webhookFilters(java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters) {
            this.webhookFilters = webhookFilters;
            return this;
        }

        /**
         * Sets the value of {@link BitBucketSourceProps#getIdentifier}
         * @param identifier The source identifier.
         *                   This property is required on secondary sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BitBucketSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BitBucketSourceProps build() {
            return new Jsii$Proxy(owner, repo, branchOrRef, cloneDepth, reportBuildStatus, webhook, webhookFilters, identifier);
        }
    }

    /**
     * An implementation for {@link BitBucketSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BitBucketSourceProps {
        private final java.lang.String owner;
        private final java.lang.String repo;
        private final java.lang.String branchOrRef;
        private final java.lang.Number cloneDepth;
        private final java.lang.Boolean reportBuildStatus;
        private final java.lang.Boolean webhook;
        private final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.owner = this.jsiiGet("owner", java.lang.String.class);
            this.repo = this.jsiiGet("repo", java.lang.String.class);
            this.branchOrRef = this.jsiiGet("branchOrRef", java.lang.String.class);
            this.cloneDepth = this.jsiiGet("cloneDepth", java.lang.Number.class);
            this.reportBuildStatus = this.jsiiGet("reportBuildStatus", java.lang.Boolean.class);
            this.webhook = this.jsiiGet("webhook", java.lang.Boolean.class);
            this.webhookFilters = this.jsiiGet("webhookFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class)));
            this.identifier = this.jsiiGet("identifier", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String owner, final java.lang.String repo, final java.lang.String branchOrRef, final java.lang.Number cloneDepth, final java.lang.Boolean reportBuildStatus, final java.lang.Boolean webhook, final java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> webhookFilters, final java.lang.String identifier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.owner = java.util.Objects.requireNonNull(owner, "owner is required");
            this.repo = java.util.Objects.requireNonNull(repo, "repo is required");
            this.branchOrRef = branchOrRef;
            this.cloneDepth = cloneDepth;
            this.reportBuildStatus = reportBuildStatus;
            this.webhook = webhook;
            this.webhookFilters = webhookFilters;
            this.identifier = identifier;
        }

        @Override
        public java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public java.lang.String getRepo() {
            return this.repo;
        }

        @Override
        public java.lang.String getBranchOrRef() {
            return this.branchOrRef;
        }

        @Override
        public java.lang.Number getCloneDepth() {
            return this.cloneDepth;
        }

        @Override
        public java.lang.Boolean getReportBuildStatus() {
            return this.reportBuildStatus;
        }

        @Override
        public java.lang.Boolean getWebhook() {
            return this.webhook;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codebuild.FilterGroup> getWebhookFilters() {
            return this.webhookFilters;
        }

        @Override
        public java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("repo", om.valueToTree(this.getRepo()));
            if (this.getBranchOrRef() != null) {
                data.set("branchOrRef", om.valueToTree(this.getBranchOrRef()));
            }
            if (this.getCloneDepth() != null) {
                data.set("cloneDepth", om.valueToTree(this.getCloneDepth()));
            }
            if (this.getReportBuildStatus() != null) {
                data.set("reportBuildStatus", om.valueToTree(this.getReportBuildStatus()));
            }
            if (this.getWebhook() != null) {
                data.set("webhook", om.valueToTree(this.getWebhook()));
            }
            if (this.getWebhookFilters() != null) {
                data.set("webhookFilters", om.valueToTree(this.getWebhookFilters()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.BitBucketSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BitBucketSourceProps.Jsii$Proxy that = (BitBucketSourceProps.Jsii$Proxy) o;

            if (!owner.equals(that.owner)) return false;
            if (!repo.equals(that.repo)) return false;
            if (this.branchOrRef != null ? !this.branchOrRef.equals(that.branchOrRef) : that.branchOrRef != null) return false;
            if (this.cloneDepth != null ? !this.cloneDepth.equals(that.cloneDepth) : that.cloneDepth != null) return false;
            if (this.reportBuildStatus != null ? !this.reportBuildStatus.equals(that.reportBuildStatus) : that.reportBuildStatus != null) return false;
            if (this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null) return false;
            if (this.webhookFilters != null ? !this.webhookFilters.equals(that.webhookFilters) : that.webhookFilters != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + (this.repo.hashCode());
            result = 31 * result + (this.branchOrRef != null ? this.branchOrRef.hashCode() : 0);
            result = 31 * result + (this.cloneDepth != null ? this.cloneDepth.hashCode() : 0);
            result = 31 * result + (this.reportBuildStatus != null ? this.reportBuildStatus.hashCode() : 0);
            result = 31 * result + (this.webhook != null ? this.webhook.hashCode() : 0);
            result = 31 * result + (this.webhookFilters != null ? this.webhookFilters.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
