package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a concrete metric.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.866Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.MetricExpressionConfig")
@software.amazon.jsii.Jsii.Proxy(MetricExpressionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricExpressionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Math expression for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * How many seconds to aggregate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

    /**
     * Metrics used in the math expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics();

    /**
     * @return a {@link Builder} of {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricExpressionConfig> {
        private java.lang.String expression;
        private java.lang.Number period;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;

        /**
         * Sets the value of {@link MetricExpressionConfig#getExpression}
         * @param expression Math expression for the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getPeriod}
         * @param period How many seconds to aggregate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(java.lang.Number period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link MetricExpressionConfig#getUsingMetrics}
         * @param usingMetrics Metrics used in the math expression. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usingMetrics(java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.usingMetrics = usingMetrics;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricExpressionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricExpressionConfig build() {
            return new Jsii$Proxy(expression, period, usingMetrics);
        }
    }

    /**
     * An implementation for {@link MetricExpressionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricExpressionConfig {
        private final java.lang.String expression;
        private final java.lang.Number period;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = this.jsiiGet("expression", java.lang.String.class);
            this.period = this.jsiiGet("period", java.lang.Number.class);
            this.usingMetrics = this.jsiiGet("usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String expression, final java.lang.Number period, final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(expression, "expression is required");
            this.period = java.util.Objects.requireNonNull(period, "period is required");
            this.usingMetrics = java.util.Objects.requireNonNull(usingMetrics, "usingMetrics is required");
        }

        @Override
        public java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public java.lang.Number getPeriod() {
            return this.period;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
            return this.usingMetrics;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            data.set("period", om.valueToTree(this.getPeriod()));
            data.set("usingMetrics", om.valueToTree(this.getUsingMetrics()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.MetricExpressionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricExpressionConfig.Jsii$Proxy that = (MetricExpressionConfig.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (!period.equals(that.period)) return false;
            return this.usingMetrics.equals(that.usingMetrics);
        }

        @Override
        public int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.period.hashCode());
            result = 31 * result + (this.usingMetrics.hashCode());
            return result;
        }
    }
}
