package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties of a rendered metric.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.866Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.MetricConfig")
@software.amazon.jsii.Jsii.Proxy(MetricConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * In case the metric is a math expression, the details of the math expression.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig getMathExpression() {
        return null;
    }

    /**
     * In case the metric represents a query, the details of the query.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricStatConfig getMetricStat() {
        return null;
    }

    /**
     * Additional properties which will be rendered if the metric is used in a dashboard.
     * <p>
     * Examples are 'label' and 'color', but any key in here will be
     * added to dashboard graphs.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getRenderingProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricConfig> {
        private software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression;
        private software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat;
        private java.util.Map<java.lang.String, java.lang.Object> renderingProperties;

        /**
         * Sets the value of {@link MetricConfig#getMathExpression}
         * @param mathExpression In case the metric is a math expression, the details of the math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mathExpression(software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression) {
            this.mathExpression = mathExpression;
            return this;
        }

        /**
         * Sets the value of {@link MetricConfig#getMetricStat}
         * @param metricStat In case the metric represents a query, the details of the query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricStat(software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        /**
         * Sets the value of {@link MetricConfig#getRenderingProperties}
         * @param renderingProperties Additional properties which will be rendered if the metric is used in a dashboard.
         *                            Examples are 'label' and 'color', but any key in here will be
         *                            added to dashboard graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingProperties(java.util.Map<java.lang.String, java.lang.Object> renderingProperties) {
            this.renderingProperties = renderingProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricConfig build() {
            return new Jsii$Proxy(mathExpression, metricStat, renderingProperties);
        }
    }

    /**
     * An implementation for {@link MetricConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricConfig {
        private final software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression;
        private final software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat;
        private final java.util.Map<java.lang.String, java.lang.Object> renderingProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mathExpression = this.jsiiGet("mathExpression", software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig.class);
            this.metricStat = this.jsiiGet("metricStat", software.amazon.awscdk.services.cloudwatch.MetricStatConfig.class);
            this.renderingProperties = this.jsiiGet("renderingProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig mathExpression, final software.amazon.awscdk.services.cloudwatch.MetricStatConfig metricStat, final java.util.Map<java.lang.String, java.lang.Object> renderingProperties) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mathExpression = mathExpression;
            this.metricStat = metricStat;
            this.renderingProperties = renderingProperties;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig getMathExpression() {
            return this.mathExpression;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.MetricStatConfig getMetricStat() {
            return this.metricStat;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getRenderingProperties() {
            return this.renderingProperties;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMathExpression() != null) {
                data.set("mathExpression", om.valueToTree(this.getMathExpression()));
            }
            if (this.getMetricStat() != null) {
                data.set("metricStat", om.valueToTree(this.getMetricStat()));
            }
            if (this.getRenderingProperties() != null) {
                data.set("renderingProperties", om.valueToTree(this.getRenderingProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.MetricConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricConfig.Jsii$Proxy that = (MetricConfig.Jsii$Proxy) o;

            if (this.mathExpression != null ? !this.mathExpression.equals(that.mathExpression) : that.mathExpression != null) return false;
            if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
            return this.renderingProperties != null ? this.renderingProperties.equals(that.renderingProperties) : that.renderingProperties == null;
        }

        @Override
        public int hashCode() {
            int result = this.mathExpression != null ? this.mathExpression.hashCode() : 0;
            result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
            result = 31 * result + (this.renderingProperties != null ? this.renderingProperties.hashCode() : 0);
            return result;
        }
    }
}
