package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a MathExpression.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.865Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.MathExpressionProps")
@software.amazon.jsii.Jsii.Proxy(MathExpressionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MathExpressionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MathExpressionOptions {

    /**
     * The expression defining the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * The metrics used in the expression, in a map.
     * <p>
     * The key is the identifier that represents the given metric in the
     * expression, and the value is the actual Metric object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics();

    /**
     * @return a {@link Builder} of {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MathExpressionProps> {
        private java.lang.String expression;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        private java.lang.String color;
        private java.lang.String label;
        private software.amazon.awscdk.core.Duration period;

        /**
         * Sets the value of {@link MathExpressionProps#getExpression}
         * @param expression The expression defining the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getUsingMetrics}
         * @param usingMetrics The metrics used in the expression, in a map. This parameter is required.
         *                     The key is the identifier that represents the given metric in the
         *                     expression, and the value is the actual Metric object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usingMetrics(java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.usingMetrics = usingMetrics;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getColor}
         * @param color Color for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link MathExpressionProps#getPeriod}
         * @param period The period over which the expression's statistics are applied.
         *               This period overrides all periods in the metrics used in this
         *               math expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.core.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MathExpressionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MathExpressionProps build() {
            return new Jsii$Proxy(expression, usingMetrics, color, label, period);
        }
    }

    /**
     * An implementation for {@link MathExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MathExpressionProps {
        private final java.lang.String expression;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics;
        private final java.lang.String color;
        private final java.lang.String label;
        private final software.amazon.awscdk.core.Duration period;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = this.jsiiGet("expression", java.lang.String.class);
            this.usingMetrics = this.jsiiGet("usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.color = this.jsiiGet("color", java.lang.String.class);
            this.label = this.jsiiGet("label", java.lang.String.class);
            this.period = this.jsiiGet("period", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String expression, final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics, final java.lang.String color, final java.lang.String label, final software.amazon.awscdk.core.Duration period) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(expression, "expression is required");
            this.usingMetrics = java.util.Objects.requireNonNull(usingMetrics, "usingMetrics is required");
            this.color = color;
            this.label = label;
            this.period = period;
        }

        @Override
        public java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
            return this.usingMetrics;
        }

        @Override
        public java.lang.String getColor() {
            return this.color;
        }

        @Override
        public java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public software.amazon.awscdk.core.Duration getPeriod() {
            return this.period;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            data.set("usingMetrics", om.valueToTree(this.getUsingMetrics()));
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.MathExpressionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MathExpressionProps.Jsii$Proxy that = (MathExpressionProps.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (!usingMetrics.equals(that.usingMetrics)) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            return this.period != null ? this.period.equals(that.period) : that.period == null;
        }

        @Override
        public int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.usingMetrics.hashCode());
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            return result;
        }
    }
}
