package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a Query widget.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.855Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.LogQueryWidgetProps")
@software.amazon.jsii.Jsii.Proxy(LogQueryWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogQueryWidgetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Names of log groups to query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLogGroupNames();

    /**
     * Height of the widget.
     * <p>
     * Default: 6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHeight() {
        return null;
    }

    /**
     * A sequence of lines to use to build the query.
     * <p>
     * The query will be built by joining the lines together using <code>\n|</code>.
     * <p>
     * Default: - Exactly one of `queryString`, `queryLines` is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryLines() {
        return null;
    }

    /**
     * Full query string for log insights.
     * <p>
     * Be sure to prepend every new line with a newline and pipe character
     * (<code>\n|</code>).
     * <p>
     * Default: - Exactly one of `queryString`, `queryLines` is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueryString() {
        return null;
    }

    /**
     * The region the metrics of this widget should be taken from.
     * <p>
     * Default: Current region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Title for the widget.
     * <p>
     * Default: No title
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
        return null;
    }

    /**
     * The type of view to use.
     * <p>
     * Default: LogQueryVisualizationType.TABLE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType getView() {
        return null;
    }

    /**
     * Width of the widget, in a grid of 24 units wide.
     * <p>
     * Default: 6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWidth() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogQueryWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogQueryWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogQueryWidgetProps> {
        private java.util.List<java.lang.String> logGroupNames;
        private java.lang.Number height;
        private java.util.List<java.lang.String> queryLines;
        private java.lang.String queryString;
        private java.lang.String region;
        private java.lang.String title;
        private software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType view;
        private java.lang.Number width;

        /**
         * Sets the value of {@link LogQueryWidgetProps#getLogGroupNames}
         * @param logGroupNames Names of log groups to query. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupNames(java.util.List<java.lang.String> logGroupNames) {
            this.logGroupNames = logGroupNames;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getQueryLines}
         * @param queryLines A sequence of lines to use to build the query.
         *                   The query will be built by joining the lines together using <code>\n|</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLines(java.util.List<java.lang.String> queryLines) {
            this.queryLines = queryLines;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getQueryString}
         * @param queryString Full query string for log insights.
         *                    Be sure to prepend every new line with a newline and pipe character
         *                    (<code>\n|</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(java.lang.String queryString) {
            this.queryString = queryString;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getRegion}
         * @param region The region the metrics of this widget should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getTitle}
         * @param title Title for the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getView}
         * @param view The type of view to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder view(software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType view) {
            this.view = view;
            return this;
        }

        /**
         * Sets the value of {@link LogQueryWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogQueryWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogQueryWidgetProps build() {
            return new Jsii$Proxy(logGroupNames, height, queryLines, queryString, region, title, view, width);
        }
    }

    /**
     * An implementation for {@link LogQueryWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogQueryWidgetProps {
        private final java.util.List<java.lang.String> logGroupNames;
        private final java.lang.Number height;
        private final java.util.List<java.lang.String> queryLines;
        private final java.lang.String queryString;
        private final java.lang.String region;
        private final java.lang.String title;
        private final software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType view;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroupNames = this.jsiiGet("logGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.height = this.jsiiGet("height", java.lang.Number.class);
            this.queryLines = this.jsiiGet("queryLines", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.queryString = this.jsiiGet("queryString", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.title = this.jsiiGet("title", java.lang.String.class);
            this.view = this.jsiiGet("view", software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType.class);
            this.width = this.jsiiGet("width", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> logGroupNames, final java.lang.Number height, final java.util.List<java.lang.String> queryLines, final java.lang.String queryString, final java.lang.String region, final java.lang.String title, final software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType view, final java.lang.Number width) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroupNames = java.util.Objects.requireNonNull(logGroupNames, "logGroupNames is required");
            this.height = height;
            this.queryLines = queryLines;
            this.queryString = queryString;
            this.region = region;
            this.title = title;
            this.view = view;
            this.width = width;
        }

        @Override
        public java.util.List<java.lang.String> getLogGroupNames() {
            return this.logGroupNames;
        }

        @Override
        public java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public java.util.List<java.lang.String> getQueryLines() {
            return this.queryLines;
        }

        @Override
        public java.lang.String getQueryString() {
            return this.queryString;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.LogQueryVisualizationType getView() {
            return this.view;
        }

        @Override
        public java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroupNames", om.valueToTree(this.getLogGroupNames()));
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getQueryLines() != null) {
                data.set("queryLines", om.valueToTree(this.getQueryLines()));
            }
            if (this.getQueryString() != null) {
                data.set("queryString", om.valueToTree(this.getQueryString()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getView() != null) {
                data.set("view", om.valueToTree(this.getView()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.LogQueryWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogQueryWidgetProps.Jsii$Proxy that = (LogQueryWidgetProps.Jsii$Proxy) o;

            if (!logGroupNames.equals(that.logGroupNames)) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.queryLines != null ? !this.queryLines.equals(that.queryLines) : that.queryLines != null) return false;
            if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            if (this.view != null ? !this.view.equals(that.view) : that.view != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public int hashCode() {
            int result = this.logGroupNames.hashCode();
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.queryLines != null ? this.queryLines.hashCode() : 0);
            result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
