package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for creating a Composite Alarm.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.850Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CompositeAlarmProps")
@software.amazon.jsii.Jsii.Proxy(CompositeAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CompositeAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarmRule getAlarmRule();

    /**
     * Whether the actions for this alarm are enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getActionsEnabled() {
        return null;
    }

    /**
     * Description for the alarm.
     * <p>
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * Name of the alarm.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCompositeAlarmName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CompositeAlarmProps> {
        private software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule;
        private java.lang.Boolean actionsEnabled;
        private java.lang.String alarmDescription;
        private java.lang.String compositeAlarmName;

        /**
         * Sets the value of {@link CompositeAlarmProps#getAlarmRule}
         * @param alarmRule Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getActionsEnabled}
         * @param actionsEnabled Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getAlarmDescription}
         * @param alarmDescription Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getCompositeAlarmName}
         * @param compositeAlarmName Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeAlarmName(java.lang.String compositeAlarmName) {
            this.compositeAlarmName = compositeAlarmName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CompositeAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CompositeAlarmProps build() {
            return new Jsii$Proxy(alarmRule, actionsEnabled, alarmDescription, compositeAlarmName);
        }
    }

    /**
     * An implementation for {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeAlarmProps {
        private final software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule;
        private final java.lang.Boolean actionsEnabled;
        private final java.lang.String alarmDescription;
        private final java.lang.String compositeAlarmName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmRule = this.jsiiGet("alarmRule", software.amazon.awscdk.services.cloudwatch.IAlarmRule.class);
            this.actionsEnabled = this.jsiiGet("actionsEnabled", java.lang.Boolean.class);
            this.alarmDescription = this.jsiiGet("alarmDescription", java.lang.String.class);
            this.compositeAlarmName = this.jsiiGet("compositeAlarmName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule, final java.lang.Boolean actionsEnabled, final java.lang.String alarmDescription, final java.lang.String compositeAlarmName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmRule = java.util.Objects.requireNonNull(alarmRule, "alarmRule is required");
            this.actionsEnabled = actionsEnabled;
            this.alarmDescription = alarmDescription;
            this.compositeAlarmName = compositeAlarmName;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.IAlarmRule getAlarmRule() {
            return this.alarmRule;
        }

        @Override
        public java.lang.Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public java.lang.String getCompositeAlarmName() {
            return this.compositeAlarmName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmRule", om.valueToTree(this.getAlarmRule()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getCompositeAlarmName() != null) {
                data.set("compositeAlarmName", om.valueToTree(this.getCompositeAlarmName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CompositeAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CompositeAlarmProps.Jsii$Proxy that = (CompositeAlarmProps.Jsii$Proxy) o;

            if (!alarmRule.equals(that.alarmRule)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            return this.compositeAlarmName != null ? this.compositeAlarmName.equals(that.compositeAlarmName) : that.compositeAlarmName == null;
        }

        @Override
        public int hashCode() {
            int result = this.alarmRule.hashCode();
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.compositeAlarmName != null ? this.compositeAlarmName.hashCode() : 0);
            return result;
        }
    }
}
