package software.amazon.awscdk.services.cloudwatch;

/**
 * Options shared by most methods accepting metric options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.849Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CommonMetricOptions")
@software.amazon.jsii.Jsii.Proxy(CommonMetricOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonMetricOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Account which this metric comes from.
     * <p>
     * Default: - Deployment account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
     * <p>
     * Default: - Automatic color
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return null;
    }

    /**
     * Dimensions of the metric.
     * <p>
     * Default: - No dimensions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
        return null;
    }

    /**
     * Label for this metric when added to a Graph in a Dashboard.
     * <p>
     * Default: - No label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * The period over which the specified statistic is applied.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getPeriod() {
        return null;
    }

    /**
     * Region which this metric comes from.
     * <p>
     * Default: - Deployment region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * What function to use for aggregating.
     * <p>
     * Can be one of the following:
     * <p>
     * <ul>
     * <li>"Minimum" | "min"</li>
     * <li>"Maximum" | "max"</li>
     * <li>"Average" | "avg"</li>
     * <li>"Sum" | "sum"</li>
     * <li>"SampleCount | "n"</li>
     * <li>"pNN.NN"</li>
     * </ul>
     * <p>
     * Default: Average
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * Unit used to filter the metric stream.
     * <p>
     * Only refer to datums emitted to the metric stream with the given unit and
     * ignore all others. Only useful when datums are being emitted to the same
     * metric stream under different units.
     * <p>
     * The default is to use all matric datums in the stream, regardless of unit,
     * which is recommended in nearly all cases.
     * <p>
     * CloudWatch does not honor this property for graphs.
     * <p>
     * Default: - All metric datums in the given metric stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonMetricOptions> {
        private java.lang.String account;
        private java.lang.String color;
        private java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private java.lang.String label;
        private software.amazon.awscdk.core.Duration period;
        private java.lang.String region;
        private java.lang.String statistic;
        private software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Sets the value of {@link CommonMetricOptions#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getDimensions}
         * @param dimensions Dimensions of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(java.util.Map<java.lang.String, java.lang.Object> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getPeriod}
         * @param period The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.core.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getUnit}
         * @param unit Unit used to filter the metric stream.
         *             Only refer to datums emitted to the metric stream with the given unit and
         *             ignore all others. Only useful when datums are being emitted to the same
         *             metric stream under different units.
         *             <p>
         *             The default is to use all matric datums in the stream, regardless of unit,
         *             which is recommended in nearly all cases.
         *             <p>
         *             CloudWatch does not honor this property for graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonMetricOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonMetricOptions build() {
            return new Jsii$Proxy(account, color, dimensions, label, period, region, statistic, unit);
        }
    }

    /**
     * An implementation for {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonMetricOptions {
        private final java.lang.String account;
        private final java.lang.String color;
        private final java.util.Map<java.lang.String, java.lang.Object> dimensions;
        private final java.lang.String label;
        private final software.amazon.awscdk.core.Duration period;
        private final java.lang.String region;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = this.jsiiGet("account", java.lang.String.class);
            this.color = this.jsiiGet("color", java.lang.String.class);
            this.dimensions = this.jsiiGet("dimensions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.label = this.jsiiGet("label", java.lang.String.class);
            this.period = this.jsiiGet("period", software.amazon.awscdk.core.Duration.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.statistic = this.jsiiGet("statistic", java.lang.String.class);
            this.unit = this.jsiiGet("unit", software.amazon.awscdk.services.cloudwatch.Unit.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String account, final java.lang.String color, final java.util.Map<java.lang.String, java.lang.Object> dimensions, final java.lang.String label, final software.amazon.awscdk.core.Duration period, final java.lang.String region, final java.lang.String statistic, final software.amazon.awscdk.services.cloudwatch.Unit unit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = account;
            this.color = color;
            this.dimensions = dimensions;
            this.label = label;
            this.period = period;
            this.region = region;
            this.statistic = statistic;
            this.unit = unit;
        }

        @Override
        public java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public java.lang.String getColor() {
            return this.color;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
            return this.dimensions;
        }

        @Override
        public java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public software.amazon.awscdk.core.Duration getPeriod() {
            return this.period;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.unit;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CommonMetricOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonMetricOptions.Jsii$Proxy that = (CommonMetricOptions.Jsii$Proxy) o;

            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public int hashCode() {
            int result = this.account != null ? this.account.hashCode() : 0;
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
