package software.amazon.awscdk.services.cloudwatch;

/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CfnAlarm")
public class CfnAlarm extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAlarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAlarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.CfnAlarm.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CloudWatch::Alarm`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAlarm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CfnAlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator() {
        return this.jsiiGet("comparisonOperator", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComparisonOperator(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("comparisonOperator", java.util.Objects.requireNonNull(value, "comparisonOperator is required"));
    }

    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods() {
        return this.jsiiGet("evaluationPeriods", java.lang.Number.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvaluationPeriods(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("evaluationPeriods", java.util.Objects.requireNonNull(value, "evaluationPeriods is required"));
    }

    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActionsEnabled() {
        return this.jsiiGet("actionsEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("actionsEnabled", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("actionsEnabled", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarmActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("alarmActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("alarmActions", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return this.jsiiGet("alarmDescription", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("alarmDescription", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return this.jsiiGet("alarmName", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("alarmName", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return this.jsiiGet("datapointsToAlarm", java.lang.Number.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatapointsToAlarm(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("datapointsToAlarm", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return this.jsiiGet("dimensions", java.lang.Object.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("dimensions", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDimensions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("dimensions", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEvaluateLowSampleCountPercentile() {
        return this.jsiiGet("evaluateLowSampleCountPercentile", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvaluateLowSampleCountPercentile(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("evaluateLowSampleCountPercentile", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExtendedStatistic() {
        return this.jsiiGet("extendedStatistic", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendedStatistic(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("extendedStatistic", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsufficientDataActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("insufficientDataActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsufficientDataActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("insufficientDataActions", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
        return this.jsiiGet("metricName", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("metricName", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
        return this.jsiiGet("metrics", java.lang.Object.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetrics(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("metrics", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetrics(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("metrics", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return this.jsiiGet("namespace", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespace(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("namespace", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOkActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("okActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOkActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("okActions", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Period`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPeriod() {
        return this.jsiiGet("period", java.lang.Number.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Period`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("period", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return this.jsiiGet("statistic", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatistic(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("statistic", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
        return this.jsiiGet("threshold", java.lang.Number.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThreshold(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("threshold", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThresholdMetricId() {
        return this.jsiiGet("thresholdMetricId", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThresholdMetricId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("thresholdMetricId", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTreatMissingData() {
        return this.jsiiGet("treatMissingData", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatMissingData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("treatMissingData", value);
    }

    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
        return this.jsiiGet("unit", java.lang.String.class);
    }

    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUnit(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("unit", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CfnAlarm.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlarm.DimensionProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnAlarm.DimensionProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of {@link DimensionProperty#getName}
             * @param name `CfnAlarm.DimensionProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getValue}
             * @param value `CfnAlarm.DimensionProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(name, value);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CfnAlarm.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CfnAlarm.MetricDataQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDataQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDataQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlarm.MetricDataQueryProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnAlarm.MetricDataQueryProperty.Expression`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-expression
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * `CfnAlarm.MetricDataQueryProperty.Label`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-label
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * `CfnAlarm.MetricDataQueryProperty.MetricStat`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-metricstat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricStat() {
            return null;
        }

        /**
         * `CfnAlarm.MetricDataQueryProperty.Period`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeriod() {
            return null;
        }

        /**
         * `CfnAlarm.MetricDataQueryProperty.ReturnData`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-returndata
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReturnData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDataQueryProperty> {
            private java.lang.String id;
            private java.lang.String expression;
            private java.lang.String label;
            private java.lang.Object metricStat;
            private java.lang.Number period;
            private java.lang.Object returnData;

            /**
             * Sets the value of {@link MetricDataQueryProperty#getId}
             * @param id `CfnAlarm.MetricDataQueryProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getExpression}
             * @param expression `CfnAlarm.MetricDataQueryProperty.Expression`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getLabel}
             * @param label `CfnAlarm.MetricDataQueryProperty.Label`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat `CfnAlarm.MetricDataQueryProperty.MetricStat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.core.IResolvable metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getMetricStat}
             * @param metricStat `CfnAlarm.MetricDataQueryProperty.MetricStat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricStat(software.amazon.awscdk.services.cloudwatch.CfnAlarm.MetricStatProperty metricStat) {
                this.metricStat = metricStat;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getPeriod}
             * @param period `CfnAlarm.MetricDataQueryProperty.Period`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData `CfnAlarm.MetricDataQueryProperty.ReturnData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(java.lang.Boolean returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Sets the value of {@link MetricDataQueryProperty#getReturnData}
             * @param returnData `CfnAlarm.MetricDataQueryProperty.ReturnData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder returnData(software.amazon.awscdk.core.IResolvable returnData) {
                this.returnData = returnData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDataQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDataQueryProperty build() {
                return new Jsii$Proxy(id, expression, label, metricStat, period, returnData);
            }
        }

        /**
         * An implementation for {@link MetricDataQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDataQueryProperty {
            private final java.lang.String id;
            private final java.lang.String expression;
            private final java.lang.String label;
            private final java.lang.Object metricStat;
            private final java.lang.Number period;
            private final java.lang.Object returnData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.expression = this.jsiiGet("expression", java.lang.String.class);
                this.label = this.jsiiGet("label", java.lang.String.class);
                this.metricStat = this.jsiiGet("metricStat", java.lang.Object.class);
                this.period = this.jsiiGet("period", java.lang.Number.class);
                this.returnData = this.jsiiGet("returnData", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String id, final java.lang.String expression, final java.lang.String label, final java.lang.Object metricStat, final java.lang.Number period, final java.lang.Object returnData) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.expression = expression;
                this.label = label;
                this.metricStat = metricStat;
                this.period = period;
                this.returnData = returnData;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public java.lang.Object getMetricStat() {
                return this.metricStat;
            }

            @Override
            public java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public java.lang.Object getReturnData() {
                return this.returnData;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getMetricStat() != null) {
                    data.set("metricStat", om.valueToTree(this.getMetricStat()));
                }
                if (this.getPeriod() != null) {
                    data.set("period", om.valueToTree(this.getPeriod()));
                }
                if (this.getReturnData() != null) {
                    data.set("returnData", om.valueToTree(this.getReturnData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CfnAlarm.MetricDataQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDataQueryProperty.Jsii$Proxy that = (MetricDataQueryProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.metricStat != null ? !this.metricStat.equals(that.metricStat) : that.metricStat != null) return false;
                if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
                return this.returnData != null ? this.returnData.equals(that.returnData) : that.returnData == null;
            }

            @Override
            public int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
                result = 31 * result + (this.metricStat != null ? this.metricStat.hashCode() : 0);
                result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
                result = 31 * result + (this.returnData != null ? this.returnData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CfnAlarm.MetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlarm.MetricProperty.Dimensions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-dimensions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * `CfnAlarm.MetricProperty.MetricName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-metricname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
            return null;
        }

        /**
         * `CfnAlarm.MetricProperty.Namespace`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricProperty> {
            private java.lang.Object dimensions;
            private java.lang.String metricName;
            private java.lang.String namespace;

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions `CfnAlarm.MetricProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.core.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getDimensions}
             * @param dimensions `CfnAlarm.MetricProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getMetricName}
             * @param metricName `CfnAlarm.MetricProperty.MetricName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getNamespace}
             * @param namespace `CfnAlarm.MetricProperty.Namespace`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricProperty build() {
                return new Jsii$Proxy(dimensions, metricName, namespace);
            }
        }

        /**
         * An implementation for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = this.jsiiGet("dimensions", java.lang.Object.class);
                this.metricName = this.jsiiGet("metricName", java.lang.String.class);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object dimensions, final java.lang.String metricName, final java.lang.String namespace) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = dimensions;
                this.metricName = metricName;
                this.namespace = namespace;
            }

            @Override
            public java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getMetricName() != null) {
                    data.set("metricName", om.valueToTree(this.getMetricName()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CfnAlarm.MetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricProperty.Jsii$Proxy that = (MetricProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.CfnAlarm.MetricStatProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricStatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricStatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlarm.MetricStatProperty.Metric`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-metric
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetric();

        /**
         * `CfnAlarm.MetricStatProperty.Period`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-period
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * `CfnAlarm.MetricStatProperty.Stat`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-stat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStat();

        /**
         * `CfnAlarm.MetricStatProperty.Unit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-unit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricStatProperty> {
            private java.lang.Object metric;
            private java.lang.Number period;
            private java.lang.String stat;
            private java.lang.String unit;

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric `CfnAlarm.MetricStatProperty.Metric`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.core.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getMetric}
             * @param metric `CfnAlarm.MetricStatProperty.Metric`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.cloudwatch.CfnAlarm.MetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getPeriod}
             * @param period `CfnAlarm.MetricStatProperty.Period`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getStat}
             * @param stat `CfnAlarm.MetricStatProperty.Stat`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stat(java.lang.String stat) {
                this.stat = stat;
                return this;
            }

            /**
             * Sets the value of {@link MetricStatProperty#getUnit}
             * @param unit `CfnAlarm.MetricStatProperty.Unit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricStatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricStatProperty build() {
                return new Jsii$Proxy(metric, period, stat, unit);
            }
        }

        /**
         * An implementation for {@link MetricStatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricStatProperty {
            private final java.lang.Object metric;
            private final java.lang.Number period;
            private final java.lang.String stat;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metric = this.jsiiGet("metric", java.lang.Object.class);
                this.period = this.jsiiGet("period", java.lang.Number.class);
                this.stat = this.jsiiGet("stat", java.lang.String.class);
                this.unit = this.jsiiGet("unit", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object metric, final java.lang.Number period, final java.lang.String stat, final java.lang.String unit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metric = java.util.Objects.requireNonNull(metric, "metric is required");
                this.period = java.util.Objects.requireNonNull(period, "period is required");
                this.stat = java.util.Objects.requireNonNull(stat, "stat is required");
                this.unit = unit;
            }

            @Override
            public java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public java.lang.String getStat() {
                return this.stat;
            }

            @Override
            public java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metric", om.valueToTree(this.getMetric()));
                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("stat", om.valueToTree(this.getStat()));
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.CfnAlarm.MetricStatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricStatProperty.Jsii$Proxy that = (MetricStatProperty.Jsii$Proxy) o;

                if (!metric.equals(that.metric)) return false;
                if (!period.equals(that.period)) return false;
                if (!stat.equals(that.stat)) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public int hashCode() {
                int result = this.metric.hashCode();
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.stat.hashCode());
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CfnAlarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CfnAlarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.CfnAlarmProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.CfnAlarmProps.Builder();
        }

        /**
         * `AWS::CloudWatch::Alarm.ComparisonOperator`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
         * @param comparisonOperator `AWS::CloudWatch::Alarm.ComparisonOperator`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(final java.lang.String comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
         * @param evaluationPeriods `AWS::CloudWatch::Alarm.EvaluationPeriods`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.ActionsEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
         * @param actionsEnabled `AWS::CloudWatch::Alarm.ActionsEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final java.lang.Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }
        /**
         * `AWS::CloudWatch::Alarm.ActionsEnabled`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
         * @param actionsEnabled `AWS::CloudWatch::Alarm.ActionsEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final software.amazon.awscdk.core.IResolvable actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.AlarmActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
         * @param alarmActions `AWS::CloudWatch::Alarm.AlarmActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmActions(final java.util.List<java.lang.String> alarmActions) {
            this.props.alarmActions(alarmActions);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.AlarmDescription`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
         * @param alarmDescription `AWS::CloudWatch::Alarm.AlarmDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(final java.lang.String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.AlarmName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
         * @param alarmName `AWS::CloudWatch::Alarm.AlarmName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(final java.lang.String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
         * @param datapointsToAlarm `AWS::CloudWatch::Alarm.DatapointsToAlarm`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(final java.lang.Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Dimensions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
         * @param dimensions `AWS::CloudWatch::Alarm.Dimensions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final software.amazon.awscdk.core.IResolvable dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }
        /**
         * `AWS::CloudWatch::Alarm.Dimensions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
         * @param dimensions `AWS::CloudWatch::Alarm.Dimensions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final java.util.List<java.lang.Object> dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
         * @param evaluateLowSampleCountPercentile `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluateLowSampleCountPercentile(final java.lang.String evaluateLowSampleCountPercentile) {
            this.props.evaluateLowSampleCountPercentile(evaluateLowSampleCountPercentile);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
         * @param extendedStatistic `AWS::CloudWatch::Alarm.ExtendedStatistic`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedStatistic(final java.lang.String extendedStatistic) {
            this.props.extendedStatistic(extendedStatistic);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
         * @param insufficientDataActions `AWS::CloudWatch::Alarm.InsufficientDataActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataActions(final java.util.List<java.lang.String> insufficientDataActions) {
            this.props.insufficientDataActions(insufficientDataActions);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.MetricName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
         * @param metricName `AWS::CloudWatch::Alarm.MetricName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Metrics`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
         * @param metrics `AWS::CloudWatch::Alarm.Metrics`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final software.amazon.awscdk.core.IResolvable metrics) {
            this.props.metrics(metrics);
            return this;
        }
        /**
         * `AWS::CloudWatch::Alarm.Metrics`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
         * @param metrics `AWS::CloudWatch::Alarm.Metrics`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<java.lang.Object> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Namespace`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
         * @param namespace `AWS::CloudWatch::Alarm.Namespace`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.OKActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
         * @param okActions `AWS::CloudWatch::Alarm.OKActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder okActions(final java.util.List<java.lang.String> okActions) {
            this.props.okActions(okActions);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Period`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
         * @param period `AWS::CloudWatch::Alarm.Period`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(final java.lang.Number period) {
            this.props.period(period);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Statistic`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
         * @param statistic `AWS::CloudWatch::Alarm.Statistic`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Threshold`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
         * @param threshold `AWS::CloudWatch::Alarm.Threshold`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(final java.lang.Number threshold) {
            this.props.threshold(threshold);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
         * @param thresholdMetricId `AWS::CloudWatch::Alarm.ThresholdMetricId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thresholdMetricId(final java.lang.String thresholdMetricId) {
            this.props.thresholdMetricId(thresholdMetricId);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.TreatMissingData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
         * @param treatMissingData `AWS::CloudWatch::Alarm.TreatMissingData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(final java.lang.String treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        /**
         * `AWS::CloudWatch::Alarm.Unit`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
         * @param unit `AWS::CloudWatch::Alarm.Unit`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(final java.lang.String unit) {
            this.props.unit(unit);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CfnAlarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CfnAlarm build() {
            return new software.amazon.awscdk.services.cloudwatch.CfnAlarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
