package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for an AlarmWidget.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.842Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.AlarmWidgetProps")
@software.amazon.jsii.Jsii.Proxy(AlarmWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlarmWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * The alarm to show.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm getAlarm();

    /**
     * Left Y axis.
     * <p>
     * Default: - No minimum or maximum values for the left Y-axis
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlarmWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlarmWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlarmWidgetProps> {
        private software.amazon.awscdk.services.cloudwatch.IAlarm alarm;
        private software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        private java.lang.Number height;
        private java.lang.String region;
        private java.lang.String title;
        private java.lang.Number width;

        /**
         * Sets the value of {@link AlarmWidgetProps#getAlarm}
         * @param alarm The alarm to show. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarm(software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
            this.alarm = alarm;
            return this;
        }

        /**
         * Sets the value of {@link AlarmWidgetProps#getLeftYAxis}
         * @param leftYAxis Left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder leftYAxis(software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis) {
            this.leftYAxis = leftYAxis;
            return this;
        }

        /**
         * Sets the value of {@link AlarmWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link AlarmWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link AlarmWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link AlarmWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlarmWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlarmWidgetProps build() {
            return new Jsii$Proxy(alarm, leftYAxis, height, region, title, width);
        }
    }

    /**
     * An implementation for {@link AlarmWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmWidgetProps {
        private final software.amazon.awscdk.services.cloudwatch.IAlarm alarm;
        private final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarm = this.jsiiGet("alarm", software.amazon.awscdk.services.cloudwatch.IAlarm.class);
            this.leftYAxis = this.jsiiGet("leftYAxis", software.amazon.awscdk.services.cloudwatch.YAxisProps.class);
            this.height = this.jsiiGet("height", java.lang.Number.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.title = this.jsiiGet("title", java.lang.String.class);
            this.width = this.jsiiGet("width", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudwatch.IAlarm alarm, final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis, final java.lang.Number height, final java.lang.String region, final java.lang.String title, final java.lang.Number width) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarm = java.util.Objects.requireNonNull(alarm, "alarm is required");
            this.leftYAxis = leftYAxis;
            this.height = height;
            this.region = region;
            this.title = title;
            this.width = width;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.IAlarm getAlarm() {
            return this.alarm;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
            return this.leftYAxis;
        }

        @Override
        public java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarm", om.valueToTree(this.getAlarm()));
            if (this.getLeftYAxis() != null) {
                data.set("leftYAxis", om.valueToTree(this.getLeftYAxis()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudwatch.AlarmWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlarmWidgetProps.Jsii$Proxy that = (AlarmWidgetProps.Jsii$Proxy) o;

            if (!alarm.equals(that.alarm)) return false;
            if (this.leftYAxis != null ? !this.leftYAxis.equals(that.leftYAxis) : that.leftYAxis != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public int hashCode() {
            int result = this.alarm.hashCode();
            result = 31 * result + (this.leftYAxis != null ? this.leftYAxis.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
