package software.amazon.awscdk.services.cloudwatch;

/**
 * Specify how missing data points are treated during alarm evaluation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .timeout(Duration.minutes(5))
 *         .build();
 * if (fn.getTimeout()) {
 *     Alarm.Builder.create(this, "MyAlarm")
 *             .metric(fn.metricDuration().with(MetricOptions.builder()
 *                     .statistic("Maximum")
 *                     .build()))
 *             .evaluationPeriods(1)
 *             .datapointsToAlarm(1)
 *             .threshold(fn.timeout.toMilliseconds())
 *             .treatMissingData(TreatMissingData.IGNORE)
 *             .alarmName("My Lambda Timeout")
 *             .build();
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:36.510Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.TreatMissingData")
public enum TreatMissingData {
    /**
     * Missing data points are treated as breaching the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BREACHING,
    /**
     * Missing data points are treated as being within the threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOT_BREACHING,
    /**
     * The current alarm state is maintained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IGNORE,
    /**
     * The alarm does not consider missing data points when evaluating whether to change state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MISSING,
}
