/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.cloudfront.$Module;
import software.amazon.awscdk.services.cloudfront.CfnDistribution;
import software.amazon.awscdk.services.cloudfront.CfnDistributionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution")
public class CfnDistribution
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDistribution.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnDistribution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDistribution(@NotNull Construct scope, @NotNull String id, @NotNull CfnDistributionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDomainName() {
        return (String)this.jsiiGet("attrDomainName", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Object getDistributionConfig() {
        return this.jsiiGet("distributionConfig", Object.class);
    }

    public void setDistributionConfig(@NotNull IResolvable value) {
        this.jsiiSet("distributionConfig", Objects.requireNonNull(value, "distributionConfig is required"));
    }

    public void setDistributionConfig(@NotNull DistributionConfigProperty value) {
        this.jsiiSet("distributionConfig", Objects.requireNonNull(value, "distributionConfig is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDistribution> {
        private final Construct scope;
        private final String id;
        private final CfnDistributionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDistributionProps.Builder();
        }

        public Builder distributionConfig(IResolvable distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        public Builder distributionConfig(DistributionConfigProperty distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDistribution build() {
            return new CfnDistribution(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.ViewerCertificateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ViewerCertificateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAcmCertificateArn() {
            return null;
        }

        @Nullable
        default public Object getCloudFrontDefaultCertificate() {
            return null;
        }

        @Nullable
        default public String getIamCertificateId() {
            return null;
        }

        @Nullable
        default public String getMinimumProtocolVersion() {
            return null;
        }

        @Nullable
        default public String getSslSupportMethod() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ViewerCertificateProperty> {
            private String acmCertificateArn;
            private Object cloudFrontDefaultCertificate;
            private String iamCertificateId;
            private String minimumProtocolVersion;
            private String sslSupportMethod;

            public Builder acmCertificateArn(String acmCertificateArn) {
                this.acmCertificateArn = acmCertificateArn;
                return this;
            }

            public Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            public Builder cloudFrontDefaultCertificate(IResolvable cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            public Builder iamCertificateId(String iamCertificateId) {
                this.iamCertificateId = iamCertificateId;
                return this;
            }

            public Builder minimumProtocolVersion(String minimumProtocolVersion) {
                this.minimumProtocolVersion = minimumProtocolVersion;
                return this;
            }

            public Builder sslSupportMethod(String sslSupportMethod) {
                this.sslSupportMethod = sslSupportMethod;
                return this;
            }

            public ViewerCertificateProperty build() {
                return new Jsii.Proxy(this.acmCertificateArn, this.cloudFrontDefaultCertificate, this.iamCertificateId, this.minimumProtocolVersion, this.sslSupportMethod, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.StatusCodesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatusCodesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getItems();

        @NotNull
        public Number getQuantity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatusCodesProperty> {
            private Object items;
            private Number quantity;

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<Number> items) {
                this.items = items;
                return this;
            }

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public StatusCodesProperty build() {
                return new Jsii.Proxy(this.items, this.quantity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.S3OriginConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OriginConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOriginAccessIdentity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OriginConfigProperty> {
            private String originAccessIdentity;

            public Builder originAccessIdentity(String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            public S3OriginConfigProperty build() {
                return new Jsii.Proxy(this.originAccessIdentity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.RestrictionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RestrictionsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getGeoRestriction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RestrictionsProperty> {
            private Object geoRestriction;

            public Builder geoRestriction(IResolvable geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            public Builder geoRestriction(GeoRestrictionProperty geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            public RestrictionsProperty build() {
                return new Jsii.Proxy(this.geoRestriction, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginProperty
    extends JsiiSerializable {
        @NotNull
        public String getDomainName();

        @NotNull
        public String getId();

        @Nullable
        default public Number getConnectionAttempts() {
            return null;
        }

        @Nullable
        default public Number getConnectionTimeout() {
            return null;
        }

        @Nullable
        default public Object getCustomOriginConfig() {
            return null;
        }

        @Nullable
        default public Object getOriginCustomHeaders() {
            return null;
        }

        @Nullable
        default public String getOriginPath() {
            return null;
        }

        @Nullable
        default public Object getS3OriginConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginProperty> {
            private String domainName;
            private String id;
            private Number connectionAttempts;
            private Number connectionTimeout;
            private Object customOriginConfig;
            private Object originCustomHeaders;
            private String originPath;
            private Object s3OriginConfig;

            public Builder domainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder connectionAttempts(Number connectionAttempts) {
                this.connectionAttempts = connectionAttempts;
                return this;
            }

            public Builder connectionTimeout(Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            public Builder customOriginConfig(IResolvable customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            public Builder customOriginConfig(CustomOriginConfigProperty customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            public Builder originCustomHeaders(IResolvable originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            public Builder originCustomHeaders(List<Object> originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            public Builder originPath(String originPath) {
                this.originPath = originPath;
                return this;
            }

            public Builder s3OriginConfig(IResolvable s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            public Builder s3OriginConfig(S3OriginConfigProperty s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            public OriginProperty build() {
                return new Jsii.Proxy(this.domainName, this.id, this.connectionAttempts, this.connectionTimeout, this.customOriginConfig, this.originCustomHeaders, this.originPath, this.s3OriginConfig, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getQuantity();

        @Nullable
        default public Object getItems() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupsProperty> {
            private Number quantity;
            private Object items;

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<Object> items) {
                this.items = items;
                return this;
            }

            public OriginGroupsProperty build() {
                return new Jsii.Proxy(this.quantity, this.items, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFailoverCriteria();

        @NotNull
        public String getId();

        @NotNull
        public Object getMembers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupProperty> {
            private Object failoverCriteria;
            private String id;
            private Object members;

            public Builder failoverCriteria(IResolvable failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            public Builder failoverCriteria(OriginGroupFailoverCriteriaProperty failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder members(IResolvable members) {
                this.members = members;
                return this;
            }

            public Builder members(OriginGroupMembersProperty members) {
                this.members = members;
                return this;
            }

            public OriginGroupProperty build() {
                return new Jsii.Proxy(this.failoverCriteria, this.id, this.members, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMembersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupMembersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getItems();

        @NotNull
        public Number getQuantity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupMembersProperty> {
            private Object items;
            private Number quantity;

            public Builder items(IResolvable items) {
                this.items = items;
                return this;
            }

            public Builder items(List<Object> items) {
                this.items = items;
                return this;
            }

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public OriginGroupMembersProperty build() {
                return new Jsii.Proxy(this.items, this.quantity, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMemberProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupMemberProperty
    extends JsiiSerializable {
        @NotNull
        public String getOriginId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupMemberProperty> {
            private String originId;

            public Builder originId(String originId) {
                this.originId = originId;
                return this;
            }

            public OriginGroupMemberProperty build() {
                return new Jsii.Proxy(this.originId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginGroupFailoverCriteriaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatusCodes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginGroupFailoverCriteriaProperty> {
            private Object statusCodes;

            public Builder statusCodes(IResolvable statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            public Builder statusCodes(StatusCodesProperty statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            public OriginGroupFailoverCriteriaProperty build() {
                return new Jsii.Proxy(this.statusCodes, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.OriginCustomHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OriginCustomHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getHeaderName();

        @NotNull
        public String getHeaderValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OriginCustomHeaderProperty> {
            private String headerName;
            private String headerValue;

            public Builder headerName(String headerName) {
                this.headerName = headerName;
                return this;
            }

            public Builder headerValue(String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            public OriginCustomHeaderProperty build() {
                return new Jsii.Proxy(this.headerName, this.headerValue, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @Nullable
        default public Object getIncludeCookies() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingProperty> {
            private String bucket;
            private Object includeCookies;
            private String prefix;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder includeCookies(Boolean includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            public Builder includeCookies(IResolvable includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public LoggingProperty build() {
                return new Jsii.Proxy(this.bucket, this.includeCookies, this.prefix, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.LambdaFunctionAssociationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaFunctionAssociationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEventType() {
            return null;
        }

        @Nullable
        default public Object getIncludeBody() {
            return null;
        }

        @Nullable
        default public String getLambdaFunctionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaFunctionAssociationProperty> {
            private String eventType;
            private Object includeBody;
            private String lambdaFunctionArn;

            public Builder eventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder includeBody(Boolean includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            public Builder includeBody(IResolvable includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            public Builder lambdaFunctionArn(String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            public LambdaFunctionAssociationProperty build() {
                return new Jsii.Proxy(this.eventType, this.includeBody, this.lambdaFunctionArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.GeoRestrictionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeoRestrictionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRestrictionType();

        @Nullable
        default public List<String> getLocations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeoRestrictionProperty> {
            private String restrictionType;
            private List<String> locations;

            public Builder restrictionType(String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            public Builder locations(List<String> locations) {
                this.locations = locations;
                return this;
            }

            public GeoRestrictionProperty build() {
                return new Jsii.Proxy(this.restrictionType, this.locations, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.ForwardedValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForwardedValuesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getQueryString();

        @Nullable
        default public Object getCookies() {
            return null;
        }

        @Nullable
        default public List<String> getHeaders() {
            return null;
        }

        @Nullable
        default public List<String> getQueryStringCacheKeys() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForwardedValuesProperty> {
            private Object queryString;
            private Object cookies;
            private List<String> headers;
            private List<String> queryStringCacheKeys;

            public Builder queryString(Boolean queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder queryString(IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder cookies(IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder cookies(CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder headers(List<String> headers) {
                this.headers = headers;
                return this;
            }

            public Builder queryStringCacheKeys(List<String> queryStringCacheKeys) {
                this.queryStringCacheKeys = queryStringCacheKeys;
                return this;
            }

            public ForwardedValuesProperty build() {
                return new Jsii.Proxy(this.queryString, this.cookies, this.headers, this.queryStringCacheKeys, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.DistributionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DistributionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public List<String> getAliases() {
            return null;
        }

        @Nullable
        default public Object getCacheBehaviors() {
            return null;
        }

        @Nullable
        default public String getComment() {
            return null;
        }

        @Nullable
        default public Object getCustomErrorResponses() {
            return null;
        }

        @Nullable
        default public Object getDefaultCacheBehavior() {
            return null;
        }

        @Nullable
        default public String getDefaultRootObject() {
            return null;
        }

        @Nullable
        default public String getHttpVersion() {
            return null;
        }

        @Nullable
        default public Object getIpv6Enabled() {
            return null;
        }

        @Nullable
        default public Object getLogging() {
            return null;
        }

        @Nullable
        default public Object getOriginGroups() {
            return null;
        }

        @Nullable
        default public Object getOrigins() {
            return null;
        }

        @Nullable
        default public String getPriceClass() {
            return null;
        }

        @Nullable
        default public Object getRestrictions() {
            return null;
        }

        @Nullable
        default public Object getViewerCertificate() {
            return null;
        }

        @Nullable
        default public String getWebAclId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DistributionConfigProperty> {
            private Object enabled;
            private List<String> aliases;
            private Object cacheBehaviors;
            private String comment;
            private Object customErrorResponses;
            private Object defaultCacheBehavior;
            private String defaultRootObject;
            private String httpVersion;
            private Object ipv6Enabled;
            private Object logging;
            private Object originGroups;
            private Object origins;
            private String priceClass;
            private Object restrictions;
            private Object viewerCertificate;
            private String webAclId;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder aliases(List<String> aliases) {
                this.aliases = aliases;
                return this;
            }

            public Builder cacheBehaviors(IResolvable cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            public Builder cacheBehaviors(List<Object> cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public Builder customErrorResponses(IResolvable customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            public Builder customErrorResponses(List<Object> customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            public Builder defaultCacheBehavior(IResolvable defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            public Builder defaultCacheBehavior(DefaultCacheBehaviorProperty defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            public Builder defaultRootObject(String defaultRootObject) {
                this.defaultRootObject = defaultRootObject;
                return this;
            }

            public Builder httpVersion(String httpVersion) {
                this.httpVersion = httpVersion;
                return this;
            }

            public Builder ipv6Enabled(Boolean ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            public Builder ipv6Enabled(IResolvable ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            public Builder logging(IResolvable logging) {
                this.logging = logging;
                return this;
            }

            public Builder logging(LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            public Builder originGroups(IResolvable originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            public Builder originGroups(OriginGroupsProperty originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            public Builder origins(IResolvable origins) {
                this.origins = origins;
                return this;
            }

            public Builder origins(List<Object> origins) {
                this.origins = origins;
                return this;
            }

            public Builder priceClass(String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            public Builder restrictions(IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder restrictions(RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            public Builder viewerCertificate(IResolvable viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            public Builder viewerCertificate(ViewerCertificateProperty viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            public Builder webAclId(String webAclId) {
                this.webAclId = webAclId;
                return this;
            }

            public DistributionConfigProperty build() {
                return new Jsii.Proxy(this.enabled, this.aliases, this.cacheBehaviors, this.comment, this.customErrorResponses, this.defaultCacheBehavior, this.defaultRootObject, this.httpVersion, this.ipv6Enabled, this.logging, this.originGroups, this.origins, this.priceClass, this.restrictions, this.viewerCertificate, this.webAclId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.DefaultCacheBehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefaultCacheBehaviorProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetOriginId();

        @NotNull
        public String getViewerProtocolPolicy();

        @Nullable
        default public List<String> getAllowedMethods() {
            return null;
        }

        @Nullable
        default public List<String> getCachedMethods() {
            return null;
        }

        @Nullable
        default public String getCachePolicyId() {
            return null;
        }

        @Nullable
        default public Object getCompress() {
            return null;
        }

        @Nullable
        default public Number getDefaultTtl() {
            return null;
        }

        @Nullable
        default public String getFieldLevelEncryptionId() {
            return null;
        }

        @Nullable
        default public Object getForwardedValues() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Number getMaxTtl() {
            return null;
        }

        @Nullable
        default public Number getMinTtl() {
            return null;
        }

        @Nullable
        default public String getOriginRequestPolicyId() {
            return null;
        }

        @Nullable
        default public Object getSmoothStreaming() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedSigners() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefaultCacheBehaviorProperty> {
            private String targetOriginId;
            private String viewerProtocolPolicy;
            private List<String> allowedMethods;
            private List<String> cachedMethods;
            private String cachePolicyId;
            private Object compress;
            private Number defaultTtl;
            private String fieldLevelEncryptionId;
            private Object forwardedValues;
            private Object lambdaFunctionAssociations;
            private Number maxTtl;
            private Number minTtl;
            private String originRequestPolicyId;
            private Object smoothStreaming;
            private List<String> trustedSigners;

            public Builder targetOriginId(String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            public Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder cachedMethods(List<String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            public Builder cachePolicyId(String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            public Builder compress(Boolean compress) {
                this.compress = compress;
                return this;
            }

            public Builder compress(IResolvable compress) {
                this.compress = compress;
                return this;
            }

            public Builder defaultTtl(Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            public Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            public Builder forwardedValues(IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder forwardedValues(ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder lambdaFunctionAssociations(IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(List<Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder maxTtl(Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            public Builder minTtl(Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            public Builder originRequestPolicyId(String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            public Builder smoothStreaming(Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder smoothStreaming(IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder trustedSigners(List<String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public DefaultCacheBehaviorProperty build() {
                return new Jsii.Proxy(this.targetOriginId, this.viewerProtocolPolicy, this.allowedMethods, this.cachedMethods, this.cachePolicyId, this.compress, this.defaultTtl, this.fieldLevelEncryptionId, this.forwardedValues, this.lambdaFunctionAssociations, this.maxTtl, this.minTtl, this.originRequestPolicyId, this.smoothStreaming, this.trustedSigners, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.CustomOriginConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomOriginConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getOriginProtocolPolicy();

        @Nullable
        default public Number getHttpPort() {
            return null;
        }

        @Nullable
        default public Number getHttpsPort() {
            return null;
        }

        @Nullable
        default public Number getOriginKeepaliveTimeout() {
            return null;
        }

        @Nullable
        default public Number getOriginReadTimeout() {
            return null;
        }

        @Nullable
        default public List<String> getOriginSslProtocols() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomOriginConfigProperty> {
            private String originProtocolPolicy;
            private Number httpPort;
            private Number httpsPort;
            private Number originKeepaliveTimeout;
            private Number originReadTimeout;
            private List<String> originSslProtocols;

            public Builder originProtocolPolicy(String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            public Builder httpPort(Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            public Builder httpsPort(Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            public Builder originKeepaliveTimeout(Number originKeepaliveTimeout) {
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                return this;
            }

            public Builder originReadTimeout(Number originReadTimeout) {
                this.originReadTimeout = originReadTimeout;
                return this;
            }

            public Builder originSslProtocols(List<String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            public CustomOriginConfigProperty build() {
                return new Jsii.Proxy(this.originProtocolPolicy, this.httpPort, this.httpsPort, this.originKeepaliveTimeout, this.originReadTimeout, this.originSslProtocols, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.CustomErrorResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomErrorResponseProperty
    extends JsiiSerializable {
        @NotNull
        public Number getErrorCode();

        @Nullable
        default public Number getErrorCachingMinTtl() {
            return null;
        }

        @Nullable
        default public Number getResponseCode() {
            return null;
        }

        @Nullable
        default public String getResponsePagePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomErrorResponseProperty> {
            private Number errorCode;
            private Number errorCachingMinTtl;
            private Number responseCode;
            private String responsePagePath;

            public Builder errorCode(Number errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            public Builder errorCachingMinTtl(Number errorCachingMinTtl) {
                this.errorCachingMinTtl = errorCachingMinTtl;
                return this;
            }

            public Builder responseCode(Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            public Builder responsePagePath(String responsePagePath) {
                this.responsePagePath = responsePagePath;
                return this;
            }

            public CustomErrorResponseProperty build() {
                return new Jsii.Proxy(this.errorCode, this.errorCachingMinTtl, this.responseCode, this.responsePagePath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.CookiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CookiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getForward();

        @Nullable
        default public List<String> getWhitelistedNames() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CookiesProperty> {
            private String forward;
            private List<String> whitelistedNames;

            public Builder forward(String forward) {
                this.forward = forward;
                return this;
            }

            public Builder whitelistedNames(List<String> whitelistedNames) {
                this.whitelistedNames = whitelistedNames;
                return this;
            }

            public CookiesProperty build() {
                return new Jsii.Proxy(this.forward, this.whitelistedNames, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudfront.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CacheBehaviorProperty
    extends JsiiSerializable {
        @NotNull
        public String getPathPattern();

        @NotNull
        public String getTargetOriginId();

        @NotNull
        public String getViewerProtocolPolicy();

        @Nullable
        default public List<String> getAllowedMethods() {
            return null;
        }

        @Nullable
        default public List<String> getCachedMethods() {
            return null;
        }

        @Nullable
        default public String getCachePolicyId() {
            return null;
        }

        @Nullable
        default public Object getCompress() {
            return null;
        }

        @Nullable
        default public Number getDefaultTtl() {
            return null;
        }

        @Nullable
        default public String getFieldLevelEncryptionId() {
            return null;
        }

        @Nullable
        default public Object getForwardedValues() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionAssociations() {
            return null;
        }

        @Nullable
        default public Number getMaxTtl() {
            return null;
        }

        @Nullable
        default public Number getMinTtl() {
            return null;
        }

        @Nullable
        default public String getOriginRequestPolicyId() {
            return null;
        }

        @Nullable
        default public Object getSmoothStreaming() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedSigners() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            private String pathPattern;
            private String targetOriginId;
            private String viewerProtocolPolicy;
            private List<String> allowedMethods;
            private List<String> cachedMethods;
            private String cachePolicyId;
            private Object compress;
            private Number defaultTtl;
            private String fieldLevelEncryptionId;
            private Object forwardedValues;
            private Object lambdaFunctionAssociations;
            private Number maxTtl;
            private Number minTtl;
            private String originRequestPolicyId;
            private Object smoothStreaming;
            private List<String> trustedSigners;

            public Builder pathPattern(String pathPattern) {
                this.pathPattern = pathPattern;
                return this;
            }

            public Builder targetOriginId(String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            public Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            public Builder allowedMethods(List<String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            public Builder cachedMethods(List<String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            public Builder cachePolicyId(String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            public Builder compress(Boolean compress) {
                this.compress = compress;
                return this;
            }

            public Builder compress(IResolvable compress) {
                this.compress = compress;
                return this;
            }

            public Builder defaultTtl(Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            public Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            public Builder forwardedValues(IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder forwardedValues(ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            public Builder lambdaFunctionAssociations(IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder lambdaFunctionAssociations(List<Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            public Builder maxTtl(Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            public Builder minTtl(Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            public Builder originRequestPolicyId(String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            public Builder smoothStreaming(Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder smoothStreaming(IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            public Builder trustedSigners(List<String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            public CacheBehaviorProperty build() {
                return new Jsii.Proxy(this.pathPattern, this.targetOriginId, this.viewerProtocolPolicy, this.allowedMethods, this.cachedMethods, this.cachePolicyId, this.compress, this.defaultTtl, this.fieldLevelEncryptionId, this.forwardedValues, this.lambdaFunctionAssociations, this.maxTtl, this.minTtl, this.originRequestPolicyId, this.smoothStreaming, this.trustedSigners, null);
            }
        }
    }
}

