package software.amazon.awscdk.services.cloudfront;

/**
 * Properties to define an Origin.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.535Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.OriginProps")
@software.amazon.jsii.Jsii.Proxy(OriginProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OriginProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of times that CloudFront attempts to connect to the origin;
     * <p>
     * valid values are 1, 2, or 3 attempts.
     * <p>
     * Default: 3
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionAttempts() {
        return null;
    }

    /**
     * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
     * <p>
     * Valid values are 1-10 seconds, inclusive.
     * <p>
     * Default: Duration.seconds(10)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getConnectionTimeout() {
        return null;
    }

    /**
     * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
     * <p>
     * Default: {}
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getCustomHeaders() {
        return null;
    }

    /**
     * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     * <p>
     * Must begin, but not end, with '/' (e.g., '/production/images').
     * <p>
     * Default: '/'
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<OriginProps> {
        private java.lang.Number connectionAttempts;
        private software.amazon.awscdk.core.Duration connectionTimeout;
        private java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private java.lang.String originPath;

        /**
         * Sets the value of {@link OriginProps#getConnectionAttempts}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;.
         *                           valid values are 1, 2, or 3 attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionAttempts(java.lang.Number connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        /**
         * Sets the value of {@link OriginProps#getConnectionTimeout}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         *                          Valid values are 1-10 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionTimeout(software.amazon.awscdk.core.Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link OriginProps#getCustomHeaders}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customHeaders(java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        /**
         * Sets the value of {@link OriginProps#getOriginPath}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *                   Must begin, but not end, with '/' (e.g., '/production/images').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public OriginProps build() {
            return new Jsii$Proxy(connectionAttempts, connectionTimeout, customHeaders, originPath);
        }
    }

    /**
     * An implementation for {@link OriginProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginProps {
        private final java.lang.Number connectionAttempts;
        private final software.amazon.awscdk.core.Duration connectionTimeout;
        private final java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private final java.lang.String originPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionAttempts = this.jsiiGet("connectionAttempts", java.lang.Number.class);
            this.connectionTimeout = this.jsiiGet("connectionTimeout", software.amazon.awscdk.core.Duration.class);
            this.customHeaders = this.jsiiGet("customHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originPath = this.jsiiGet("originPath", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number connectionAttempts, final software.amazon.awscdk.core.Duration connectionTimeout, final java.util.Map<java.lang.String, java.lang.String> customHeaders, final java.lang.String originPath) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionAttempts = connectionAttempts;
            this.connectionTimeout = connectionTimeout;
            this.customHeaders = customHeaders;
            this.originPath = originPath;
        }

        @Override
        public java.lang.Number getConnectionAttempts() {
            return this.connectionAttempts;
        }

        @Override
        public software.amazon.awscdk.core.Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConnectionAttempts() != null) {
                data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
            }
            if (this.getConnectionTimeout() != null) {
                data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
            }
            if (this.getCustomHeaders() != null) {
                data.set("customHeaders", om.valueToTree(this.getCustomHeaders()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.OriginProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginProps.Jsii$Proxy that = (OriginProps.Jsii$Proxy) o;

            if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
            if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
            if (this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null) return false;
            return this.originPath != null ? this.originPath.equals(that.originPath) : that.originPath == null;
        }

        @Override
        public int hashCode() {
            int result = this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0;
            result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
            result = 31 * result + (this.customHeaders != null ? this.customHeaders.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            return result;
        }
    }
}
