package software.amazon.awscdk.services.cloudfront;

/**
 * Options for configuring custom error responses.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.533Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.ErrorResponse")
@software.amazon.jsii.Jsii.Proxy(ErrorResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ErrorResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP status code for which you want to specify a custom error page and/or a caching duration.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getHttpStatus();

    /**
     * The HTTP status code that you want CloudFront to return to the viewer along with the custom error page.
     * <p>
     * If you specify a value for <code>responseHttpStatus</code>, you must also specify a value for <code>responsePagePath</code>.
     * <p>
     * Default: - not set, the error code will be returned as the response code.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getResponseHttpStatus() {
        return null;
    }

    /**
     * The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the `httpStatus`, for example, /4xx-errors/403-forbidden.html.
     * <p>
     * Default: - the default CloudFront response is shown.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getResponsePagePath() {
        return null;
    }

    /**
     * The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ErrorCode.
     * <p>
     * Default: - the default caching TTL behavior applies
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ErrorResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ErrorResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ErrorResponse> {
        private java.lang.Number httpStatus;
        private java.lang.Number responseHttpStatus;
        private java.lang.String responsePagePath;
        private software.amazon.awscdk.core.Duration ttl;

        /**
         * Sets the value of {@link ErrorResponse#getHttpStatus}
         * @param httpStatus The HTTP status code for which you want to specify a custom error page and/or a caching duration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpStatus(java.lang.Number httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        /**
         * Sets the value of {@link ErrorResponse#getResponseHttpStatus}
         * @param responseHttpStatus The HTTP status code that you want CloudFront to return to the viewer along with the custom error page.
         *                           If you specify a value for <code>responseHttpStatus</code>, you must also specify a value for <code>responsePagePath</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseHttpStatus(java.lang.Number responseHttpStatus) {
            this.responseHttpStatus = responseHttpStatus;
            return this;
        }

        /**
         * Sets the value of {@link ErrorResponse#getResponsePagePath}
         * @param responsePagePath The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the `httpStatus`, for example, /4xx-errors/403-forbidden.html.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responsePagePath(java.lang.String responsePagePath) {
            this.responsePagePath = responsePagePath;
            return this;
        }

        /**
         * Sets the value of {@link ErrorResponse#getTtl}
         * @param ttl The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ErrorCode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ttl(software.amazon.awscdk.core.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ErrorResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ErrorResponse build() {
            return new Jsii$Proxy(httpStatus, responseHttpStatus, responsePagePath, ttl);
        }
    }

    /**
     * An implementation for {@link ErrorResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorResponse {
        private final java.lang.Number httpStatus;
        private final java.lang.Number responseHttpStatus;
        private final java.lang.String responsePagePath;
        private final software.amazon.awscdk.core.Duration ttl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpStatus = this.jsiiGet("httpStatus", java.lang.Number.class);
            this.responseHttpStatus = this.jsiiGet("responseHttpStatus", java.lang.Number.class);
            this.responsePagePath = this.jsiiGet("responsePagePath", java.lang.String.class);
            this.ttl = this.jsiiGet("ttl", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number httpStatus, final java.lang.Number responseHttpStatus, final java.lang.String responsePagePath, final software.amazon.awscdk.core.Duration ttl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpStatus = java.util.Objects.requireNonNull(httpStatus, "httpStatus is required");
            this.responseHttpStatus = responseHttpStatus;
            this.responsePagePath = responsePagePath;
            this.ttl = ttl;
        }

        @Override
        public java.lang.Number getHttpStatus() {
            return this.httpStatus;
        }

        @Override
        public java.lang.Number getResponseHttpStatus() {
            return this.responseHttpStatus;
        }

        @Override
        public java.lang.String getResponsePagePath() {
            return this.responsePagePath;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTtl() {
            return this.ttl;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpStatus", om.valueToTree(this.getHttpStatus()));
            if (this.getResponseHttpStatus() != null) {
                data.set("responseHttpStatus", om.valueToTree(this.getResponseHttpStatus()));
            }
            if (this.getResponsePagePath() != null) {
                data.set("responsePagePath", om.valueToTree(this.getResponsePagePath()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.ErrorResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ErrorResponse.Jsii$Proxy that = (ErrorResponse.Jsii$Proxy) o;

            if (!httpStatus.equals(that.httpStatus)) return false;
            if (this.responseHttpStatus != null ? !this.responseHttpStatus.equals(that.responseHttpStatus) : that.responseHttpStatus != null) return false;
            if (this.responsePagePath != null ? !this.responsePagePath.equals(that.responsePagePath) : that.responsePagePath != null) return false;
            return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
        }

        @Override
        public int hashCode() {
            int result = this.httpStatus.hashCode();
            result = 31 * result + (this.responseHttpStatus != null ? this.responseHttpStatus.hashCode() : 0);
            result = 31 * result + (this.responsePagePath != null ? this.responsePagePath.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            return result;
        }
    }
}
