package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for a Distribution.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.532Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.DistributionProps")
@software.amazon.jsii.Jsii.Proxy(DistributionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DistributionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The default behavior for the distribution.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.BehaviorOptions getDefaultBehavior();

    /**
     * Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
     * <p>
     * Default: - no additional behaviors are added.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> getAdditionalBehaviors() {
        return null;
    }

    /**
     * A certificate to associate with the distribution.
     * <p>
     * The certificate must be located in N. Virginia (us-east-1).
     * <p>
     * Default: - the CloudFront wildcard certificate (*.cloudfront.net) will be used.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * Any comments you want to include about the distribution.
     * <p>
     * Default: - no comment
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
     * <p>
     * Default: - no default root object
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootObject() {
        return null;
    }

    /**
     * Alternative domain names for this distribution.
     * <p>
     * If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
     * you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
     * you must add (at least one of) the domain names of the certificate to this list.
     * <p>
     * Default: - The distribution will only support the default generated name (e.g., d111111abcdef8.cloudfront.net)
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainNames() {
        return null;
    }

    /**
     * Enable or disable the distribution.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
     * <p>
     * If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
     * This allows viewers to submit a second request, for an IPv4 address for your distribution.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableIpv6() {
        return null;
    }

    /**
     * Enable access logging for the distribution.
     * <p>
     * Default: - false, unless `logBucket` is specified.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableLogging() {
        return null;
    }

    /**
     * How CloudFront should handle requests that are not successful (e.g., PageNotFound).
     * <p>
     * Default: - No custom error responses.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> getErrorResponses() {
        return null;
    }

    /**
     * Controls the countries in which your content is distributed.
     * <p>
     * Default: - No geographic restrictions
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.GeoRestriction getGeoRestriction() {
        return null;
    }

    /**
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
     * <p>
     * Default: HttpVersion.HTTP2
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.HttpVersion getHttpVersion() {
        return null;
    }

    /**
     * The Amazon S3 bucket to store the access logs in.
     * <p>
     * Default: - A bucket is created if `enableLogging` is true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getLogBucket() {
        return null;
    }

    /**
     * An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
     * <p>
     * Default: - no prefix
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogFilePrefix() {
        return null;
    }

    /**
     * Specifies whether you want CloudFront to include cookies in access logs.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogIncludesCookies() {
        return null;
    }

    /**
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service.
     * <p>
     * If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
     * If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
     * that has the lowest latency among the edge locations in your price class.
     * <p>
     * Default: PriceClass.PRICE_CLASS_ALL
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.PriceClass getPriceClass() {
        return null;
    }

    /**
     * Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
     * <p>
     * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
     * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * <p>
     * Default: - No AWS Web Application Firewall web access control list (web ACL).
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebAclId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DistributionProps> {
        private software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors;
        private software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private java.lang.String comment;
        private java.lang.String defaultRootObject;
        private java.util.List<java.lang.String> domainNames;
        private java.lang.Boolean enabled;
        private java.lang.Boolean enableIpv6;
        private java.lang.Boolean enableLogging;
        private java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses;
        private software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction;
        private software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion;
        private software.amazon.awscdk.services.s3.IBucket logBucket;
        private java.lang.String logFilePrefix;
        private java.lang.Boolean logIncludesCookies;
        private software.amazon.awscdk.services.cloudfront.PriceClass priceClass;
        private java.lang.String webAclId;

        /**
         * Sets the value of {@link DistributionProps#getDefaultBehavior}
         * @param defaultBehavior The default behavior for the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultBehavior(software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getAdditionalBehaviors}
         * @param additionalBehaviors Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalBehaviors(java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors) {
            this.additionalBehaviors = additionalBehaviors;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getCertificate}
         * @param certificate A certificate to associate with the distribution.
         *                    The certificate must be located in N. Virginia (us-east-1).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getComment}
         * @param comment Any comments you want to include about the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getDefaultRootObject}
         * @param defaultRootObject The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultRootObject(java.lang.String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getDomainNames}
         * @param domainNames Alternative domain names for this distribution.
         *                    If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
         *                    you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
         *                    you must add (at least one of) the domain names of the certificate to this list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainNames(java.util.List<java.lang.String> domainNames) {
            this.domainNames = domainNames;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnabled}
         * @param enabled Enable or disable the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnableIpv6}
         * @param enableIpv6 Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
         *                   If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
         *                   This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableIpv6(java.lang.Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getEnableLogging}
         * @param enableLogging Enable access logging for the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getErrorResponses}
         * @param errorResponses How CloudFront should handle requests that are not successful (e.g., PageNotFound).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder errorResponses(java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses) {
            this.errorResponses = errorResponses;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getGeoRestriction}
         * @param geoRestriction Controls the countries in which your content is distributed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder geoRestriction(software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction) {
            this.geoRestriction = geoRestriction;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getHttpVersion}
         * @param httpVersion Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
         *                    For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpVersion(software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogBucket}
         * @param logBucket The Amazon S3 bucket to store the access logs in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logBucket(software.amazon.awscdk.services.s3.IBucket logBucket) {
            this.logBucket = logBucket;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogFilePrefix}
         * @param logFilePrefix An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logFilePrefix(java.lang.String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getLogIncludesCookies}
         * @param logIncludesCookies Specifies whether you want CloudFront to include cookies in access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logIncludesCookies(java.lang.Boolean logIncludesCookies) {
            this.logIncludesCookies = logIncludesCookies;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getPriceClass}
         * @param priceClass The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *                   If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
         *                   If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
         *                   that has the lowest latency among the edge locations in your price class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder priceClass(software.amazon.awscdk.services.cloudfront.PriceClass priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        /**
         * Sets the value of {@link DistributionProps#getWebAclId}
         * @param webAclId Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
         *                 To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
         *                 <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         *                 To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder webAclId(java.lang.String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DistributionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DistributionProps build() {
            return new Jsii$Proxy(defaultBehavior, additionalBehaviors, certificate, comment, defaultRootObject, domainNames, enabled, enableIpv6, enableLogging, errorResponses, geoRestriction, httpVersion, logBucket, logFilePrefix, logIncludesCookies, priceClass, webAclId);
        }
    }

    /**
     * An implementation for {@link DistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionProps {
        private final software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String comment;
        private final java.lang.String defaultRootObject;
        private final java.util.List<java.lang.String> domainNames;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean enableIpv6;
        private final java.lang.Boolean enableLogging;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses;
        private final software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction;
        private final software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion;
        private final software.amazon.awscdk.services.s3.IBucket logBucket;
        private final java.lang.String logFilePrefix;
        private final java.lang.Boolean logIncludesCookies;
        private final software.amazon.awscdk.services.cloudfront.PriceClass priceClass;
        private final java.lang.String webAclId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultBehavior = this.jsiiGet("defaultBehavior", software.amazon.awscdk.services.cloudfront.BehaviorOptions.class);
            this.additionalBehaviors = this.jsiiGet("additionalBehaviors", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.BehaviorOptions.class)));
            this.certificate = this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
            this.comment = this.jsiiGet("comment", java.lang.String.class);
            this.defaultRootObject = this.jsiiGet("defaultRootObject", java.lang.String.class);
            this.domainNames = this.jsiiGet("domainNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.enableIpv6 = this.jsiiGet("enableIpv6", java.lang.Boolean.class);
            this.enableLogging = this.jsiiGet("enableLogging", java.lang.Boolean.class);
            this.errorResponses = this.jsiiGet("errorResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ErrorResponse.class)));
            this.geoRestriction = this.jsiiGet("geoRestriction", software.amazon.awscdk.services.cloudfront.GeoRestriction.class);
            this.httpVersion = this.jsiiGet("httpVersion", software.amazon.awscdk.services.cloudfront.HttpVersion.class);
            this.logBucket = this.jsiiGet("logBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.logFilePrefix = this.jsiiGet("logFilePrefix", java.lang.String.class);
            this.logIncludesCookies = this.jsiiGet("logIncludesCookies", java.lang.Boolean.class);
            this.priceClass = this.jsiiGet("priceClass", software.amazon.awscdk.services.cloudfront.PriceClass.class);
            this.webAclId = this.jsiiGet("webAclId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudfront.BehaviorOptions defaultBehavior, final java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> additionalBehaviors, final software.amazon.awscdk.services.certificatemanager.ICertificate certificate, final java.lang.String comment, final java.lang.String defaultRootObject, final java.util.List<java.lang.String> domainNames, final java.lang.Boolean enabled, final java.lang.Boolean enableIpv6, final java.lang.Boolean enableLogging, final java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> errorResponses, final software.amazon.awscdk.services.cloudfront.GeoRestriction geoRestriction, final software.amazon.awscdk.services.cloudfront.HttpVersion httpVersion, final software.amazon.awscdk.services.s3.IBucket logBucket, final java.lang.String logFilePrefix, final java.lang.Boolean logIncludesCookies, final software.amazon.awscdk.services.cloudfront.PriceClass priceClass, final java.lang.String webAclId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultBehavior = java.util.Objects.requireNonNull(defaultBehavior, "defaultBehavior is required");
            this.additionalBehaviors = additionalBehaviors;
            this.certificate = certificate;
            this.comment = comment;
            this.defaultRootObject = defaultRootObject;
            this.domainNames = domainNames;
            this.enabled = enabled;
            this.enableIpv6 = enableIpv6;
            this.enableLogging = enableLogging;
            this.errorResponses = errorResponses;
            this.geoRestriction = geoRestriction;
            this.httpVersion = httpVersion;
            this.logBucket = logBucket;
            this.logFilePrefix = logFilePrefix;
            this.logIncludesCookies = logIncludesCookies;
            this.priceClass = priceClass;
            this.webAclId = webAclId;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.BehaviorOptions getDefaultBehavior() {
            return this.defaultBehavior;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudfront.BehaviorOptions> getAdditionalBehaviors() {
            return this.additionalBehaviors;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public java.lang.String getDefaultRootObject() {
            return this.defaultRootObject;
        }

        @Override
        public java.util.List<java.lang.String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        @Override
        public java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cloudfront.ErrorResponse> getErrorResponses() {
            return this.errorResponses;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.GeoRestriction getGeoRestriction() {
            return this.geoRestriction;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.HttpVersion getHttpVersion() {
            return this.httpVersion;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getLogBucket() {
            return this.logBucket;
        }

        @Override
        public java.lang.String getLogFilePrefix() {
            return this.logFilePrefix;
        }

        @Override
        public java.lang.Boolean getLogIncludesCookies() {
            return this.logIncludesCookies;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.PriceClass getPriceClass() {
            return this.priceClass;
        }

        @Override
        public java.lang.String getWebAclId() {
            return this.webAclId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultBehavior", om.valueToTree(this.getDefaultBehavior()));
            if (this.getAdditionalBehaviors() != null) {
                data.set("additionalBehaviors", om.valueToTree(this.getAdditionalBehaviors()));
            }
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getDefaultRootObject() != null) {
                data.set("defaultRootObject", om.valueToTree(this.getDefaultRootObject()));
            }
            if (this.getDomainNames() != null) {
                data.set("domainNames", om.valueToTree(this.getDomainNames()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEnableIpv6() != null) {
                data.set("enableIpv6", om.valueToTree(this.getEnableIpv6()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getErrorResponses() != null) {
                data.set("errorResponses", om.valueToTree(this.getErrorResponses()));
            }
            if (this.getGeoRestriction() != null) {
                data.set("geoRestriction", om.valueToTree(this.getGeoRestriction()));
            }
            if (this.getHttpVersion() != null) {
                data.set("httpVersion", om.valueToTree(this.getHttpVersion()));
            }
            if (this.getLogBucket() != null) {
                data.set("logBucket", om.valueToTree(this.getLogBucket()));
            }
            if (this.getLogFilePrefix() != null) {
                data.set("logFilePrefix", om.valueToTree(this.getLogFilePrefix()));
            }
            if (this.getLogIncludesCookies() != null) {
                data.set("logIncludesCookies", om.valueToTree(this.getLogIncludesCookies()));
            }
            if (this.getPriceClass() != null) {
                data.set("priceClass", om.valueToTree(this.getPriceClass()));
            }
            if (this.getWebAclId() != null) {
                data.set("webAclId", om.valueToTree(this.getWebAclId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.DistributionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DistributionProps.Jsii$Proxy that = (DistributionProps.Jsii$Proxy) o;

            if (!defaultBehavior.equals(that.defaultBehavior)) return false;
            if (this.additionalBehaviors != null ? !this.additionalBehaviors.equals(that.additionalBehaviors) : that.additionalBehaviors != null) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.defaultRootObject != null ? !this.defaultRootObject.equals(that.defaultRootObject) : that.defaultRootObject != null) return false;
            if (this.domainNames != null ? !this.domainNames.equals(that.domainNames) : that.domainNames != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.enableIpv6 != null ? !this.enableIpv6.equals(that.enableIpv6) : that.enableIpv6 != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.errorResponses != null ? !this.errorResponses.equals(that.errorResponses) : that.errorResponses != null) return false;
            if (this.geoRestriction != null ? !this.geoRestriction.equals(that.geoRestriction) : that.geoRestriction != null) return false;
            if (this.httpVersion != null ? !this.httpVersion.equals(that.httpVersion) : that.httpVersion != null) return false;
            if (this.logBucket != null ? !this.logBucket.equals(that.logBucket) : that.logBucket != null) return false;
            if (this.logFilePrefix != null ? !this.logFilePrefix.equals(that.logFilePrefix) : that.logFilePrefix != null) return false;
            if (this.logIncludesCookies != null ? !this.logIncludesCookies.equals(that.logIncludesCookies) : that.logIncludesCookies != null) return false;
            if (this.priceClass != null ? !this.priceClass.equals(that.priceClass) : that.priceClass != null) return false;
            return this.webAclId != null ? this.webAclId.equals(that.webAclId) : that.webAclId == null;
        }

        @Override
        public int hashCode() {
            int result = this.defaultBehavior.hashCode();
            result = 31 * result + (this.additionalBehaviors != null ? this.additionalBehaviors.hashCode() : 0);
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.defaultRootObject != null ? this.defaultRootObject.hashCode() : 0);
            result = 31 * result + (this.domainNames != null ? this.domainNames.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.enableIpv6 != null ? this.enableIpv6.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.errorResponses != null ? this.errorResponses.hashCode() : 0);
            result = 31 * result + (this.geoRestriction != null ? this.geoRestriction.hashCode() : 0);
            result = 31 * result + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
            result = 31 * result + (this.logBucket != null ? this.logBucket.hashCode() : 0);
            result = 31 * result + (this.logFilePrefix != null ? this.logFilePrefix.hashCode() : 0);
            result = 31 * result + (this.logIncludesCookies != null ? this.logIncludesCookies.hashCode() : 0);
            result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
            result = 31 * result + (this.webAclId != null ? this.webAclId.hashCode() : 0);
            return result;
        }
    }
}
